/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.topographicIndices;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class TopographicIndicesAlgorithm
extends GeoAlgorithm {
    private static final double ALMOST_ZERO = 0.0011;
    public static final String SLOPE = "SLOPE";
    public static final String ACCFLOW = "ACCFLOW";
    public static final String TWI = "TWI";
    public static final String SPI = "SPI";
    public static final String LS = "LS";
    private IRasterLayer m_Slope = null;
    private IRasterLayer m_AccFlow = null;
    private IRasterLayer m_WetnessIndex;
    private IRasterLayer m_StreamPowerIndex;
    private IRasterLayer m_LSFactor;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_AccFlow = this.m_Parameters.getParameterValueAsRasterLayer(ACCFLOW);
        this.m_Slope = this.m_Parameters.getParameterValueAsRasterLayer(SLOPE);
        this.m_WetnessIndex = this.getNewRasterLayer(TWI, Sextante.getText((String)"Topographic_Wetness_Index__TWI"), 4);
        this.m_StreamPowerIndex = this.getNewRasterLayer(SPI, Sextante.getText((String)"Stream_Power_Index"), 4);
        this.m_LSFactor = this.getNewRasterLayer(LS, Sextante.getText((String)"LS_factor"), 4);
        AnalysisExtent extent = this.m_WetnessIndex.getWindowGridExtent();
        this.m_Slope.setWindowExtent(extent);
        this.m_AccFlow.setWindowExtent(extent);
        int iNX = this.m_Slope.getNX();
        int iNY = this.m_Slope.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                this.calculateIndices(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Topographic_indices"));
        this.setGroup(Sextante.getText((String)"Indices_and_other_hydrological_parameters"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(SLOPE, Sextante.getText((String)"Slope"), true);
            this.m_Parameters.addInputRasterLayer(ACCFLOW, Sextante.getText((String)"Flow_accumulation"), true);
            this.addOutputRasterLayer(TWI, Sextante.getText((String)"Topographic_Wetness_Index__TWI"));
            this.addOutputRasterLayer(SPI, Sextante.getText((String)"Stream_Power_Index"));
            this.addOutputRasterLayer(LS, Sextante.getText((String)"LS_factor"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateIndices(int x, int y) {
        double dSlope = this.m_Slope.getCellValueAsDouble(x, y);
        double dAccFlow = this.m_AccFlow.getCellValueAsDouble(x, y);
        if (this.m_Slope.isNoDataValue(dSlope) || this.m_AccFlow.isNoDataValue(dAccFlow)) {
            this.m_WetnessIndex.setNoData(x, y);
            this.m_StreamPowerIndex.setNoData(x, y);
            this.m_LSFactor.setNoData(x, y);
        } else {
            dSlope = Math.max(Math.tan(dSlope), 0.0011);
            this.m_WetnessIndex.setCellValue(x, y, Math.log((dAccFlow /= this.m_AccFlow.getWindowCellSize()) / dSlope));
            this.m_StreamPowerIndex.setCellValue(x, y, dAccFlow * dSlope);
            this.m_LSFactor.setCellValue(x, y, 1.4 * Math.pow(dAccFlow / 22.13, 0.4) * Math.pow(Math.sin(dSlope) / 0.0896, 1.3));
        }
    }
}

