/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.viewshed;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.lighting.viewshed.EqualLengthVisibilitySegmentQueue;
import es.unex.sextante.lighting.viewshed.RangeOfSight;
import es.unex.sextante.lighting.viewshed.VisibilityCrossSection;
import es.unex.sextante.lighting.viewshed.VisibilityPair;
import es.unex.sextante.lighting.viewshed.VisibilityPolygon;
import es.unex.sextante.lighting.viewshed.VisibilitySegment;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class ApproximatedViewshedAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String POINT = "POINT";
    public static final String HEIGHT = "HEIGHT";
    public static final String HEIGHTOBS = "HEIGHTOBS";
    public static final String RADIUS = "RADIUS";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String RESULT = "RESULT";
    public static final String VISIBLE_FIELD = "Visible";
    private IRasterLayer m_DEM = null;
    private IVectorLayer m_visibilityLayer;
    private double m_watcherHeight;
    private double m_objectsHeight;
    double m_threshold;
    private int m_searchRadius;
    private double m_worldSearchRadius;
    private Coordinate m_watcherPoint;
    private GeometryFactory m_geoFactory;
    private double m_finishedAngles = 0.0;
    private AtomicInteger m_taskCount;
    private ExecutorService m_executor;
    private double m_minAllowedAngle;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Approximated_Viewshed"));
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"Coordinates_of_emitter-receiver"));
            this.m_Parameters.addNumericalValue(HEIGHT, Sextante.getText((String)"Height_of_emitter-receiver"), 10.0, 2);
            this.m_Parameters.addNumericalValue(HEIGHTOBS, Sextante.getText((String)"Height_of_mobile_receiver-emitter"), 0.0, 2);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 0.0, 2);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Approximated_viewshed_threshold"), 0.1, 2);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Viewshed_output"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        boolean bl;
        boolean result = false;
        try {
            this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
            this.m_watcherHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHT);
            this.m_objectsHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHTOBS);
            this.m_threshold = this.m_Parameters.getParameterValueAsDouble(THRESHOLD);
            this.m_worldSearchRadius = this.m_Parameters.getParameterValueAsDouble(RADIUS);
            this.m_searchRadius = (int)(this.m_worldSearchRadius / this.m_DEM.getLayerCellSize());
            Point2D watcherPoint = this.m_Parameters.getParameterValueAsPoint(POINT);
            this.m_watcherPoint = new Coordinate(watcherPoint.getX(), watcherPoint.getY());
            this.m_AnalysisExtent = new AnalysisExtent((ILayer)this.m_DEM);
            if (this.m_searchRadius > 0) {
                double outputXMin = Math.max(this.m_watcherPoint.x - this.m_worldSearchRadius, this.m_AnalysisExtent.getXMin());
                double outputXMax = Math.min(this.m_watcherPoint.x + this.m_worldSearchRadius, this.m_AnalysisExtent.getXMax());
                double outputYMin = Math.max(this.m_watcherPoint.y - this.m_worldSearchRadius, this.m_AnalysisExtent.getYMin());
                double outputYMax = Math.min(this.m_watcherPoint.y + this.m_worldSearchRadius, this.m_AnalysisExtent.getYMax());
                this.m_AnalysisExtent.setXRange(outputXMin, outputXMax, true);
                this.m_AnalysisExtent.setYRange(outputYMin, outputYMax, true);
            }
            this.m_DEM.setWindowExtent(this.m_AnalysisExtent);
            this.m_visibilityLayer = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Viewshed_output"), 2, new Class[]{Integer.class}, new String[]{VISIBLE_FIELD});
            this.m_geoFactory = new GeometryFactory();
            result = this.calculateVisibility();
            bl = !this.m_Task.isCanceled();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this.ClearData();
        }
        return result &= bl;
    }

    private void ClearData() {
        this.m_DEM = null;
        this.m_visibilityLayer = null;
        this.m_watcherPoint = null;
        this.m_geoFactory = null;
        this.m_taskCount = null;
        this.m_executor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculateVisibility() {
        try {
            this.m_watcherPoint.z = this.m_DEM.getValueAt(this.m_watcherPoint.x, this.m_watcherPoint.y);
            if (this.m_DEM.isNoDataValue(this.m_watcherPoint.z)) {
                return false;
            }
            this.m_minAllowedAngle = new LineSegment(0.0, 0.0, this.m_worldSearchRadius, this.m_DEM.getLayerCellSize()).angle();
            this.m_watcherPoint.z += this.m_watcherHeight;
            int STARTING_SLICES = 10;
            double alpha = 0.6283185307179586;
            this.m_taskCount = new AtomicInteger(0);
            this.m_executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            for (int sliceIndex = 0; sliceIndex < 10; ++sliceIndex) {
                double angle1 = (double)sliceIndex * 0.6283185307179586;
                double angle2 = (double)(sliceIndex + 1) * 0.6283185307179586;
                VisibilityCrossSection crossSection = new VisibilityCrossSection(this.CreateROS(angle1), this.CreateROS(angle2), angle1, angle2);
                this.m_taskCount.getAndIncrement();
                this.m_executor.execute(new CrossSectionWorker(crossSection));
            }
            while (this.m_taskCount.get() > 0 && !this.m_Task.isCanceled()) {
                AtomicInteger atomicInteger = this.m_taskCount;
                synchronized (atomicInteger) {
                    this.m_taskCount.wait(10L);
                }
            }
            this.m_executor.shutdownNow();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private List<Coordinate> CreateROS(double angle) {
        Coordinate edgePoint = new Coordinate(this.m_watcherPoint.x + this.m_worldSearchRadius * Math.cos(angle), this.m_watcherPoint.y + this.m_worldSearchRadius * Math.sin(angle));
        return new RangeOfSight(this.m_DEM, this.m_objectsHeight).Calculate(this.m_watcherPoint, edgePoint);
    }

    private void extrapolateSliceVisibility(List<Coordinate> firstSliceROS, List<Coordinate> secondSliceROS) {
        EqualLengthVisibilitySegmentQueue visibilitySegmentQueue = new EqualLengthVisibilitySegmentQueue(firstSliceROS, secondSliceROS, this.m_DEM.getLayerCellSize());
        VisibilityPolygon previousRightSidePolygon = null;
        VisibilityPolygon previousUpperPart = null;
        VisibilityPolygon previousLowerPart = null;
        VisibilitySegment previousSegment1 = null;
        VisibilitySegment previousSegment2 = null;
        Coordinate previousDiagonalIntersection = null;
        VisibilityPolygon aggregatedVisiblityPolygon = null;
        while (!visibilitySegmentQueue.isEmpty()) {
            VisibilityPair pair = visibilitySegmentQueue.poll();
            VisibilitySegment segment1 = pair.getFirstSegment();
            VisibilitySegment segment2 = pair.getSecondSegment();
            if (segment1 == null || segment2 == null) {
                VisibilityPolygon triangle;
                int triangleVisibility = segment1 == null ? segment2.getVisibility() : segment1.getVisibility();
                VisibilityPolygon visibilityPolygon = triangle = segment1 == null ? this.CreatePolygon(triangleVisibility, previousSegment1.p1, segment2.p1, segment2.p0, previousSegment1.p1) : this.CreatePolygon(triangleVisibility, previousSegment2.p1, segment1.p1, segment1.p0, previousSegment2.p1);
                if (previousRightSidePolygon != null) {
                    triangle.union(previousRightSidePolygon);
                    if (aggregatedVisiblityPolygon.visibility() == triangle.visibility()) {
                        aggregatedVisiblityPolygon.union(triangle);
                        if (previousUpperPart.visibility() != aggregatedVisiblityPolygon.visibility()) {
                            this.AddFeature(previousUpperPart);
                        } else {
                            this.AddFeature(previousLowerPart);
                        }
                    } else {
                        this.AddFeature(aggregatedVisiblityPolygon);
                        if (previousUpperPart.visibility() == triangle.visibility()) {
                            triangle.union(previousUpperPart);
                        } else {
                            triangle.union(previousLowerPart);
                        }
                        aggregatedVisiblityPolygon = triangle;
                    }
                    previousRightSidePolygon = null;
                } else if (aggregatedVisiblityPolygon.visibility() == triangle.visibility()) {
                    aggregatedVisiblityPolygon.union(triangle);
                } else {
                    this.AddFeature(aggregatedVisiblityPolygon);
                    aggregatedVisiblityPolygon = triangle;
                }
            } else if (segment1.getVisibility() == segment2.getVisibility()) {
                VisibilityPolygon rect;
                int rectVisibility = segment1.getVisibility();
                VisibilityPolygon visibilityPolygon = rect = segment1.p0.equals2D(segment2.p0) ? this.CreatePolygon(rectVisibility, segment1.p0, segment1.p1, segment2.p1, segment1.p0) : this.CreatePolygon(rectVisibility, segment1.p0, segment1.p1, segment2.p1, segment2.p0, segment1.p0);
                if (aggregatedVisiblityPolygon == null) {
                    aggregatedVisiblityPolygon = rect;
                } else if (previousRightSidePolygon != null) {
                    rect.union(previousRightSidePolygon);
                    if (rect.visibility() != aggregatedVisiblityPolygon.visibility()) {
                        this.AddFeature(aggregatedVisiblityPolygon);
                        if (previousUpperPart.visibility() == rect.visibility()) {
                            rect.union(previousUpperPart);
                        } else {
                            rect.union(previousLowerPart);
                        }
                        aggregatedVisiblityPolygon = rect;
                    } else {
                        aggregatedVisiblityPolygon.union(rect);
                        if (previousUpperPart.visibility() != aggregatedVisiblityPolygon.visibility()) {
                            this.AddFeature(previousUpperPart);
                        } else {
                            this.AddFeature(previousLowerPart);
                        }
                    }
                    previousRightSidePolygon = null;
                } else if (rect.visibility() == aggregatedVisiblityPolygon.visibility()) {
                    aggregatedVisiblityPolygon.union(rect);
                } else {
                    this.AddFeature(aggregatedVisiblityPolygon);
                    aggregatedVisiblityPolygon = rect;
                }
            } else {
                LineSegment leftDiagonal = new LineSegment(segment1.p0, segment2.p1);
                LineSegment rightDiagonal = new LineSegment(segment1.p1, segment2.p0);
                Coordinate diagonalIntersection = leftDiagonal.intersection(rightDiagonal);
                VisibilityPolygon upperPart = this.CreatePolygon(segment1.getVisibility(), segment1.p0, segment1.p1, diagonalIntersection, segment1.p0);
                VisibilityPolygon lowerPart = this.CreatePolygon(segment2.getVisibility(), segment2.p0, segment2.p1, diagonalIntersection, segment2.p0);
                VisibilityPolygon leftPart = this.CreatePolygon(-1, segment1.p0, diagonalIntersection, segment2.p0, segment1.p0);
                if (previousRightSidePolygon == null) {
                    aggregatedVisiblityPolygon.union(leftPart);
                    if (upperPart.visibility() == aggregatedVisiblityPolygon.visibility()) {
                        aggregatedVisiblityPolygon.union(upperPart);
                        upperPart = aggregatedVisiblityPolygon;
                    } else {
                        aggregatedVisiblityPolygon.union(lowerPart);
                        lowerPart = aggregatedVisiblityPolygon;
                    }
                } else {
                    Coordinate middlePoint = new LineSegment(segment1.p0, segment2.p0).midPoint();
                    VisibilityPolygon previousRightPart1 = this.CreatePolygon(previousSegment1.getVisibility(), segment1.p0, middlePoint, previousDiagonalIntersection, segment1.p0);
                    VisibilityPolygon previousRightPart2 = this.CreatePolygon(previousSegment2.getVisibility(), segment2.p0, middlePoint, previousDiagonalIntersection, segment2.p0);
                    VisibilityPolygon leftPart1 = this.CreatePolygon(segment1.getVisibility(), segment1.p0, diagonalIntersection, middlePoint, segment1.p0);
                    VisibilityPolygon leftPart2 = this.CreatePolygon(segment2.getVisibility(), segment2.p0, diagonalIntersection, middlePoint, segment2.p0);
                    previousUpperPart.union(previousRightPart1);
                    previousLowerPart.union(previousRightPart2);
                    upperPart.union(leftPart1);
                    lowerPart.union(leftPart2);
                    this.AddFeature(previousUpperPart);
                    this.AddFeature(previousLowerPart);
                    aggregatedVisiblityPolygon = upperPart;
                }
                previousRightSidePolygon = this.CreatePolygon(-1, segment1.p1, diagonalIntersection, segment2.p1, segment1.p1);
                previousDiagonalIntersection = diagonalIntersection;
                previousUpperPart = upperPart;
                previousLowerPart = lowerPart;
            }
            previousSegment1 = segment1 != null ? segment1 : previousSegment1;
            previousSegment2 = segment2 != null ? segment2 : previousSegment2;
        }
        if (previousRightSidePolygon != null) {
            aggregatedVisiblityPolygon.union(previousRightSidePolygon);
            if (previousUpperPart.visibility() != aggregatedVisiblityPolygon.visibility()) {
                this.AddFeature(previousUpperPart);
            } else {
                this.AddFeature(previousLowerPart);
            }
        }
        this.AddFeature(aggregatedVisiblityPolygon);
    }

    private double SliceDistance(List<Coordinate> firstSliceROS, List<Coordinate> secondSliceROS) {
        EqualLengthVisibilitySegmentQueue visibilitySegmentQueue = new EqualLengthVisibilitySegmentQueue(firstSliceROS, secondSliceROS, this.m_DEM.getLayerCellSize());
        double difference = 0.0;
        double totalLength = 0.0;
        while (!visibilitySegmentQueue.isEmpty()) {
            VisibilityPair pair = visibilitySegmentQueue.poll();
            VisibilitySegment segment1 = pair.getFirstSegment();
            VisibilitySegment segment2 = pair.getSecondSegment();
            if (segment1 == null || segment2 == null) break;
            double segmentLength = segment1.getLength();
            totalLength += segmentLength;
            if (segment1.getVisibility() == segment2.getVisibility()) continue;
            difference += segmentLength;
        }
        return difference / totalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AddFeature(VisibilityPolygon poly) {
        ExecutorService executorService = this.m_executor;
        synchronized (executorService) {
            this.m_visibilityLayer.addFeature((Geometry)poly.polygon(), new Object[]{poly.visibility()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress(double sliceAngle) {
        ExecutorService executorService = this.m_executor;
        synchronized (executorService) {
            this.m_finishedAngles += sliceAngle;
            this.setProgress((int)(this.m_finishedAngles * 180.0 / Math.PI), 360);
        }
    }

    private VisibilityPolygon CreatePolygon(int visiblity, Coordinate ... coordinates) {
        if (coordinates[0] != coordinates[coordinates.length - 1]) {
            ArrayList<Coordinate> coordList = new ArrayList<Coordinate>(coordinates.length + 1);
            for (Coordinate coord : coordinates) {
                coordList.add(coord);
            }
            coordList.add(coordinates[0]);
            coordinates = CoordinateArrays.toCoordinateArray(coordList);
        }
        Polygon poly = this.m_geoFactory.createPolygon(this.m_geoFactory.createLinearRing(coordinates), null);
        return new VisibilityPolygon(poly, visiblity);
    }

    private class CrossSectionWorker
    implements Runnable {
        private final VisibilityCrossSection m_crossSection;

        public CrossSectionWorker(VisibilityCrossSection crossSection) {
            this.m_crossSection = crossSection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double sliceAngle = this.m_crossSection.getAngle2() - this.m_crossSection.getAngle1();
            double crossSectionDistance = ApproximatedViewshedAlgorithm.this.SliceDistance(this.m_crossSection.getRangeOfSight1(), this.m_crossSection.getRangeOfSight2());
            if (sliceAngle < 2.0 * ApproximatedViewshedAlgorithm.this.m_minAllowedAngle || sliceAngle / Math.PI * crossSectionDistance < ApproximatedViewshedAlgorithm.this.m_threshold) {
                ApproximatedViewshedAlgorithm.this.extrapolateSliceVisibility(this.m_crossSection.getRangeOfSight1(), this.m_crossSection.getRangeOfSight2());
                ApproximatedViewshedAlgorithm.this.updateProgress(sliceAngle);
                int previousWorkCount = ApproximatedViewshedAlgorithm.this.m_taskCount.getAndDecrement();
                if (previousWorkCount == 1) {
                    AtomicInteger atomicInteger = ApproximatedViewshedAlgorithm.this.m_taskCount;
                    synchronized (atomicInteger) {
                        ApproximatedViewshedAlgorithm.this.m_taskCount.notify();
                    }
                }
            } else {
                double middleSectionAngle = (this.m_crossSection.getAngle1() + this.m_crossSection.getAngle2()) / 2.0;
                List middleROS = ApproximatedViewshedAlgorithm.this.CreateROS(middleSectionAngle);
                ApproximatedViewshedAlgorithm.this.m_taskCount.getAndIncrement();
                VisibilityCrossSection firstHalf = new VisibilityCrossSection(this.m_crossSection.getRangeOfSight1(), middleROS, this.m_crossSection.getAngle1(), middleSectionAngle);
                ApproximatedViewshedAlgorithm.this.m_executor.execute(new CrossSectionWorker(firstHalf));
                VisibilityCrossSection secondHalf = new VisibilityCrossSection(middleROS, this.m_crossSection.getRangeOfSight2(), middleSectionAngle, this.m_crossSection.getAngle2());
                ApproximatedViewshedAlgorithm.this.m_executor.execute(new CrossSectionWorker(secondHalf));
            }
        }
    }
}

