/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.visualExposure;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class VisualExposureAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String FEATURES = "FEATURES";
    public static final String WEIGHTS = "WEIGHTS";
    public static final String METHOD = "METHOD";
    public static final String RADIUS = "RADIUS";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private int m_iMethod;
    private int m_iRadius;
    private int m_iRadius2;
    private IRasterLayer m_Exposure;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Features = null;
    private IRasterLayer m_Weights = null;

    public boolean processAlgorithm() {
        try {
            this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
            this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
            this.m_Weights = this.m_Parameters.getParameterValueAsRasterLayer(WEIGHTS);
            this.m_Features = this.m_Parameters.getParameterValueAsRasterLayer(FEATURES);
            this.m_Exposure = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Exposure"), 3);
            this.m_DEM.setWindowExtent(this.getAnalysisExtent());
            this.m_Weights.setWindowExtent(this.getAnalysisExtent());
            this.m_Features.setWindowExtent(this.getAnalysisExtent());
            this.m_Features.setInterpolationMethod(0);
            this.m_iRadius = (int)Math.ceil(this.m_Parameters.getParameterValueAsDouble(RADIUS) / this.m_DEM.getWindowCellSize());
            this.m_iRadius2 = (int)Math.ceil(Math.pow(this.m_Parameters.getParameterValueAsDouble(RADIUS), 2.0) / Math.pow(this.m_DEM.getWindowCellSize(), 2.0));
            this.m_Exposure.assign(0.0);
            this.m_iNX = this.m_DEM.getNX();
            this.m_iNY = this.m_DEM.getNY();
            for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
                for (int x = 0; x < this.m_iNX; ++x) {
                    double dValue = this.m_Features.getCellValueAsDouble(x, y);
                    if (this.m_Features.isNoDataValue(dValue) || dValue == 0.0) continue;
                    if (this.m_iMethod == 0) {
                        this.Irradiate(x, y);
                        continue;
                    }
                    this.Collect(x, y);
                }
            }
            this.m_Exposure.setNoDataValue(0.0);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Irradiate"), Sextante.getText((String)"Colect_values")};
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
        this.setName(Sextante.getText((String)"Visual_exposure"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(FEATURES, Sextante.getText((String)"Elements"), true);
            this.m_Parameters.addInputRasterLayer(WEIGHTS, Sextante.getText((String)"Weight"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 1000.0, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Visual_exposure"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void Irradiate(int x, int y) {
        double dWeight = this.m_Weights.getCellValueAsDouble(x, y);
        double z = this.m_DEM.getCellValueAsDouble(x, y) + this.m_Features.getCellValueAsDouble(x, y);
        int iXMin = Math.max(0, x - this.m_iRadius);
        int iXMax = Math.min(this.m_iNX, x + this.m_iRadius) + 1;
        int iYMin = Math.max(0, y - this.m_iRadius);
        int iYMax = Math.max(this.m_iNY, y + this.m_iRadius) + 1;
        for (int y2 = iYMin; y2 < iYMax; ++y2) {
            for (int x2 = iXMin; x2 < iXMax; ++x2) {
                double dz;
                double z2;
                int dx = x - x2;
                int dy = y - y2;
                if (dx * dx + dy * dy >= this.m_iRadius2 || this.m_DEM.isNoDataValue(z2 = this.m_DEM.getCellValueAsDouble(x2, y2)) || !this.tracePoint(x2, y2, dx, dy, dz = z - z2)) continue;
                this.m_Exposure.addToCellValue(x2, y2, dWeight);
            }
        }
    }

    private void Collect(int x, int y) {
        double z = this.m_DEM.getCellValueAsDouble(x, y) + this.m_Features.getCellValueAsDouble(x, y);
        int iXMin = Math.max(0, x - this.m_iRadius);
        int iXMax = Math.min(this.m_iNX, x + this.m_iRadius) + 1;
        int iYMin = Math.max(0, y - this.m_iRadius);
        int iYMax = Math.max(this.m_iNY, y + this.m_iRadius) + 1;
        for (int y2 = iYMin; y2 < iYMax; ++y2) {
            for (int x2 = iXMin; x2 < iXMax; ++x2) {
                double dz;
                double z2;
                int dx = x - x2;
                int dy = y - y2;
                if (dx * dx + dy * dy >= this.m_iRadius2 || this.m_DEM.isNoDataValue(z2 = this.m_DEM.getCellValueAsDouble(x2, y2)) || !this.tracePoint(x2, y2, dx, dy, dz = z - z2)) continue;
                this.m_Exposure.addToCellValue(x, y, this.m_Weights.getCellValueAsDouble(x2, y2));
            }
        }
    }

    boolean tracePoint(int x, int y, double dx, double dy, double dz) {
        double d = Math.abs(dx) > Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        double zmax = this.m_DEM.getMaxValue();
        if (d > 0.0) {
            double dist = Math.sqrt(dx * dx + dy * dy);
            dx /= d;
            dy /= d;
            dz /= d;
            d = dist / d;
            double id = 0.0;
            double ix = (double)x + 0.5;
            double iy = (double)y + 0.5;
            double iz = this.m_DEM.getCellValueAsDouble(x, y);
            while (id < dist) {
                id += d;
                iz += dz;
                x = (int)(ix += dx);
                y = (int)(iy += dy);
                if (!this.m_DEM.getWindowGridExtent().containsCell(x, y)) {
                    return true;
                }
                if (iz < this.m_DEM.getCellValueAsDouble(x, y)) {
                    return false;
                }
                if (!(iz > zmax)) continue;
                return true;
            }
        }
        return true;
    }
}

