/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.elevationReliefIndex;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ElevationReliefIndexAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String RESULT = "RESULT";
    IRasterLayer m_ERIndex;
    IRasterLayer m_DEM = null;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_ERIndex = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Elevation-relief_ratio"), 4);
        AnalysisExtent extent = this.m_ERIndex.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        int iNX = this.m_DEM.getNX();
        int iNY = this.m_DEM.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                this.calculateERIndex(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Elevation-relief_ratio"));
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Elevation-relief_ratio"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateERIndex(int x, int y) {
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_DEM.isNoDataValue(z)) {
            this.m_ERIndex.setNoData(x, y);
        } else {
            double dMinZ;
            double dMaxZ = dMinZ = z;
            double dAvgZ = z;
            int iCells = 0;
            for (int i = 0; i < 8; ++i) {
                z = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                if (this.m_DEM.isNoDataValue(z)) continue;
                ++iCells;
                dAvgZ += z;
                dMinZ = Math.min(dMinZ, z);
                dMaxZ = Math.max(dMaxZ, z);
            }
            if (iCells == 0) {
                this.m_ERIndex.setNoData(x, y);
            } else if (dMaxZ != dMinZ) {
                double dIndex = (dAvgZ - dMinZ) / (dMaxZ - dMinZ);
                this.m_ERIndex.setCellValue(x, y, dIndex);
            } else {
                this.m_ERIndex.setNoData(x, y);
            }
        }
    }
}

