/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.nonSpatial.calculator;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import java.util.HashMap;
import java.util.Set;
import org.nfunk.jep.JEP;

public class CalculatorAlgorithm
extends GeoAlgorithm {
    public static final String FORMULA = "FORMULA";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Calculator"));
        this.setGroup(Sextante.getText((String)"nonSpatial"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addString(FORMULA, Sextante.getText((String)"Formula"));
            this.addOutputNumericalValue(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException repeatedParameterNameException) {
            // empty catch block
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA);
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        jep.parseExpression(sFormula);
        if (jep.hasError()) {
            Sextante.addErrorToLog((String)jep.getErrorInfo());
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Syntax_error"));
        }
        this.addOutputNumericalValue(RESULT, jep.getValue());
        return true;
    }

    public boolean preprocessForModeller(Object obj) throws GeoAlgorithmExecutionException {
        ModelAlgorithm model = (ModelAlgorithm)obj;
        try {
            String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA);
            HashMap inputs = model.getInputs();
            Set set = inputs.keySet();
            for (Object key : set) {
                Object input = inputs.get(key);
                if (input instanceof Double && sFormula.contains((String)key)) {
                    sFormula = sFormula.replace(key.toString(), input.toString());
                }
                if (!(input instanceof ModelElementNumericalValue) || !sFormula.contains(((String)key).toLowerCase())) continue;
                return false;
            }
            this.m_Parameters.getParameter(FORMULA).setParameterValue((Object)sFormula);
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Syntax_error"));
        }
        return true;
    }
}

