/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.other.localiza;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class LocalizaAlgorithm
extends GeoAlgorithm {
    public void defineCharacteristics() {
        this.setName("localiza");
        this.setGroup("localiza");
        try {
            this.m_Parameters.addFilepath("FILEPATH", "filepath", true, false, false, "txt");
            this.addOutputVectorLayer("LAYER", "Resultado");
        }
        catch (RepeatedParameterNameException e) {
            e.printStackTrace();
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        GeometryFactory gf = new GeometryFactory();
        String sFolder = this.m_Parameters.getParameterValueAsString("FILEPATH");
        HashMap<String, Point> map = new HashMap<String, Point>();
        boolean bFirstLine = true;
        String sID = null;
        Class[] types = new Class[]{String.class, String.class};
        String[] sFields = new String[]{"ID", "Poblaci\u00c3\u00b3n"};
        IVectorLayer layer = this.getNewVectorLayer("LAYER", "Resultado", 0, types, sFields);
        try {
            String[] sTokens;
            BufferedReader input = new BufferedReader(new FileReader(sFolder + File.separator + "SECCION.txt"));
            String sLine = null;
            while ((sLine = input.readLine()) != null) {
                sTokens = sLine.split(" ");
                if (bFirstLine) {
                    sID = sTokens[0];
                } else {
                    Point pt = gf.createPoint(new Coordinate(Double.parseDouble(sTokens[1]), Double.parseDouble(sTokens[3])));
                    map.put(sID, pt);
                }
                bFirstLine = !bFirstLine;
            }
            input.close();
            input = new BufferedReader(new FileReader(sFolder + File.separator + "poblacion.txt"));
            while ((sLine = input.readLine()) != null) {
                sTokens = sLine.split(" ");
                sID = sLine.substring(0, 3).trim();
                String sPop = sLine.substring(4).trim();
                layer.addFeature((Geometry)map.get(sID), new Object[]{sID, sPop});
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

