/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.pointAnalysis.spatialCorrelation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.util.Arrays;

public class SpatialCorrelationAlgorithm
extends GeoAlgorithm {
    public static final String CLOUD = "CLOUD";
    public static final String RESULT = "RESULT";
    public static final String INTERVAL = "INTERVAL";
    public static final String POINTS = "POINTS";
    public static final String FIELD = "FIELD";
    private IVectorLayer m_Layer;
    private int m_iField;
    private double m_dMaxDist = 0.0;
    private double m_dInterval;
    private double m_dMean;
    private double[] m_dFieldValue;
    private double[] m_dMoran;
    private double[] m_dGeary;
    private double[] m_dSemivar;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_dMean = 0.0;
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_dInterval = this.m_Parameters.getParameterValueAsDouble(INTERVAL);
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int iCount = this.m_Layer.getShapesCount();
        if (iCount == 0) {
            throw new GeoAlgorithmExecutionException("0 points in layer");
        }
        double[][] d = new double[iCount][iCount];
        this.m_dFieldValue = new double[iCount];
        int i = 0;
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            double x1 = coord.x;
            double y1 = coord.y;
            try {
                double dValue = Double.parseDouble(feature.getRecord().getValue(this.m_iField).toString());
                this.m_dMean += dValue;
                this.m_dFieldValue[i] = dValue;
            }
            catch (NumberFormatException e) {
                throw new GeoAlgorithmExecutionException(Sextante.getText((String)"ERROR_Spatial_autocorrelation_Invalid_value_in_table"));
            }
            int j = 0;
            IFeatureIterator iter2 = this.m_Layer.iterator();
            while (iter2.hasNext()) {
                IFeature feature2 = iter2.next();
                Geometry geom2 = feature2.getGeometry();
                Coordinate coord2 = geom2.getCoordinate();
                double x2 = coord2.x;
                double y2 = coord2.y;
                double dDifX = x2 - x1;
                double dDifY = y2 - y1;
                d[i][j] = Math.sqrt(dDifX * dDifX + dDifY * dDifY);
                this.m_dMaxDist = Math.max(this.m_dMaxDist, d[i][j]);
                ++j;
            }
            iter2.close();
            ++i;
        }
        iter.close();
        this.m_dMean /= (double)iCount;
        if (this.calculate(d)) {
            this.createTables();
        }
        return !this.m_Task.isCanceled();
    }

    private void createTables() throws UnsupportedOutputChannelException {
        int iClasses = (int)(this.m_dMaxDist / this.m_dInterval + 2.0);
        String[] sFields = new String[]{Sextante.getText((String)"Distance"), Sextante.getText((String)"Moran_I"), Sextante.getText((String)"Geary_c"), Sextante.getText((String)"Semivariance")};
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class};
        String sTableName = Sextante.getText((String)"Spatial_autocorrelation_[") + this.m_Layer.getName() + "]";
        Object[] values = new Object[4];
        ITable driver = this.getNewTable(RESULT, sTableName, types, sFields);
        for (int i = 0; i < iClasses; ++i) {
            values[0] = new Double(this.m_dInterval * (double)i);
            values[1] = new Double(this.m_dMoran[i]);
            values[2] = new Double(this.m_dGeary[i]);
            values[3] = new Double(this.m_dSemivar[i]);
            driver.addRecord(values);
        }
    }

    private boolean calculate(double[][] dist) throws UnsupportedOutputChannelException {
        int i;
        Object[] values = null;
        ITable driver = null;
        String[] sFields = new String[]{Sextante.getText((String)"Distance"), Sextante.getText((String)"Semivariance")};
        Class[] types = new Class[]{Double.class, Double.class};
        String sTableName = Sextante.getText((String)"Variogram_cloud_[") + this.m_Layer.getName() + "]";
        values = new Object[2];
        driver = this.getNewTable(CLOUD, sTableName, types, sFields);
        int iClasses = (int)(this.m_dMaxDist / this.m_dInterval + 2.0);
        this.m_dMoran = new double[iClasses];
        this.m_dGeary = new double[iClasses];
        double[] dDen = new double[iClasses];
        this.m_dSemivar = new double[iClasses];
        int[] iPointsInClass = new int[iClasses];
        boolean[] bIsInClass = new boolean[iClasses];
        for (i = 0; i < dist.length && this.setProgress(i, dist.length); ++i) {
            int j;
            Arrays.fill(bIsInClass, false);
            for (j = 0; j < dist.length; ++j) {
                int iClass;
                int n = iClass = (int)Math.floor((dist[i][j] + this.m_dInterval / 2.0) / this.m_dInterval);
                iPointsInClass[n] = iPointsInClass[n] + 1;
                double dSemivar = Math.pow(this.m_dFieldValue[i] - this.m_dFieldValue[j], 2.0);
                values[0] = new Double(dist[i][j]);
                values[1] = new Double(dSemivar / 2.0);
                driver.addRecord(values);
                int n2 = iClass;
                this.m_dSemivar[n2] = this.m_dSemivar[n2] + dSemivar;
                int n3 = iClass;
                this.m_dMoran[n3] = this.m_dMoran[n3] + (this.m_dFieldValue[i] - this.m_dMean) * (this.m_dFieldValue[j] - this.m_dMean);
                this.m_dGeary[iClass] = this.m_dSemivar[iClass];
                bIsInClass[iClass] = true;
            }
            for (j = 0; j < iClasses; ++j) {
                if (!bIsInClass[j]) continue;
                int n = j;
                dDen[n] = dDen[n] + Math.pow(this.m_dFieldValue[i] - this.m_dMean, 2.0);
            }
        }
        for (i = 0; i < iClasses; ++i) {
            if (dDen[i] == 0.0) continue;
            int n = i;
            this.m_dMoran[n] = this.m_dMoran[n] / dDen[i];
            int n4 = i;
            this.m_dGeary[n4] = this.m_dGeary[n4] * ((double)(iPointsInClass[i] - 1) / (2.0 * (double)iPointsInClass[i] * dDen[i]));
            int n5 = i;
            this.m_dSemivar[n5] = this.m_dSemivar[n5] / (2.0 * (double)iPointsInClass[i]);
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Spatial_autocorrelation"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), POINTS);
            this.m_Parameters.addNumericalValue(INTERVAL, Sextante.getText((String)"Distance_interval"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.addOutputTable(RESULT, Sextante.getText((String)"Spatial_autocorrelation"));
            this.addOutputTable(CLOUD, Sextante.getText((String)"Nube_del_variograma"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

