/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.profiles.profile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ProfileAlgorithm
extends GeoAlgorithm {
    public static final String ROUTE = "ROUTE";
    public static final String DEM = "DEM";
    public static final String LAYERS = "LAYERS";
    public static final String PROFILEPOINTS = "PROFILEPOINTS";
    public static final String GRAPH = "GRAPH";
    public static final String INTERPOLATE = "INTERPOLATE";
    private IVectorLayer m_Profile;
    private IRasterLayer m_DEM;
    private IRasterLayer[] m_Layer;
    private double m_dDist = 0.0;
    private double m_dHorzDist = 0.0;
    private double m_dLastX;
    private double m_dLastY;
    private double m_dLastZ;
    private int m_iPoints = 0;
    private XYSeries serie;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        XYSeriesCollection dataset = new XYSeriesCollection();
        this.serie = new XYSeries((Comparable)((Object)Sextante.getText((String)"Profile")));
        dataset.addSeries(this.serie);
        boolean bInterpolate = this.m_Parameters.getParameterValueAsBoolean(INTERPOLATE);
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(ROUTE);
        if (lines.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Zero_lines_in_layer"));
        }
        ArrayList layers = this.m_Parameters.getParameterValueAsArrayList(LAYERS);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_DEM.setFullExtent();
        if (!bInterpolate) {
            this.m_DEM.setInterpolationMethod(0);
        }
        AnalysisExtent extent = this.m_DEM.getWindowGridExtent();
        this.m_Layer = new IRasterLayer[layers.size()];
        for (i = 0; i < layers.size(); ++i) {
            this.m_Layer[i] = (IRasterLayer)layers.get(i);
            this.m_Layer[i].setWindowExtent(extent);
            if (bInterpolate) continue;
            this.m_Layer[i].setInterpolationMethod(0);
        }
        String[] sFieldNames = new String[layers.size() + 5];
        sFieldNames[0] = "X";
        sFieldNames[1] = "Y";
        sFieldNames[2] = "Z";
        sFieldNames[3] = Sextante.getText((String)"ProjDist");
        sFieldNames[4] = Sextante.getText((String)"RealDist");
        for (i = 0; i < layers.size(); ++i) {
            sFieldNames[i + 5] = this.m_Layer[i].getName();
        }
        Class[] types = new Class[layers.size() + 5];
        for (i = 0; i < types.length; ++i) {
            types[i] = Double.class;
        }
        this.m_Profile = this.getNewVectorLayer(PROFILEPOINTS, Sextante.getText((String)"Profile_[points]"), 0, types, sFieldNames);
        IFeatureIterator iterator = lines.iterator();
        Geometry line = iterator.next().getGeometry().getGeometryN(0);
        this.processLine(line);
        iterator.close();
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel jPanelChart = new ChartPanel(chart);
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.addOutputChart(GRAPH, Sextante.getText((String)"Profile"), jPanelChart);
        return true;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Profile"));
        this.setGroup(Sextante.getText((String)"Profiles"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(ROUTE, Sextante.getText((String)"Profile_route"), 1, true);
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addMultipleInput(LAYERS, Sextante.getText((String)"Additional_layers"), 1, false);
            this.m_Parameters.addBoolean(INTERPOLATE, Sextante.getText((String)"Use_interpolation"), false);
            this.addOutputVectorLayer(PROFILEPOINTS, Sextante.getText((String)"Profile_[points]"), 0);
            this.addOutputChart(GRAPH, Sextante.getText((String)"Profile"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void processLine(Geometry line) {
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1 && this.setProgress(i, coords.length - 1); ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            this.processSegment(x, y, x2, y2);
        }
    }

    private void processSegment(double x, double y, double x2, double y2) {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= this.m_DEM.getWindowCellSize();
                dy /= dx;
                dx = this.m_DEM.getWindowCellSize();
            } else {
                n = dy /= this.m_DEM.getWindowCellSize();
                dx /= dy;
                dy = this.m_DEM.getWindowCellSize();
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                this.addPoint(x, y);
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    private void addPoint(double x, double y) {
        Object[] values = new Object[this.m_Layer.length + 5];
        double z = this.m_DEM.getValueAt(x, y);
        if (this.m_iPoints == 0) {
            this.m_dDist = 0.0;
            this.m_dHorzDist = 0.0;
        } else {
            double dDX = x - this.m_dLastX;
            double dDY = y - this.m_dLastY;
            double dDZ = this.m_DEM.isNoDataValue(z) || this.m_DEM.isNoDataValue(this.m_dLastZ) ? 0.0 : z - this.m_dLastZ;
            this.m_dDist += Math.sqrt(dDX * dDX + dDY * dDY);
            this.m_dHorzDist += Math.sqrt(dDX * dDX + dDY * dDY + dDZ * dDZ);
        }
        this.m_dLastX = x;
        this.m_dLastY = y;
        this.m_dLastZ = z;
        ++this.m_iPoints;
        Point geometry = new GeometryFactory().createPoint(new Coordinate(x, y));
        values[0] = new Double(x);
        values[1] = new Double(y);
        values[2] = new Double(z);
        values[3] = new Double(this.m_dDist);
        values[4] = new Double(this.m_dHorzDist);
        for (int i = 0; i < this.m_Layer.length; ++i) {
            double dValue = this.m_Layer[i].getValueAt(x, y);
            values[i + 5] = new Double(dValue);
        }
        if (!this.m_DEM.isNoDataValue(z)) {
            this.serie.add(this.m_dDist, z);
        }
        this.m_Profile.addFeature((Geometry)geometry, values);
    }
}

