/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.statisticalMethods.pdfChiSquared;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.pdf.PDF;

public class PDFChiSquaredAlgorithm
extends GeoAlgorithm {
    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Chi_squared_probability_distribution"));
        this.setGroup(Sextante.getText((String)"Statistical_methods"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer("INPUT", Sextante.getText((String)"Raster_layer"), true);
            this.m_Parameters.addNumericalValue("DEGREES", Sextante.getText((String)"Degrees_of_freedom"), 1, 2.0, 0.0, 2.147483647E9);
            this.m_Parameters.addBoolean("CDF", Sextante.getText((String)"Accumulated_probability"), false);
            this.addOutputRasterLayer("PROBABILITY", Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer window = this.m_Parameters.getParameterValueAsRasterLayer("INPUT");
        boolean bCDF = this.m_Parameters.getParameterValueAsBoolean("CDF");
        int iDegrees = this.m_Parameters.getParameterValueAsInt("DEGREES");
        window.setFullExtent();
        AnalysisExtent gridExtent = new AnalysisExtent((ILayer)window);
        IRasterLayer result = this.getNewRasterLayer("PROBABILITY", Sextante.getText((String)"Probability__chi_squared"), 5, gridExtent);
        int iNX = window.getNX();
        int iNY = window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = window.getCellValueAsDouble(x, y);
                if (!window.isNoDataValue(dValue)) {
                    if (bCDF) {
                        result.setCellValue(x, y, PDF.chiSquareCDF((double)dValue, (int)iDegrees));
                        continue;
                    }
                    result.setCellValue(x, y, PDF.chiSquare((double)dValue, (int)iDegrees));
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

