/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.statisticalMethods.regression;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.math.regression.Regression;
import es.unex.sextante.rasterWrappers.GridCell;
import java.text.DecimalFormat;

public class RegressionAlgorithm
extends GeoAlgorithm {
    public static final String METHOD = "METHOD";
    public static final String RESIDUALS = "RESIDUALS";
    public static final String RESULT = "RESULT";
    public static final String FIELD = "FIELD";
    public static final String POINTS = "POINTS";
    public static final String RASTER = "RASTER";
    public static final String REGRESSION_DATA = "REGRESSION_DATA";
    private int m_iField;
    private IVectorLayer m_Residuals;
    private IRasterLayer m_Window;
    private IRasterLayer m_Result;
    Regression m_Regression;
    private IVectorLayer m_Points;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{"y = a + b * x", "y = a + b / x", "y = a / (b - x)", "y = a * x^b", "y = a e^(b * x)", "y = a + b * ln(x)"};
        this.setName(Sextante.getText((String)"Regression"));
        this.setGroup(Sextante.getText((String)"Statistical_methods"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), POINTS);
            this.m_Parameters.addInputRasterLayer(RASTER, Sextante.getText((String)"Raster_layer"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Equation"), sMethod);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
            this.addOutputVectorLayer(RESIDUALS, Sextante.getText((String)"Residuals"), 0);
            this.addOutputText(REGRESSION_DATA, Sextante.getText((String)"Regression_values"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String[] sFieldNames = new String[]{Sextante.getText((String)"Real_value"), Sextante.getText((String)"Predictor_value"), Sextante.getText((String)"Estimated_value"), Sextante.getText((String)"Diference"), Sextante.getText((String)"Variance")};
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class};
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (this.m_Points.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Invalid_input_data"));
        }
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(RASTER);
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Regression"), 5);
        AnalysisExtent extent = this.m_Result.getWindowGridExtent();
        this.m_Window.setWindowExtent(extent);
        this.m_Residuals = this.getNewVectorLayer(RESIDUALS, Sextante.getText((String)"Residuals"), 0, types, sFieldNames);
        this.calculateRegression();
        this.calculateResultingGrid();
        this.calculateResiduals();
        this.addRegressionInfo();
        return !this.m_Task.isCanceled();
    }

    private void addRegressionInfo() {
        DecimalFormat df = new DecimalFormat("####.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Regression"));
        doc.addHeader(Sextante.getText((String)"Regression"), 2);
        doc.startUnorderedList();
        doc.addListElement(this.m_Regression.getExpression());
        doc.addListElement("R2 = " + df.format(this.m_Regression.getR2()));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(REGRESSION_DATA, Sextante.getText((String)"Regression_values"), doc.getHTMLCode());
    }

    private void calculateResiduals() throws IteratorException {
        Object[] value = new Object[5];
        AnalysisExtent extent = this.m_Result.getWindowGridExtent();
        double v = 100.0 / this.m_Regression.getYVar();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate pt = geom.getCoordinate();
            double dValue = Double.parseDouble(feature.getRecord().getValue(this.m_iField).toString());
            GridCell cell = extent.getGridCoordsFromWorldCoords(pt.x, pt.y);
            double dGridValue = this.m_Result.getCellValueAsDouble(cell.getX(), cell.getY());
            if (this.m_Result.isNoDataValue(dGridValue)) continue;
            value[0] = new Double(dValue);
            dValue = this.m_Window.getValueAt(pt.x, pt.y);
            value[1] = new Double(dValue);
            dValue = this.m_Regression.getY(dValue);
            value[2] = new Double(dValue);
            value[3] = new Double(dValue -= ((Double)value[0]).doubleValue());
            value[4] = new Double(dValue * v);
            this.m_Residuals.addFeature(geom, value);
        }
        iter.close();
    }

    private void calculateResultingGrid() {
        int iNX = this.m_Window.getNX();
        int iNY = this.m_Window.getNY();
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue)) {
                    this.m_Result.setNoData(x, y);
                    continue;
                }
                this.m_Result.setCellValue(x, y, this.m_Regression.getY(dValue));
            }
        }
    }

    private void calculateRegression() throws GeoAlgorithmExecutionException {
        this.m_Regression = new Regression();
        int iType = 1;
        try {
            iType = this.m_Parameters.getParameterValueAsInt(METHOD) + 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate pt = geom.getCoordinate();
            double dGridValue = this.m_Window.getValueAt(pt.x, pt.y);
            if (this.m_Window.isNoDataValue(dGridValue)) continue;
            try {
                double dValue = Double.parseDouble(feature.getRecord().getValue(this.m_iField).toString());
                this.m_Regression.addValue(dGridValue, dValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        iter.close();
        boolean bReturn = this.m_Regression.calculate(iType);
        if (!bReturn) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Could_not_calculate_regression"));
        }
    }
}

