/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.vectorFieldCalculator;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.shapesTools.ShapesTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.nfunk.jep.JEP;

public class VectorFieldCalculatorAlgorithm
extends GeoAlgorithm {
    private static final Object NO_DATA = new Double(-99999.0);
    public static final String FORMULA = "FORMULA";
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        Class[] types = new Class[]{Double.class};
        String[] sFields = new String[]{Sextante.getText((String)"Result")};
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA).toLowerCase();
        sFormula = sFormula.replaceAll(" ", "");
        sFormula = this.replaceDots(sFormula);
        String[] fieldNames = layer.getFieldNames();
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<Integer> variableIndex = new ArrayList<Integer>();
        for (i = 0; i < fieldNames.length; ++i) {
            String sVariable = fieldNames[i].toLowerCase();
            sVariable = sVariable.replaceAll(" ", "");
            if (sFormula.lastIndexOf(sVariable = this.replaceDots(sVariable)) == -1) continue;
            jep.addVariable(sVariable, 0.0);
            variables.add(sVariable);
            variableIndex.add(new Integer(i));
        }
        int[] iVariables = new int[variables.size()];
        String[] sVariables = new String[variables.size()];
        for (i = 0; i < variableIndex.size(); ++i) {
            iVariables[i] = (Integer)variableIndex.get(i);
            sVariables[i] = (String)variables.get(i);
        }
        jep.parseExpression(sFormula);
        int iTotalCount = layer.getShapesCount();
        Object[][] values = new Object[1][iTotalCount];
        if (!jep.hasError()) {
            IFeatureIterator iter = layer.iterator();
            int iCount = 0;
            while (iter.hasNext() && this.setProgress(iCount, iTotalCount)) {
                double dValue;
                IFeature feat = iter.next();
                boolean bOK = true;
                for (int j = 0; j < iVariables.length && bOK; ++j) {
                    try {
                        dValue = Double.parseDouble(feat.getRecord().getValue(iVariables[j]).toString());
                        jep.addVariable(sVariables[j], dValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        bOK = false;
                    }
                }
                if (bOK) {
                    dValue = jep.getValue();
                    values[0][iCount] = new Double(dValue);
                } else {
                    values[0][iCount] = NO_DATA;
                }
                ++iCount;
            }
        } else {
            throw new GeoAlgorithmExecutionException(jep.getErrorInfo());
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setDescription(Sextante.getText((String)"Result"));
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)layer, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Field_calculator"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addString(FORMULA, Sextante.getText((String)"Formula"));
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private String replaceDots(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length() - 1; ++i) {
            char c = sb.charAt(i);
            char c2 = sb.charAt(i + 1);
            if (c != '.' || Character.isDigit(c2)) continue;
            sb = sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public boolean preprocessForModeller(Object obj) throws GeoAlgorithmExecutionException {
        ModelAlgorithm model = (ModelAlgorithm)obj;
        String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA);
        HashMap inputs = model.getInputs();
        Set set = inputs.keySet();
        for (Object key : set) {
            Object input = inputs.get(key);
            if (input instanceof ModelElementNumericalValue && sFormula.contains((String)key)) {
                return false;
            }
            if (!sFormula.contains((String)key)) continue;
            sFormula = sFormula.replace(key.toString(), input.toString());
        }
        this.m_Parameters.getParameter(FORMULA).setParameterValue((Object)sFormula);
        return true;
    }
}

