/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.topology.extractEndpointsOfLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ExtractEndpointsOfLinesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Extract_endpoints_of_lines"));
        this.setGroup(Sextante.getText((String)"Topology"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_Layer"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] in_ftypes = layerIn.getFieldTypes();
        Class[] out_ftypes = new Class[in_ftypes.length + 2];
        System.arraycopy(in_ftypes, 0, out_ftypes, 0, in_ftypes.length);
        out_ftypes[out_ftypes.length - 2] = Integer.class;
        out_ftypes[out_ftypes.length - 1] = Integer.class;
        String[] in_fnames = layerIn.getFieldNames();
        String[] out_fnames = new String[in_ftypes.length + 2];
        System.arraycopy(in_fnames, 0, out_fnames, 0, in_fnames.length);
        out_fnames[out_fnames.length - 2] = "LINEFID";
        out_fnames[out_fnames.length - 1] = "ISSTART";
        IVectorLayer driver = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Endpoints"), 0, out_ftypes, out_fnames);
        IFeatureIterator iter = layerIn.iterator();
        int iTotal = layerIn.getShapesCount();
        Object[] values = new Object[out_fnames.length];
        int count = 0;
        GeometryFactory gf = new GeometryFactory();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            Coordinate[] coords = feature.getGeometry().getCoordinates();
            Object[] aux_values = feature.getRecord().getValues();
            System.arraycopy(aux_values, 0, values, 0, aux_values.length);
            values[values.length - 2] = count;
            values[values.length - 1] = 0;
            Point startPoint = gf.createPoint(coords[0]);
            driver.addFeature((Geometry)startPoint, values);
            System.arraycopy(aux_values, 0, values, 0, aux_values.length);
            values[values.length - 2] = ++count;
            values[values.length - 1] = 1;
            Point endPoint = gf.createPoint(coords[coords.length - 1]);
            driver.addFeature((Geometry)endPoint, values);
            this.setProgress(i, iTotal);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }
}

