/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.topology.extractNodes;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.dataObjects.IFeature;
import java.util.ArrayList;

public class Node {
    private int ID = 0;
    private final Geometry geom;
    IFeature lineFeature;
    private int degree;
    private final ArrayList lines;
    private final ArrayList linesIdx;
    private final ArrayList closeNodes;

    public Node(int iD, Geometry geom, IFeature lineFeature) {
        this.ID = iD;
        this.geom = geom;
        this.degree = 1;
        this.lineFeature = lineFeature;
        this.lines = new ArrayList();
        this.linesIdx = new ArrayList();
        this.closeNodes = new ArrayList();
    }

    public void incrementDegree() {
        ++this.degree;
    }

    public int getDegree() {
        return this.degree;
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public void addConnectedLine(IFeature feat, int idx) {
        if (!this.lines.contains(feat)) {
            this.lines.add(feat);
        }
        if (!this.linesIdx.contains(idx)) {
            this.linesIdx.add(idx);
        }
    }

    public void processIfClose(Node n, double tolerance) {
        if (this.closeNodes.contains(n) || n.getGeometry().equals(this.getGeometry())) {
            return;
        }
        Geometry g = n.getGeometry();
        double dist = this.geom.distance(g);
        if (dist < tolerance) {
            System.out.println("Added a node a " + dist);
            this.closeNodes.add(n);
        }
    }

    public ArrayList getCloseNodes() {
        return this.closeNodes;
    }

    public ArrayList getConnectedLines() {
        return this.lines;
    }

    public ArrayList getConnectedLinesIdx() {
        return this.linesIdx;
    }
}

