/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.cleanVectorLayer;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CleanVectorLayerAlgorithm
extends GeoAlgorithm {
    private static final String LAYER = "LAYER";
    private static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iWrongShapes = 0;
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), layer.getShapeType(), layer.getFieldTypes(), layer.getFieldNames());
        int iShapeCount = layer.getShapesCount();
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            try {
                IFeature feature = iter.next();
                output.addFeature(feature);
            }
            catch (Exception e) {
                ++iWrongShapes;
            }
            ++i;
        }
        String sInfo = Sextante.getText((String)"Eliminados_N_Registros_erroneos)");
        sInfo = sInfo.replace("XXX", Integer.toString(iWrongShapes));
        Sextante.addInfoToLog((String)sInfo);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Clean_vector_layer"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

