/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.dissolve;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.LayerCannotBeOverwrittenException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.vectorTools.dissolve.DissolveTableModel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class DissolveParametersPanel
extends GeoAlgorithmParametersPanel {
    private GeoAlgorithm m_Algorithm;
    private JLabel jLabelGroupings;
    private JComboBox jComboBoxField;
    private JTable jTableGroupings;
    private JComboBox jComboBoxLayers;
    private JLabel jLabelField;
    private JLabel jLabelLayer;
    private JScrollPane jScrollPaneFields;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    public void assignParameters() throws WrongInputException, LayerCannotBeOverwrittenException {
        OverwriteOutputChannel ooc;
        IOutputChannel channel;
        Output out;
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxLayers.getSelectedItem();
        IVectorLayer layer = (IVectorLayer)oad.getObject();
        ParametersSet params = this.m_Algorithm.getParameters();
        try {
            params.getParameter("LAYER").setParameterValue((Object)layer);
            params.getParameter("GROUPING_FIELD").setParameterValue((Object)this.jComboBoxField.getSelectedIndex());
            DissolveTableModel model = (DissolveTableModel)this.jTableGroupings.getModel();
            params.getParameter("GROUPING_FUNCTIONS").setParameterValue((Object)model.getAsString());
        }
        catch (WrongParameterIDException e) {
            throw new WrongInputException();
        }
        OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
        try {
            out = ooSet.getOutput("RESULT");
            channel = this.outputChannelSelectionPanel.getOutputChannel();
        }
        catch (Exception e) {
            throw new WrongInputException();
        }
        if (channel instanceof OverwriteOutputChannel && !(ooc = (OverwriteOutputChannel)channel).getLayer().canBeEdited()) {
            throw new LayerCannotBeOverwrittenException();
        }
        out.setOutputChannel(channel);
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, -1.0, 5.0}, {5.0, 25.0, 5.0, 25.0, 5.0, 25.0, -1.0, 5.0, 20.0, 5.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.setLayout((LayoutManager)thisLayout);
            this.setPreferredSize(new Dimension(469, 257));
            this.jLabelGroupings = new JLabel();
            this.add(this.jLabelGroupings, "1, 5");
            this.jLabelGroupings.setText(Sextante.getText((String)"Summary_statistics"));
            this.jScrollPaneFields = new JScrollPane();
            this.jScrollPaneFields.setHorizontalScrollBarPolicy(30);
            this.add(this.jScrollPaneFields, "1, 6, 2, 6");
            this.jTableGroupings = new JTable();
            this.jScrollPaneFields.setViewportView(this.jTableGroupings);
            this.jLabelLayer = new JLabel();
            this.add(this.jLabelLayer, "1, 1");
            this.jLabelLayer.setText(Sextante.getText((String)"Layer"));
            this.jLabelField = new JLabel();
            this.add(this.jLabelField, "1, 3");
            this.jLabelField.setText(Sextante.getText((String)"Field"));
            this.jComboBoxField = new JComboBox();
            this.add(this.jComboBoxField, "2, 3");
            DefaultComboBoxModel<ObjectAndDescription> jComboBoxLayersModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayers());
            this.jComboBoxLayers = new JComboBox();
            this.add(this.jComboBoxLayers, "2, 1");
            this.jComboBoxLayers.setModel(jComboBoxLayersModel);
            this.jComboBoxLayers.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DissolveParametersPanel.this.setFields();
                    DissolveParametersPanel.this.setTableModel();
                }
            });
            this.jComboBoxLayers.setSelectedIndex(0);
            this.setFields();
            this.setTableModel();
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
            this.add((Component)this.outputChannelSelectionPanel, "2,8");
            this.add(new JLabel(Sextante.getText((String)"Result")), "1,8");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void setFields() {
        DefaultComboBoxModel<String> jComboBoxFieldModel = new DefaultComboBoxModel<String>(this.getFields());
        this.jComboBoxField.setModel(jComboBoxFieldModel);
    }

    private void setTableModel() {
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxLayers.getSelectedItem();
        IVectorLayer layer = (IVectorLayer)oad.getObject();
        DissolveTableModel tableModel = new DissolveTableModel(layer);
        this.jTableGroupings.setModel(tableModel);
    }

    private String[] getFields() {
        ObjectAndDescription oad = (ObjectAndDescription)this.jComboBoxLayers.getSelectedItem();
        IVectorLayer layer = (IVectorLayer)oad.getObject();
        return this.getFields(layer);
    }

    private String[] getFields(IVectorLayer layer) {
        return layer.getFieldNames();
    }

    private ObjectAndDescription[] getLayers() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(2);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    public void setOutputValue(String sOutputName, String sValue) {
        this.outputChannelSelectionPanel.setText(sValue);
    }

    public void setParameterValue(String parameterName, String value) {
    }
}

