/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.fitNPointsInPolygon;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class FitNPointsInPolygonAlgorithm
extends GeoAlgorithm {
    private static final int MAX_REP = 50;
    public static final String POLYGONS = "POLYGONS";
    public static final String NPOINTS = "NPOINTS";
    public static final String NPOINTS_METHOD = "NPOINTS_METHOD";
    public static final String METHOD = "METHOD";
    public static final String RESULT = "RESULT";
    public static final String FIELD = "FIELD";
    public static final int NPOINTS_FIXED = 0;
    public static final int NPOINTS_FROM_FIELD = 1;
    public static final int METHOD_REGULARLY_SPACED = 0;
    public static final int METHOD_RANDOMLY = 1;
    public static final int METHOD_REGULARLY_SPACED_ALTERNATE = 2;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double y;
        double x;
        int iPointsIn = 0;
        int iRep = 0;
        int i = 0;
        String[] sFields = new String[]{"X", "Y"};
        Class[] types = new Class[]{Double.class, Double.class};
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> allPoints = new ArrayList<Point2D.Double>();
        Coordinate coord = new Coordinate();
        Object[] values = new Object[2];
        IVectorLayer polygons = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        int iPoints = this.m_Parameters.getParameterValueAsInt(NPOINTS);
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int iNPointsMethod = this.m_Parameters.getParameterValueAsInt(NPOINTS_METHOD);
        if (!this.m_bIsAutoExtent) {
            polygons.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        GeometryFactory gf = new GeometryFactory();
        int iShapeCount = polygons.getShapesCount();
        IFeatureIterator iter = polygons.iterator();
        while (iter.hasNext() && !this.m_Task.isCanceled()) {
            int j;
            double dDistSup;
            double dDistInf;
            double dDist;
            double dArea;
            this.setProgressText(Integer.toString(i) + "/" + Integer.toString(iShapeCount));
            IFeature feature = iter.next();
            Geometry geometry = feature.getGeometry();
            if (iNPointsMethod == 1) {
                try {
                    iPoints = Integer.parseInt(feature.getRecord().getValue(iField).toString());
                }
                catch (Exception e) {
                    iPoints = 0;
                }
            }
            Envelope extent = geometry.getEnvelopeInternal();
            if (iMethod == 0) {
                iRep = 0;
                dArea = geometry.getArea();
                dDist = Math.sqrt(dArea / (double)iPoints);
                dDistInf = Math.sqrt(dArea / (double)(iPoints + 2));
                dDistSup = Math.sqrt(dArea / (double)(iPoints - Math.min(2, iPoints - 1)));
                if (dDist > 0.0) {
                    do {
                        points.clear();
                        iPointsIn = 0;
                        ++iRep;
                        for (x = extent.getMinX(); x < extent.getMaxX(); x += dDist) {
                            for (y = extent.getMinY(); y < extent.getMaxY(); y += dDist) {
                                coord.x = x;
                                coord.y = y;
                                if (!geometry.contains((Geometry)gf.createPoint(coord))) continue;
                                points.add(new Point2D.Double(x, y));
                                this.setProgress(++iPointsIn, iPoints);
                            }
                        }
                        if (iPointsIn > iPoints) {
                            dDistInf = dDist;
                            dDist = (dDistInf + dDistSup) / 2.0;
                            continue;
                        }
                        if (iPointsIn >= iPoints) continue;
                        dDistSup = dDist;
                        dDist = (dDistInf + dDistSup) / 2.0;
                    } while (iPointsIn != iPoints && iRep < 50 && !this.m_Task.isCanceled());
                    for (j = 0; j < points.size(); ++j) {
                        allPoints.add(new Point2D.Double(((Point2D)points.get(j)).getX(), ((Point2D)points.get(j)).getY()));
                    }
                }
            } else if (iMethod == 1) {
                iPointsIn = 0;
                do {
                    x = Math.random() * extent.getWidth() + extent.getMinX();
                    y = Math.random() * extent.getHeight() + extent.getMinY();
                    coord.x = x;
                    coord.y = y;
                    if (!geometry.contains((Geometry)gf.createPoint(coord))) continue;
                    allPoints.add(new Point2D.Double(x, y));
                    ++iPointsIn;
                } while (iPointsIn != iPoints && this.setProgress(iPointsIn, iPoints));
            } else if (iMethod == 2) {
                iRep = 0;
                dArea = geometry.getArea();
                dDist = Math.sqrt(dArea / (double)iPoints);
                dDistInf = Math.sqrt(dArea / (double)(iPoints + 2));
                dDistSup = Math.sqrt(dArea / (double)(iPoints - Math.min(2, iPoints - 1)));
                if (dDist > 0.0) {
                    do {
                        points.clear();
                        iPointsIn = 0;
                        ++iRep;
                        for (x = extent.getMinX(); x < extent.getMaxX(); x += dDist) {
                            boolean bDisplace = false;
                            for (y = extent.getMinY(); y < extent.getMaxY(); y += dDist) {
                                coord.x = x;
                                coord.y = y;
                                if (bDisplace) {
                                    coord.x += dDist / 2.0;
                                }
                                boolean bl = bDisplace = !bDisplace;
                                if (!geometry.contains((Geometry)gf.createPoint(coord))) continue;
                                points.add(new Point2D.Double(coord.x, coord.y));
                                this.setProgress(++iPointsIn, iPoints);
                            }
                        }
                        if (iPointsIn > iPoints) {
                            dDistInf = dDist;
                            dDist = (dDistInf + dDistSup) / 2.0;
                            continue;
                        }
                        if (iPointsIn >= iPoints) continue;
                        dDistSup = dDist;
                        dDist = (dDistInf + dDistSup) / 2.0;
                    } while (iPointsIn != iPoints && iRep < 50 && !this.m_Task.isCanceled());
                    for (j = 0; j < points.size(); ++j) {
                        allPoints.add(new Point2D.Double(((Point2D)points.get(j)).getX(), ((Point2D)points.get(j)).getY()));
                    }
                }
            }
            ++i;
        }
        if (allPoints.size() != 0) {
            IVectorLayer outputLayer = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Points"), 0, types, sFields);
            for (i = 0; i < allPoints.size(); ++i) {
                x = ((Point2D)allPoints.get(i)).getX();
                y = ((Point2D)allPoints.get(i)).getY();
                values[0] = new Double(x);
                values[1] = new Double(y);
                Point pt = gf.createPoint(new Coordinate(x, y));
                outputLayer.addFeature((Geometry)pt, values);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sOptions = new String[]{Sextante.getText((String)"Regular_grid"), Sextante.getText((String)"Random"), Sextante.getText((String)"Regular_grid_alternate")};
        String[] sOptionsNPoints = new String[]{Sextante.getText((String)"Fixed_number"), Sextante.getText((String)"Take_from_table_field")};
        this.setName(Sextante.getText((String)"Adjust_n_point_to_polygon"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Polygons"), 2, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field_for_number_of_points"), POLYGONS);
            this.m_Parameters.addNumericalValue(NPOINTS, Sextante.getText((String)"Number_of_points"), 1, 10.0, 1.0, 2.147483647E9);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sOptions);
            this.m_Parameters.addSelection(NPOINTS_METHOD, Sextante.getText((String)"Number_of_points"), sOptionsNPoints);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Points"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            e.printStackTrace();
        }
        catch (OptionalParentParameterException e) {
            e.printStackTrace();
        }
    }
}

