/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.geometriesToPoints;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.gvsig.tools.exception.BaseException;

public class GeometriesToPointsAlgorithm
extends GeoAlgorithm {
    public static final String POINTS = "POINTS";
    public static final String INPUT = "INPUT";
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Geometries_to_points"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(INPUT, Sextante.getText((String)"Input_layer"), -1, true);
            this.addOutputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int subtype;
        IVectorLayer input = this.m_Parameters.getParameterValueAsVectorLayer(INPUT);
        if (!this.m_bIsAutoExtent) {
            input.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        try {
            subtype = input.getSubType();
        }
        catch (BaseException e) {
            subtype = 4;
        }
        this.m_Output = this.getNewVectorLayer(POINTS, input.getName() + "[" + Sextante.getText((String)"Points") + "]", 0, input.getFieldTypes(), input.getFieldNames(), subtype);
        int i = 0;
        int iShapeCount = input.getShapesCount();
        IFeatureIterator iter = input.iterator();
        GeometryFactory gf = new GeometryFactory();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            Coordinate[] coords;
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            for (Coordinate element : coords = geom.getCoordinates()) {
                this.m_Output.addFeature((Geometry)gf.createPoint(element), feature.getRecord().getValues());
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }
}

