/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.intersection;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class IntersectionAlgorithm
extends GeoAlgorithm {
    public static final String LAYER1 = "LAYER1";
    public static final String LAYER2 = "LAYER2";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        String layerName2;
        IVectorLayer layer1 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER1);
        IVectorLayer layer2 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER2);
        if (!this.m_bIsAutoExtent) {
            layer1.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            layer2.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] fieldTypes = new Class[layer1.getFieldCount() + layer2.getFieldCount()];
        String[] sFieldNames = new String[fieldTypes.length];
        String layerName1 = layer1.getName();
        if (layerName1.equalsIgnoreCase(layerName2 = layer2.getName())) {
            layerName1 = layerName1 + "1";
            layerName2 = layerName2 + "2";
        }
        for (i = 0; i < layer1.getFieldCount(); ++i) {
            fieldTypes[i] = layer1.getFieldType(i);
            sFieldNames[i] = layer1.getFieldName(i) + "_" + layerName1;
        }
        for (i = 0; i < layer2.getFieldCount(); ++i) {
            fieldTypes[i + layer1.getFieldCount()] = layer2.getFieldType(i);
            sFieldNames[i + layer1.getFieldCount()] = layer2.getFieldName(i) + "_" + layerName2;
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Intersection"), 2, fieldTypes, sFieldNames);
        IFeatureIterator iter = layer1.iterator();
        IFeatureIterator iter2 = layer2.iterator();
        int i2 = 0;
        int iShapeCount = layer1.getShapesCount();
        while (iter.hasNext() && this.setProgress(i2, iShapeCount)) {
            IFeature feature = iter.next();
            Object[] values = feature.getRecord().getValues();
            Geometry g = feature.getGeometry();
            iter2 = layer2.iterator();
            while (iter2.hasNext()) {
                IFeature feature2 = iter2.next();
                Geometry g2 = feature2.getGeometry();
                if (!g2.intersects(g)) continue;
                Object[] values2 = feature2.getRecord().getValues();
                Geometry inter = g.intersection(g2);
                Object[] resultValues = new Object[values.length + values2.length];
                System.arraycopy(values, 0, resultValues, 0, values.length);
                System.arraycopy(values2, 0, resultValues, values.length, values2.length);
                this.m_Output.addFeature(inter, resultValues);
            }
            ++i2;
        }
        iter.close();
        iter2.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Intersection"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER1, Sextante.getText((String)"Layer_1"), 2, true);
            this.m_Parameters.addInputVectorLayer(LAYER2, Sextante.getText((String)"Layer_2"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Intersection"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

