/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.saveToWKT;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class SaveToWKTAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    public static final String FILENAME = "FILENAME";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        String sFilename = this.m_Parameters.getParameterValueAsString(FILENAME);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        if (sFilename != null) {
            Writer output = null;
            WKTWriter wkt = new WKTWriter();
            try {
                output = new BufferedWriter(new FileWriter(sFilename));
                int iShapeCount = layer.getShapesCount();
                int i = 0;
                IFeatureIterator iter = layer.iterator();
                while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
                    try {
                        IFeature feature = iter.next();
                        Geometry geom = feature.getGeometry();
                        output.write("WKT=" + wkt.write(geom) + "\n");
                        int iFieldCount = feature.getRecord().getValues().length;
                        for (int j = 0; j < iFieldCount; ++j) {
                        }
                        ++i;
                    }
                    catch (IteratorException iteratorException) {}
                }
            }
            catch (IOException e) {
                throw new GeoAlgorithmExecutionException(e.getMessage());
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Save_geometries_as_WKT"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addFilepath(FILENAME, Sextante.getText((String)"File"), false, false, false, "wkt");
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean isSuitableForModelling() {
        return false;
    }
}

