/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.snapPoints;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.IteratorException;
import java.util.List;

public class NearestNeighbourFinder {
    private final STRtree m_Tree;
    private final int m_iPoints;

    public NearestNeighbourFinder(IVectorLayer layer, ITaskMonitor task) throws IteratorException {
        task.setProgressText(Sextante.getText((String)"Creating_index"));
        this.m_Tree = new STRtree();
        this.m_iPoints = layer.getShapesCount();
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && !task.isCanceled()) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            float x = (float)coord.x;
            float y = (float)coord.y;
            Envelope bounds = geom.getEnvelopeInternal();
            this.m_Tree.insert(bounds, (Object)geom);
            if (i % 50 == 0) {
                task.setProgress(i, this.m_iPoints);
            }
            ++i;
        }
        iter.close();
    }

    public List<Geometry> getClosestGeometries(Coordinate c, double dDistance) {
        Envelope search = new Envelope(c);
        search.expandBy(dDistance);
        List list = this.m_Tree.query(search);
        return list;
    }
}

