/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.URLConnectionHttpClient;

public class Twitter {
    private String TWITTER_URL = "http://api.twitter.com/1";
    public static final String version = "1.4.4";
    private String sourceApp = "jtwitterlib";
    private Integer pageNumber;
    private Long sinceId;
    private Date sinceDate;
    private Date untilDate;
    private int maxResults = -1;
    private final IHttpClient http;
    private final String name;
    Integer count;
    private String lang;
    private String geocode;

    public void setAPIRootUrl(String url) {
        assert (url.startsWith("http://") || url.startsWith("https://"));
        assert (!url.endsWith("/")) : "Please remove the trailing / from " + url;
        this.TWITTER_URL = url;
    }

    private static <K, V> Map<K, V> asMap(Object ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0);
        HashMap<Object, Object> m = new HashMap<Object, Object>(keyValuePairs.length / 2);
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            m.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return m;
    }

    static String unencode(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace("&quot;", "\"");
        text = text.replace("&apos;", "'");
        text = text.replace("&nbsp;", " ");
        text = text.replace("&amp;", "&");
        text = text.replace("&gt;", ">");
        text = text.replace("&lt;", "<");
        return text;
    }

    public static Date getDate(int year, String month, int day) {
        try {
            Field field = GregorianCalendar.class.getField(month.toUpperCase());
            int m = field.getInt(null);
            GregorianCalendar date = new GregorianCalendar(year, m, day);
            return date.getTime();
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x.getMessage());
        }
    }

    public static User getUser(String screenName, List<User> users) {
        assert (screenName != null && users != null);
        for (User user : users) {
            if (!screenName.equals(user.screenName)) continue;
            return user;
        }
        return null;
    }

    protected static String jsonGet(String key, JSONObject jsonObj) {
        Object val = jsonObj.opt(key);
        if (val == null) {
            return null;
        }
        if (JSONObject.NULL.equals(val)) {
            return null;
        }
        return val.toString();
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            Twitter tw = new Twitter(args[0], args[1]);
            Status s = tw.setStatus(args[2]);
            System.out.println(s);
            return;
        }
        System.out.println("Java interface for Twitter");
        System.out.println("--------------------------");
        System.out.println("Version 1.4.4");
        System.out.println("Released under LGPL by Winterwell Associates Ltd.");
        System.out.println("See source code or JavaDoc for details on how to use.");
    }

    private static URI URI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Twitter() {
        this(null, new URLConnectionHttpClient());
    }

    public Twitter(String name, IHttpClient client) {
        this.name = name;
        this.http = client;
    }

    public Twitter(String screenName, String password) {
        this(screenName, new URLConnectionHttpClient(screenName, password));
    }

    private Map<String, String> addStandardishParameters(Map<String, String> vars) {
        if (this.sinceId != null) {
            vars.put("since_id", this.sinceId.toString());
        }
        if (this.pageNumber != null) {
            vars.put("page", this.pageNumber.toString());
            this.pageNumber = null;
        }
        if (this.count != null) {
            vars.put("count", this.count.toString());
        }
        return vars;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    private Map<String, String> aMap(String ... keyValuePairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            map.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return map;
    }

    @Deprecated
    public User befriend(String username) throws TwitterException {
        return this.follow(username);
    }

    @Deprecated
    public User breakFriendship(String username) {
        return this.stopFollowing(username);
    }

    private <T extends ITweet> List<T> dateFilter(List<T> list) {
        if (this.sinceDate == null && this.untilDate == null) {
            return list;
        }
        ArrayList<ITweet> filtered = new ArrayList<ITweet>(list.size());
        for (ITweet message : list) {
            if (message.getCreatedAt() == null) {
                filtered.add(message);
                continue;
            }
            if (!this.notTooEarly(message) || !this.notTooLate(message)) continue;
            filtered.add(message);
        }
        return filtered;
    }

    private <T extends ITweet> boolean notTooEarly(T message) {
        return this.sinceDate == null || this.sinceDate.before(message.getCreatedAt());
    }

    private <T extends ITweet> boolean notTooLate(T message) {
        return this.untilDate == null || this.untilDate.after(message.getCreatedAt());
    }

    public void destroyStatus(long id) throws TwitterException {
        String page = this.post(this.TWITTER_URL + "/statuses/destroy/" + id + ".json", null, true);
        this.flush();
        assert (page != null);
    }

    public void destroyStatus(Status status) throws TwitterException {
        this.destroyStatus(status.getId());
    }

    void flush() {
        this.http.getPage("http://twitter.com/" + this.name, null, true);
    }

    public User follow(String username) throws TwitterException {
        String page;
        if (username == null) {
            throw new NullPointerException();
        }
        try {
            Map<String, String> vars = this.newMap("screen_name", username);
            page = this.post(this.TWITTER_URL + "/friendships/create.json", vars, true);
        }
        catch (TwitterException.E403 e) {
            if (this.isFollowing(username)) {
                return null;
            }
            throw e;
        }
        try {
            return new User(new JSONObject(page), null);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public void follow(User user) {
        this.follow(user.screenName);
    }

    public List<Message> getDirectMessages() {
        return this.getMessages(this.TWITTER_URL + "/direct_messages.json", this.standardishParameters());
    }

    public List<Message> getDirectMessagesSent() {
        return this.getMessages(this.TWITTER_URL + "/direct_messages/sent.json", this.standardishParameters());
    }

    public List<Status> getFavorites() {
        return this.getStatuses(this.TWITTER_URL + "/favorites.json", this.standardishParameters(), true);
    }

    public void setFavorite(Status status, boolean isFavorite) {
        String uri = isFavorite ? this.TWITTER_URL + "/favorites/create/" + status.id + ".json" : this.TWITTER_URL + "/favorites/destroy/" + status.id + ".json";
        this.http.getPage(uri, null, true);
    }

    public List<Status> getFavorites(String screenName) {
        Map<String, String> vars = this.newMap("screen_name", screenName);
        return this.getStatuses(this.TWITTER_URL + "/favorites.json", this.addStandardishParameters(vars), this.http.canAuthenticate());
    }

    public List<User> getFeatured() throws TwitterException {
        ArrayList<User> users = new ArrayList<User>();
        List<Status> featured = this.getPublicTimeline();
        for (Status status : featured) {
            User user = status.getUser();
            users.add(user);
        }
        return users;
    }

    public List<Long> getFollowerIDs() throws TwitterException {
        return this.getUserIDs(this.TWITTER_URL + "/followers/ids.json", null);
    }

    public List<Long> getFollowerIDs(String screenName) throws TwitterException {
        return this.getUserIDs(this.TWITTER_URL + "/followers/ids.json", screenName);
    }

    public List<User> getFollowers() throws TwitterException {
        return this.getUsers(this.TWITTER_URL + "/statuses/followers.json", null);
    }

    public List<User> getFollowers(String username) throws TwitterException {
        return this.getUsers(this.TWITTER_URL + "/statuses/followers.json", username);
    }

    public List<Long> getFriendIDs() throws TwitterException {
        return this.getUserIDs(this.TWITTER_URL + "/friends/ids.json", null);
    }

    public List<Long> getFriendIDs(String screenName) throws TwitterException {
        return this.getUserIDs(this.TWITTER_URL + "/friends/ids.json", screenName);
    }

    public List<User> getFriends() throws TwitterException {
        return this.getUsers(this.TWITTER_URL + "/statuses/friends.json", null);
    }

    public List<User> getFriends(String username) throws TwitterException {
        return this.getUsers(this.TWITTER_URL + "/statuses/friends.json", username);
    }

    public List<Status> getFriendsTimeline() throws TwitterException {
        return this.getStatuses(this.TWITTER_URL + "/statuses/friends_timeline.json", this.standardishParameters(), true);
    }

    public List<Status> getHomeTimeline() throws TwitterException {
        return this.getStatuses(this.TWITTER_URL + "/statuses/home_timeline.json", this.standardishParameters(), true);
    }

    private List<Message> getMessages(String url, Map<String, String> var) {
        if (this.maxResults < 1) {
            List<Message> msgs = Message.getMessages(this.http.getPage(url, var, true));
            msgs = this.dateFilter(msgs);
            return msgs;
        }
        this.pageNumber = 1;
        ArrayList<Message> msgs = new ArrayList<Message>();
        while (msgs.size() <= this.maxResults) {
            String p = this.http.getPage(url, var, true);
            List<Message> nextpage = Message.getMessages(p);
            nextpage = this.dateFilter(nextpage);
            msgs.addAll(nextpage);
            if (nextpage.size() < 20) break;
            Integer n = this.pageNumber;
            Integer n2 = this.pageNumber = Integer.valueOf(this.pageNumber + 1);
            var.put("page", Integer.toString(this.pageNumber));
        }
        return msgs;
    }

    public String getScreenName() {
        return this.name;
    }

    public List<Status> getPublicTimeline() throws TwitterException {
        return this.getStatuses(this.TWITTER_URL + "/statuses/public_timeline.json", this.standardishParameters(), false);
    }

    public int getRateLimitStatus() {
        String json = this.http.getPage(this.TWITTER_URL + "/account/rate_limit_status.json", null, this.http.canAuthenticate());
        try {
            JSONObject obj = new JSONObject(json);
            int hits = obj.getInt("remaining_hits");
            return hits;
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public List<Status> getReplies() throws TwitterException {
        return this.getStatuses(this.TWITTER_URL + "/statuses/replies.json", this.standardishParameters(), true);
    }

    public List<Status> getRetweetsOfMe() {
        throw new RuntimeException("TODO: Implement");
    }

    public List<Status> getRetweets(Status tweet) {
        String[] words = tweet.text.split("\\s");
        StringBuilder sq = new StringBuilder();
        sq.append("rt @" + tweet.getUser().getScreenName());
        for (String w : words) {
            sq.append(" ");
            sq.append(w);
        }
        return this.search(sq.toString());
    }

    public Status getStatus() throws TwitterException {
        Map<String, String> vars = Twitter.asMap("count", 1);
        String json = this.http.getPage(this.TWITTER_URL + "/statuses/user_timeline.json", vars, true);
        List<Status> statuses = Status.getStatuses(json);
        if (statuses.size() == 0) {
            return null;
        }
        return statuses.get(0);
    }

    public Status getStatus(long id) throws TwitterException {
        String json = this.http.getPage(this.TWITTER_URL + "/statuses/show/" + id + ".json", null, true);
        try {
            return new Status(new JSONObject(json), null);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public Status getStatus(String username) throws TwitterException {
        assert (username != null);
        Map<String, String> vars = Twitter.asMap("id", username, "count", 1);
        String json = this.http.getPage(this.TWITTER_URL + "/statuses/user_timeline.json", vars, false);
        List<Status> statuses = Status.getStatuses(json);
        if (statuses.size() == 0) {
            return null;
        }
        return statuses.get(0);
    }

    private List<Status> getStatuses(String url, Map<String, String> var, boolean authenticate) {
        if (this.maxResults < 1) {
            List<Status> msgs = Status.getStatuses(this.http.getPage(url, var, authenticate));
            msgs = this.dateFilter(msgs);
            return msgs;
        }
        this.pageNumber = 1;
        ArrayList<Status> msgs = new ArrayList<Status>();
        while (msgs.size() <= this.maxResults) {
            List<Status> nextpage = Status.getStatuses(this.http.getPage(url, var, authenticate));
            nextpage = this.dateFilter(nextpage);
            msgs.addAll(nextpage);
            if (nextpage.size() < 20) break;
            Integer n = this.pageNumber;
            Integer n2 = this.pageNumber = Integer.valueOf(this.pageNumber + 1);
            var.put("page", Integer.toString(this.pageNumber));
        }
        return msgs;
    }

    private List<Long> getUserIDs(String url, String screenName) {
        Long cursor = -1L;
        ArrayList<Long> ids = new ArrayList<Long>();
        while (cursor != 0L && !this.enoughResults(ids)) {
            Map<String, String> vars = this.newMap("screen_name", screenName);
            vars.put("cursor", (String)((Object)cursor));
            String json = this.http.getPage(url, vars, this.http.canAuthenticate());
            try {
                JSONObject jobj = new JSONObject(json);
                JSONArray jarr = (JSONArray)jobj.get("ids");
                for (int i = 0; i < jarr.length(); ++i) {
                    ids.add(jarr.getLong(i));
                }
                cursor = new Long(jobj.getString("next_cursor"));
            }
            catch (JSONException e) {
                throw new TwitterException("Could not parse id list" + e);
            }
        }
        return ids;
    }

    private <X> boolean enoughResults(List<X> list) {
        return this.maxResults != -1 && list.size() >= this.maxResults;
    }

    private Map<String, String> newMap(String ... keyValuePairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            map.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return map;
    }

    private List<User> getUsers(String url, String screenName) {
        Map<String, String> vars = this.newMap("screen_name", screenName);
        ArrayList<User> users = new ArrayList<User>();
        Long cursor = -1L;
        while (cursor != 0L && !this.enoughResults(users)) {
            vars.put("cursor", cursor.toString());
            try {
                JSONObject jobj = new JSONObject(this.http.getPage(url, vars, this.http.canAuthenticate()));
                users.addAll(User.getUsers(jobj.getString("users")));
                cursor = new Long(jobj.getString("next_cursor"));
            }
            catch (JSONException e) {
                throw new TwitterException("Could not parse user listing: " + e);
            }
        }
        return users;
    }

    public List<Status> getUserTimeline() throws TwitterException {
        return this.getStatuses(this.TWITTER_URL + "/statuses/user_timeline.json", this.standardishParameters(), true);
    }

    public List<Status> getUserTimeline(String screenName) throws TwitterException {
        Map<String, String> vars = Twitter.asMap("screen_name", screenName);
        this.addStandardishParameters(vars);
        boolean authenticate = this.http.canAuthenticate();
        String json = this.http.getPage(this.TWITTER_URL + "/statuses/user_timeline.json", vars, authenticate);
        return Status.getStatuses(json);
    }

    public boolean isFollower(String userB) {
        return this.isFollower(userB, this.name);
    }

    public boolean isFollower(String followerScreenName, String followedScreenName) {
        assert (followerScreenName != null && followedScreenName != null);
        String page = this.http.getPage(this.TWITTER_URL + "/friendships/exists.json", this.aMap("user_a", followerScreenName, "user_b", followedScreenName), true);
        return Boolean.valueOf(page);
    }

    public boolean isFollowing(String userB) {
        return this.isFollower(this.name, userB);
    }

    public boolean isFollowing(User user) {
        return this.isFollowing(user.screenName);
    }

    public boolean isValidLogin() {
        try {
            this.getDirectMessages();
            return true;
        }
        catch (TwitterException.E403 e) {
            return false;
        }
        catch (TwitterException.E401 e) {
            return false;
        }
        catch (TwitterException e) {
            throw e;
        }
    }

    public User leaveNotifications(String screenName) {
        Map<String, String> vars = this.newMap("screen_name", screenName);
        String page = this.http.getPage(this.TWITTER_URL + "/notifications/leave.json", vars, true);
        try {
            return new User(new JSONObject(page), null);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public User notify(String username) {
        Map<String, String> vars = this.newMap("screen_name", username);
        String page = this.http.getPage(this.TWITTER_URL + "/notifications/follow.json", vars, true);
        try {
            return new User(new JSONObject(page), null);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    private String post(String uri, Map<String, String> vars, boolean authenticate) throws TwitterException {
        String page = this.http.post(uri, vars, authenticate);
        return page;
    }

    public List<Status> search(String searchTerm, ICallback callback, int rpp) {
        Map<String, String> vars = this.maxResults < 100 && this.maxResults > 0 ? this.getSearchParams(searchTerm, this.maxResults) : this.getSearchParams(searchTerm, rpp);
        this.pageNumber = 1;
        ArrayList<Status> allResults = new ArrayList<Status>(Math.max(this.maxResults, rpp));
        String url = "http://search.twitter.com/search.json";
        this.pageNumber = 1;
        do {
            vars.put("page", Integer.toString(this.pageNumber));
            String json = this.http.getPage("http://search.twitter.com/search.json", vars, false);
            List<Status> stati = Status.getStatusesFromSearch(this, json);
            int numResults = stati.size();
            stati = this.dateFilter(stati);
            allResults.addAll(stati);
            if (callback != null && callback.process(stati) || numResults < rpp) break;
            Integer n = this.pageNumber;
            Integer n2 = this.pageNumber = Integer.valueOf(this.pageNumber + 1);
        } while (allResults.size() < this.maxResults);
        return allResults;
    }

    public Status retweet(Status tweet) {
        String result = this.post(this.TWITTER_URL + "/statuses/retweet/" + tweet.getId() + ".json", null, true);
        try {
            return new Status(new JSONObject(result), null);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public List<Status> search(String searchTerm) {
        return this.search(searchTerm, null, 100);
    }

    private Map<String, String> getSearchParams(String searchTerm, int rpp) {
        Map<String, String> vars = this.aMap("rpp", "" + rpp, "q", searchTerm);
        if (this.sinceId != null) {
            vars.put("since_id", this.sinceId.toString());
        }
        if (this.lang != null) {
            vars.put("lang", this.lang);
        }
        if (this.geocode != null) {
            vars.put("geocode", this.geocode);
        }
        this.addStandardishParameters(vars);
        return vars;
    }

    public void setSearchLocation(double latitude, double longitude, String radius) {
        assert (radius.endsWith("mi") || radius.endsWith("km")) : radius;
        this.geocode = latitude + "," + longitude + "," + radius;
    }

    public Message sendMessage(String recipient, String text) throws TwitterException {
        assert (recipient != null);
        assert (!text.startsWith("d " + recipient));
        if (text.length() > 140) {
            throw new IllegalArgumentException("Message is too long.");
        }
        Map<String, String> vars = Twitter.asMap("user", recipient, "text", text);
        String result = this.post(this.TWITTER_URL + "/direct_messages/new.json", vars, true);
        try {
            return new Message(new JSONObject(result));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setSinceDate(Date sinceDate) {
        this.sinceDate = sinceDate;
    }

    public void setUntilDate(Date untilDate) {
        this.untilDate = untilDate;
    }

    public Date getUntilDate() {
        return this.untilDate;
    }

    public void setSinceId(Long statusId) {
        this.sinceId = statusId;
    }

    public void setSource(String sourceApp) {
        this.sourceApp = sourceApp;
    }

    public Status setStatus(String statusText) throws TwitterException {
        return this.updateStatus(statusText);
    }

    public User show(String screenName) throws TwitterException {
        User user;
        Map<String, String> vars = this.newMap("screen_name", screenName);
        String json = this.http.getPage(this.TWITTER_URL + "/users/show.json", vars, this.http.canAuthenticate());
        try {
            user = new User(new JSONObject(json), null);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
        return user;
    }

    public User show(long userId) {
        User user;
        Map<String, String> vars = Twitter.asMap("user_id", "" + userId);
        String json = this.http.getPage(this.TWITTER_URL + "/users/show.json", vars, this.http.canAuthenticate());
        try {
            user = new User(new JSONObject(json), null);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
        return user;
    }

    public List<User> bulkShow(List<String> screenNames) {
        int batchSize = 20;
        ArrayList<User> users = new ArrayList<User>(screenNames.size());
        for (int i = 0; i < screenNames.size(); i += 20) {
            StringBuilder names = new StringBuilder();
            int n = Math.min(i + 20, screenNames.size());
            for (int si = i; si < n; ++si) {
                names.append(screenNames.get(si));
                names.append(",");
            }
            names.delete(names.length() - 1, names.length());
            Map<String, String> vars = Twitter.asMap("screen_name", names);
            try {
                String json = this.http.getPage(this.TWITTER_URL + "/users/lookup.json", vars, this.http.canAuthenticate());
                List<User> usersi = User.getUsers(json);
                users.addAll(usersi);
                continue;
            }
            catch (TwitterException e) {
                break;
            }
        }
        return users;
    }

    public User getUser(String screenName) {
        return this.show(screenName);
    }

    public User getUser(long userId) {
        return this.show(userId);
    }

    public List<String> splitMessage(String longStatus) {
        String[] words;
        if (longStatus.length() <= 140) {
            return Collections.singletonList(longStatus);
        }
        ArrayList<String> sections = new ArrayList<String>(4);
        StringBuilder tweet = new StringBuilder(140);
        for (String w : words = longStatus.split("\\s+")) {
            if (tweet.length() + w.length() + 1 > 140) {
                tweet.append("...");
                sections.add(tweet.toString());
                tweet = new StringBuilder(140);
                tweet.append(w);
                continue;
            }
            if (tweet.length() != 0) {
                tweet.append(" ");
            }
            tweet.append(w);
        }
        if (tweet.length() != 0) {
            sections.add(tweet.toString());
        }
        return sections;
    }

    private Map<String, String> standardishParameters() {
        return this.addStandardishParameters(new HashMap<String, String>());
    }

    public User stopFollowing(String username) {
        assert (this.getScreenName() != null);
        try {
            User user;
            Map<String, String> vars = this.newMap("screen_name", username);
            String page = this.post(this.TWITTER_URL + "/friendships/destroy.json", vars, true);
            try {
                user = new User(new JSONObject(page), null);
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
            return user;
        }
        catch (TwitterException e) {
            if (!this.isFollower(this.getScreenName(), username)) {
                return null;
            }
            throw e;
        }
    }

    public void stopFollowing(User user) {
        this.stopFollowing(user.screenName);
    }

    public Status updateStatus(String statusText) {
        return this.updateStatus(statusText, -1L);
    }

    public Status updateStatus(String statusText, long inReplyToStatusId) throws TwitterException {
        if (statusText.length() > 160) {
            throw new IllegalArgumentException("Status text must be 160 characters or less: " + statusText.length());
        }
        Map<String, String> vars = Twitter.asMap("status", statusText);
        if (this.sourceApp != null) {
            vars.put("source", this.sourceApp);
        }
        if (inReplyToStatusId > 0L) {
            vars.put("in_reply_to_status_id", inReplyToStatusId + "");
        }
        String result = this.post(this.TWITTER_URL + "/statuses/update.json", vars, true);
        try {
            Status s = new Status(new JSONObject(result), null);
            String targetText = statusText.trim();
            String returnedStatusText = s.text.trim();
            if (returnedStatusText.equals(targetText)) {
                return s;
            }
            String st = statusText.toLowerCase();
            if (st.startsWith("dm") || st.startsWith("d")) {
                return null;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Status s2 = this.getStatus();
            if (s2 != null && targetText.equals(s2.text)) {
                return s2;
            }
            throw new TwitterException.Unexplained("Unexplained failure for tweet: expected \"" + statusText + "\" but got " + s2);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public boolean userExists(String screenName) {
        try {
            this.show(screenName);
        }
        catch (TwitterException.E404 e) {
            return false;
        }
        return true;
    }

    public void setLanguage(String language) {
        this.lang = language;
    }

    public List<String> getTrends() {
        String jsonTrends = this.http.getPage("http://search.twitter.com/trends.json", null, false);
        try {
            JSONObject json1 = new JSONObject(jsonTrends);
            JSONArray json2 = json1.getJSONArray("trends");
            ArrayList<String> trends = new ArrayList<String>();
            for (int i = 0; i < json2.length(); ++i) {
                JSONObject ti = json2.getJSONObject(i);
                String t = ti.getString("name");
                trends.add(t);
            }
            return trends;
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public IHttpClient getHttpClient() {
        return this.http;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public static final class User {
        public final String description;
        public final long id;
        public final String location;
        public final String name;
        public URI profileImageUrl;
        public final boolean protectedUser;
        public final String screenName;
        public final Status status;
        public final URI website;
        public final int timezoneOffSet;
        public final String timezone;
        public int followersCount;
        public final String profileBackgroundColor;
        public final String profileLinkColor;
        public final String profileTextColor;
        public final String profileSidebarFillColor;
        public final String profileSidebarBorderColor;
        public final int friendsCount;
        public final Date createdAt;
        public final int favoritesCount;
        public final URI profileBackgroundImageUrl;
        public final boolean profileBackgroundTile;
        public final int statusesCount;
        public final boolean notifications;
        public final boolean verified;
        public final boolean following;

        static List<User> getUsers(String json) throws TwitterException {
            if (json.trim().equals("")) {
                return Collections.emptyList();
            }
            try {
                ArrayList<User> users = new ArrayList<User>();
                JSONArray arr = new JSONArray(json);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    User u = new User(obj, null);
                    users.add(u);
                }
                return users;
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
        }

        User(JSONObject obj, Status status) throws TwitterException {
            try {
                JSONObject s;
                this.id = obj.getLong("id");
                this.name = Twitter.unencode(Twitter.jsonGet("name", obj));
                this.screenName = Twitter.jsonGet("screen_name", obj).toLowerCase();
                this.location = Twitter.jsonGet("location", obj);
                this.description = Twitter.unencode(Twitter.jsonGet("description", obj));
                String img = Twitter.jsonGet("profile_image_url", obj);
                this.profileImageUrl = img == null ? null : Twitter.URI(img);
                String url = Twitter.jsonGet("url", obj);
                this.website = url == null ? null : Twitter.URI(url);
                this.protectedUser = obj.getBoolean("protected");
                this.followersCount = obj.getInt("followers_count");
                this.profileBackgroundColor = obj.getString("profile_background_color");
                this.profileLinkColor = obj.getString("profile_link_color");
                this.profileTextColor = obj.getString("profile_text_color");
                this.profileSidebarFillColor = obj.getString("profile_sidebar_fill_color");
                this.profileSidebarBorderColor = obj.getString("profile_sidebar_border_color");
                this.friendsCount = obj.getInt("friends_count");
                String c = Twitter.jsonGet("created_at", obj);
                this.createdAt = new Date(c);
                this.favoritesCount = obj.getInt("favourites_count");
                String utcOffSet = Twitter.jsonGet("utc_offset", obj);
                this.timezoneOffSet = utcOffSet == null ? 0 : Integer.parseInt(utcOffSet);
                this.timezone = Twitter.jsonGet("time_zone", obj);
                img = Twitter.jsonGet("profile_background_image_url", obj);
                this.profileBackgroundImageUrl = img == null ? null : Twitter.URI(img);
                this.profileBackgroundTile = obj.getBoolean("profile_background_tile");
                this.statusesCount = obj.getInt("statuses_count");
                this.notifications = obj.optBoolean("notifications");
                this.verified = obj.optBoolean("verified");
                this.following = obj.optBoolean("following");
                this.status = status == null ? ((s = obj.optJSONObject("status")) == null ? null : new Status(s, this)) : status;
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
        }

        public User(String screenName) {
            this.id = -1L;
            this.name = null;
            this.screenName = screenName.toLowerCase();
            this.status = null;
            this.location = null;
            this.description = null;
            this.profileImageUrl = null;
            this.website = null;
            this.protectedUser = false;
            this.followersCount = 0;
            this.profileBackgroundColor = null;
            this.profileLinkColor = null;
            this.profileTextColor = null;
            this.profileSidebarFillColor = null;
            this.profileSidebarBorderColor = null;
            this.friendsCount = 0;
            this.createdAt = null;
            this.favoritesCount = 0;
            this.timezoneOffSet = -1;
            this.timezone = null;
            this.profileBackgroundImageUrl = null;
            this.profileBackgroundTile = false;
            this.statusesCount = 0;
            this.notifications = false;
            this.verified = false;
            this.following = false;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof User)) {
                return false;
            }
            User ou = (User)other;
            return this.screenName.equals(ou.screenName);
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public String getDescription() {
            return this.description;
        }

        public int getFavoritesCount() {
            return this.favoritesCount;
        }

        public int getFollowersCount() {
            return this.followersCount;
        }

        public int getFriendsCount() {
            return this.friendsCount;
        }

        public long getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }

        public String getProfileBackgroundColor() {
            return this.profileBackgroundColor;
        }

        public URI getProfileBackgroundImageUrl() {
            return this.profileBackgroundImageUrl;
        }

        public URI getProfileImageUrl() {
            return this.profileImageUrl;
        }

        public String getProfileLinkColor() {
            return this.profileLinkColor;
        }

        public String getProfileSidebarBorderColor() {
            return this.profileSidebarBorderColor;
        }

        public String getProfileSidebarFillColor() {
            return this.profileSidebarFillColor;
        }

        public String getProfileTextColor() {
            return this.profileTextColor;
        }

        public boolean getProtectedUser() {
            return this.protectedUser;
        }

        public String getScreenName() {
            return this.screenName;
        }

        public Status getStatus() {
            return this.status;
        }

        public int getStatusesCount() {
            return this.statusesCount;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public int getTimezoneOffSet() {
            return this.timezoneOffSet;
        }

        public URI getWebsite() {
            return this.website;
        }

        public int hashCode() {
            return this.screenName.hashCode();
        }

        public boolean isDummyObject() {
            return this.name == null;
        }

        public boolean isFollowing() {
            return this.following;
        }

        public boolean isNotifications() {
            return this.notifications;
        }

        public boolean isProfileBackgroundTile() {
            return this.profileBackgroundTile;
        }

        public boolean isProtectedUser() {
            return this.protectedUser;
        }

        public boolean isVerified() {
            return this.verified;
        }

        public String toString() {
            return this.screenName;
        }
    }

    public static final class Status
    implements ITweet {
        public final Date createdAt;
        public final long id;
        public final String text;
        public final User user;
        public String geo;
        public final String source;
        public final Long inReplyToStatusId;
        private boolean favorited;
        static final Pattern AT_YOU_SIR = Pattern.compile("@(\\w+)");

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Status other = (Status)obj;
            return this.id == other.id;
        }

        static List<Status> getStatuses(String json) throws TwitterException {
            if (json.trim().equals("")) {
                return Collections.emptyList();
            }
            try {
                ArrayList<Status> tweets = new ArrayList<Status>();
                JSONArray arr = new JSONArray(json);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    Status tweet = new Status(obj, null);
                    tweets.add(tweet);
                }
                return tweets;
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
        }

        static List<Status> getStatusesFromSearch(Twitter tw, String json) {
            try {
                JSONObject searchResults = new JSONObject(json);
                ArrayList<Status> users = new ArrayList<Status>();
                JSONArray arr = searchResults.getJSONArray("results");
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    String userScreenName = obj.getString("from_user");
                    String profileImgUrl = obj.getString("profile_image_url");
                    User user = new User(userScreenName);
                    user.profileImageUrl = Twitter.URI(profileImgUrl);
                    Status s = new Status(obj, user);
                    users.add(s);
                }
                return users;
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
        }

        public boolean isFavorite() {
            return this.favorited;
        }

        Status(JSONObject object, User user) throws TwitterException {
            try {
                System.out.println(object.toString());
                this.id = object.getLong("id");
                String _text = Twitter.jsonGet("text", object);
                this.text = Twitter.unencode(_text);
                String c = Twitter.jsonGet("created_at", object);
                this.createdAt = new Date(c);
                this.source = Twitter.jsonGet("source", object);
                String irt = Twitter.jsonGet("in_reply_to_status_id", object);
                this.inReplyToStatusId = irt == null ? null : Long.valueOf(irt);
                this.favorited = object.has("favorited") && object.getBoolean("favorited");
                this.geo = Twitter.jsonGet("geo", object);
                if (user != null) {
                    this.user = user;
                } else {
                    JSONObject jsonUser = object.optJSONObject("user");
                    this.user = new User(jsonUser, this);
                }
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
        }

        @Override
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public long getId() {
            return this.id;
        }

        public List<String> getMentions() {
            Matcher m = AT_YOU_SIR.matcher(this.text);
            ArrayList<String> list = new ArrayList<String>(2);
            while (m.find()) {
                if (m.start() != 0 && this.text.charAt(m.start() - 1) != ' ') continue;
                String mention = m.group(1);
                list.add(mention.toLowerCase());
            }
            return list;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        public String toString() {
            return this.text;
        }

        public String getGeo() {
            return this.geo;
        }

        public void setGeo(String geo) {
            this.geo = geo;
        }
    }

    public static final class Message
    implements ITweet {
        public Long inReplyToMessageId;
        private final Date createdAt;
        private final long id;
        private final User recipient;
        private final User sender;
        private final String text;

        static List<Message> getMessages(String json) throws TwitterException {
            if (json.trim().equals("")) {
                return Collections.emptyList();
            }
            try {
                ArrayList<Message> msgs = new ArrayList<Message>();
                JSONArray arr = new JSONArray(json);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    Message u = new Message(obj);
                    msgs.add(u);
                }
                return msgs;
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
        }

        Message(JSONObject obj) throws JSONException, TwitterException {
            this.id = obj.getLong("id");
            String _text = obj.getString("text");
            this.text = Twitter.unencode(_text);
            String c = Twitter.jsonGet("created_at", obj);
            this.createdAt = new Date(c);
            this.sender = new User(obj.getJSONObject("sender"), null);
            this.recipient = obj.has("recipient") ? new User(obj.getJSONObject("recipient"), null) : null;
        }

        @Override
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public long getId() {
            return this.id;
        }

        public User getRecipient() {
            return this.recipient;
        }

        public User getSender() {
            return this.sender;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public User getUser() {
            return this.getSender();
        }

        public String toString() {
            return this.text;
        }
    }

    public static interface ITweet {
        public Date getCreatedAt();

        public long getId();

        public String getText();

        public User getUser();
    }

    public static interface IHttpClient {
        public boolean canAuthenticate();

        public String getPage(String var1, Map<String, String> var2, boolean var3) throws TwitterException;

        public String post(String var1, Map<String, String> var2, boolean var3) throws TwitterException;
    }

    public static interface ICallback {
        public boolean process(List<Status> var1);
    }
}

