/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn;

import java.io.File;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.dgn.DGNOpenStoreParameters;

public class DGNFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    public String getDataStoreProviderName() {
        return "DGN";
    }

    public int getMode() {
        return 3;
    }

    public boolean accept(File pathname) {
        return pathname.getName().toLowerCase().endsWith(".dgn");
    }

    public String getDescription() {
        return "DGN file";
    }

    public boolean canCreate() {
        return false;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        return false;
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        return null;
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        File file = new File(((DGNOpenStoreParameters)parameters).getFileName());
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(file));
        }
        if (!file.delete()) {
            // empty if block
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void resourceChanged(ResourceProvider resource) {
    }
}

