/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.DatasetBand;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.RemoteRasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.impl.store.properties.RemoteDataStoreStatistics;
import org.gvsig.raster.impl.store.properties.RemoteStoreHistogram;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.raster.wcs.io.WCSConnector;
import org.gvsig.raster.wcs.io.WCSDataParameters;
import org.gvsig.raster.wcs.io.WCSDataParametersImpl;
import org.gvsig.raster.wcs.io.WCSServerExplorer;
import org.gvsig.raster.wcs.io.WCSServerExplorerParameters;
import org.gvsig.raster.wcs.io.downloader.WCSTileServer;
import org.gvsig.remoteclient.wcs.WCSStatus;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCSProvider
extends AbstractRasterProvider
implements RemoteRasterProvider {
    public static String NAME = "Wcs Store";
    public static String DESCRIPTION = "Wcs Raster file";
    public static final String METADATA_DEFINITION_NAME = "WcsStore";
    private Extent viewRequest = null;
    private static Hashtable<URL, WCSConnector> drivers = new Hashtable();
    private boolean open = false;
    private DataStoreTransparency fileTransparency = null;
    private File lastRequest = null;
    private AbstractRasterProvider lastRequestProvider = null;
    private static final Logger logger = LoggerFactory.getLogger(WCSProvider.class);

    public static void register() {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, WCSProvider.class, WCSDataParametersImpl.class);
        }
        if (!dataman.getExplorerProviders().contains(NAME)) {
            dataman.registerExplorerProvider(NAME, WCSServerExplorer.class, WCSServerExplorerParameters.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    public WCSProvider() throws NotSupportedExtensionException {
    }

    public WCSProvider(String params) throws InitializeException, OpenException {
        super(params);
        logger.info("Deprecated use of WCSProvider constructor");
        if (params instanceof String) {
            WCSDataParametersImpl p = new WCSDataParametersImpl();
            try {
                p.setURI(new URI(params));
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create URI from" + params, (Throwable)e);
            }
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init((DataStoreParameters)p, null);
        }
    }

    public WCSProvider(URI uri) throws InitializeException, OpenException {
        super(uri);
        WCSDataParametersImpl p = new WCSDataParametersImpl();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((DataStoreParameters)p, null);
    }

    public WCSProvider(WCSDataParametersImpl params, DataStoreProviderServices storeServices) throws InitializeException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((DataStoreParameters)params, storeServices);
    }

    public WCSConnector getConnector() throws RemoteServiceException {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        URL url = null;
        try {
            url = p.getURI().toURL();
        }
        catch (Exception e) {
            throw new RemoteServiceException("Malformed URL", (Throwable)e);
        }
        try {
            return WCSProvider.getConnectorFromURL(url);
        }
        catch (IOException e) {
            throw new RemoteServiceException("Error getting the connector", (Throwable)e);
        }
    }

    public void init(DataStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this.setParam(storeServices, params);
        this.open = true;
        try {
            this.loadInitialInfo();
        }
        catch (RasterDriverException e) {
            throw new InitializeException(e.getMessage(), (Throwable)e);
        }
        this.stats = new RemoteDataStoreStatistics((RasterProvider)this);
    }

    public static final WCSConnector getConnectorFromURL(URL url) throws IOException {
        WCSConnector drv = drivers.get(url);
        if (drv == null) {
            drv = new WCSConnector(url);
            drivers.put(url, drv);
        }
        return drv;
    }

    public ColorInterpretation getColorInterpretation() {
        if (super.getColorInterpretation() == null) {
            DataStoreColorInterpretation colorInterpretation = new DataStoreColorInterpretation();
            colorInterpretation.initColorInterpretation(this.getBandCount());
            if (this.getBandCount() == 3) {
                colorInterpretation = DataStoreColorInterpretation.createRGBInterpretation();
            } else {
                for (int i = 0; i < this.getBandCount(); ++i) {
                    colorInterpretation.setColorInterpValue(i, "Gray");
                }
            }
            this.setColorInterpretation((ColorInterpretation)colorInterpretation);
        }
        return super.getColorInterpretation();
    }

    public WCSDataParameters getParameters() {
        return (WCSDataParameters)this.parameters;
    }

    public AffineTransform getAffineTransform() {
        Extent e = this.getExtent();
        double resolutionX = e.width() / this.getWidth();
        double resolutionY = e.height() / this.getHeight();
        this.ownTransformation = new AffineTransform(resolutionX, 0.0, 0.0, -resolutionY, e.getULX() - resolutionX / 2.0, e.getULY() - resolutionY / 2.0);
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        return this.ownTransformation;
    }

    public Extent getExtent() {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        try {
            Rectangle2D r;
            p.setFormat("image/tiff");
            if (p.getSRSCode() == null) {
                WCSConnector connector = WCSProvider.getConnectorFromURL(p.getURI().toURL());
                ArrayList srs = connector.getSRSs(p.getCoverageName());
                if (!srs.isEmpty() && !StringUtils.isBlank((CharSequence)((String)srs.get(0)))) {
                    p.setSRSID((String)srs.get(0));
                } else {
                    return null;
                }
            }
            if ((r = this.getConnector().getFullExtent(p.getCoverageName(), p.getSRSCode())) == null) {
                return null;
            }
            return new ExtentImpl(r.getX(), r.getY() + r.getHeight(), r.getX() + r.getWidth(), r.getY());
        }
        catch (RemoteServiceException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Rectangle2D getLayerExtent(String layerName, String srs) throws RemoteServiceException {
        return null;
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
    }

    public Transparency getTransparency() {
        if (this.fileTransparency == null) {
            this.fileTransparency = new DataStoreTransparency(this.getColorInterpretation());
        }
        return this.fileTransparency;
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public void setView(Extent e) {
        this.viewRequest = e;
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        try {
            return this.getConnector().getWidth(p.getCoverageName());
        }
        catch (RemoteServiceException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double getHeight() {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        try {
            return this.getConnector().getHeight(p.getCoverageName());
        }
        catch (RemoteServiceException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    public File getFileLayer() throws RasterDriverException {
        Extent e = this.getExtent();
        Rectangle2D.Double bBox = new Rectangle2D.Double(e.getULX(), e.getLRY(), e.width(), e.height());
        WCSStatus wcsStatus = this.loadWCSStatus(bBox);
        return this.downloadFile(wcsStatus, e, (int)this.getWidth(), (int)this.getHeight());
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        File lastFile = this.getFileLayer();
        BandListImpl bandList = new BandListImpl();
        for (int i = 0; i < 3; ++i) {
            try {
                bandList.addBand((DatasetBand)new DatasetBandImpl(lastFile.getPath(), pos, 0, 3));
                continue;
            }
            catch (BandNotFoundInListException bandNotFoundInListException) {
                // empty catch block
            }
        }
        bandList.setDrawableBands(new int[]{0, 1, 2});
        try {
            this.lastRequestProvider = this.openLastRequest();
            return this.lastRequestProvider.readBlock(pos, blockHeight, scale);
        }
        catch (ProviderNotRegisteredException exc) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)exc));
        }
        catch (InitializeException exc) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)exc));
        }
    }

    public double getLastRequestHeight() throws RasterDriverException {
        if (this.lastRequestProvider == null) {
            try {
                this.lastRequestProvider = this.openLastRequest();
            }
            catch (ProviderNotRegisteredException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
            catch (InitializeException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
        }
        return this.lastRequestProvider.getHeight();
    }

    public double getLastRequestWidth() throws RasterDriverException {
        if (this.lastRequestProvider == null) {
            try {
                this.lastRequestProvider = this.openLastRequest();
            }
            catch (ProviderNotRegisteredException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
            catch (InitializeException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
        }
        return this.lastRequestProvider.getWidth();
    }

    public File getLastRequest() {
        return this.lastRequest;
    }

    public Buffer getBufferLastRequest() throws ProcessInterruptedException, RasterDriverException {
        try {
            this.lastRequestProvider = this.openLastRequest();
            RasterQuery q = RasterLocator.getManager().createQuery();
            q.setAreaOfInterest(this.lastRequestProvider.getExtent(), (int)this.lastRequestProvider.getWidth(), (int)this.lastRequestProvider.getHeight());
            q.setAllDrawableBands();
            q.setAdjustToExtent(true);
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this.lastRequestProvider);
            return store.query(q);
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (QueryException e) {
            throw new RasterDriverException("Error reading data", (Exception)((Object)e));
        }
    }

    private AbstractRasterProvider openLastRequest() throws ProviderNotRegisteredException, InitializeException, RasterDriverException {
        if (this.lastRequestProvider != null) {
            this.lastRequestProvider.close();
        }
        File lastFile = this.getFileLayer();
        this.lastRequestProvider = DefaultProviderServices.loadProvider((File)new File(lastFile.getPath()));
        return this.lastRequestProvider;
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        int w = 25;
        int h = 25;
        Point2D p1 = this.rasterToWorld(new Point2D.Double(x, y));
        Point2D p2 = this.rasterToWorld(new Point2D.Double(x + w, y + h));
        Rectangle2D.Double bBox = new Rectangle2D.Double(p1.getX(), p1.getY(), Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY()));
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        WCSStatus wcsStatus = new WCSStatus();
        wcsStatus.setCoveraName(p.getCoverageName());
        wcsStatus.setSrs(p.getSRSCode());
        wcsStatus.setFormat(p.getFormat());
        wcsStatus.setOnlineResource(p.getOnlineResource() != null ? p.getOnlineResource().get("GetCoverage") : null);
        wcsStatus.setExtent((Rectangle2D)bBox);
        wcsStatus.setHeight(h);
        wcsStatus.setWidth(w);
        wcsStatus.setDepth(p.getDepth());
        wcsStatus.setParameters(p.getParameter());
        wcsStatus.setTime(p.getTime());
        this.lastRequest = this.downloadFile(wcsStatus, p1.getX(), p1.getY(), p2.getX(), p2.getY(), w, h);
        AbstractRasterProvider driver = null;
        try {
            driver = DefaultProviderServices.loadProvider((File)new File(this.lastRequest.getPath()));
            RasterQuery q = RasterLocator.getManager().createQuery();
            Rectangle r = new Rectangle(0, 0, 25, 25);
            q.setAreaOfInterest(r);
            q.setAllDrawableBands();
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)driver);
            Buffer buf = store.query(q);
            driver.close();
            if (buf.getDataType() == 0) {
                return new Integer(buf.getElemByte(0, 0, band));
            }
            if (buf.getDataType() == 2) {
                return new Integer(buf.getElemShort(0, 0, band));
            }
            if (buf.getDataType() == 3) {
                return new Integer(buf.getElemInt(0, 0, band));
            }
            if (buf.getDataType() == 4) {
                return new Float(buf.getElemFloat(0, 0, band));
            }
            if (buf.getDataType() == 5) {
                return new Double(buf.getElemDouble(0, 0, band));
            }
        }
        catch (InitializeException e) {
            throw new RasterDriverException("", (Exception)((Object)e));
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("", (Exception)((Object)e));
        }
        catch (ProcessInterruptedException e) {
        }
        catch (QueryException e) {
            throw new RasterDriverException("", (Exception)((Object)e));
        }
        return null;
    }

    private String getWorldFile(String file) {
        String worldFile = file;
        int index = file.lastIndexOf(".");
        worldFile = index > 0 ? file.substring(0, index) + this.getExtensionWorldFile() : file + this.getExtensionWorldFile();
        return worldFile;
    }

    private String getExtensionWorldFile() {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        String extWorldFile = ".wld";
        if (p.getFormat().equals("image/tif") || p.getFormat().equals("image/tiff")) {
            extWorldFile = ".tfw";
        }
        return extWorldFile;
    }

    private WCSStatus loadWCSStatus(Rectangle2D bBox) {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        WCSStatus wcsStatus = new WCSStatus();
        wcsStatus.setCoveraName(p.getCoverageName());
        wcsStatus.setSrs(p.getSRSCode());
        wcsStatus.setFormat(p.getFormat());
        wcsStatus.setOnlineResource(p.getOnlineResource() != null ? p.getOnlineResource().get("GetCoverage") : null);
        wcsStatus.setExtent(bBox);
        wcsStatus.setHeight(p.getHeight());
        wcsStatus.setWidth(p.getWidth());
        wcsStatus.setDepth(p.getDepth());
        wcsStatus.setParameters(p.getParameter());
        wcsStatus.setTime(p.getTime());
        return wcsStatus;
    }

    public boolean needEnhanced() {
        return this.getDataType()[0] != 0 || this.getBandCount() == 1 && this.getDataType()[0] == 0;
    }

    private File downloadFile(WCSStatus wcsStatus, double ulx, double uly, double lrx, double lry, int w, int h) throws RasterDriverException {
        ExtentImpl extent = new ExtentImpl(ulx, uly, lrx, lry);
        return this.downloadFile(wcsStatus, (Extent)extent, w, h);
    }

    private File downloadFile(WCSStatus wcsStatus, Extent extent, int w, int h) throws RasterDriverException {
        try {
            this.lastRequest = this.getConnector().getCoverage(wcsStatus, ((WCSDataParametersImpl)this.parameters).getCancellable());
        }
        catch (RemoteServiceException e) {
            throw new RasterDriverException(e.getMessage(), (Exception)((Object)e));
        }
        String nameWorldFile = this.getWorldFile(this.lastRequest.getPath());
        try {
            this.fileUtil.createWorldFile(nameWorldFile, extent, w, h);
        }
        catch (IOException e) {
            throw new RasterDriverException("Error downloading file", (Exception)e);
        }
        return this.lastRequest;
    }

    public Buffer getBuffer(BandList bandList, File lastFile, double ulx, double uly, double lrx, double lry) throws RasterDriverException, ProcessInterruptedException {
        try {
            AbstractRasterProvider driver = DefaultProviderServices.loadProvider((File)lastFile);
            RasterQuery q = RasterLocator.getManager().createQuery();
            q.setAreaOfInterest((Extent)new ExtentImpl(ulx, uly, lrx, lry));
            q.setDrawableBands(bandList.getDrawableBands());
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)driver);
            Buffer buf = store.query(q);
            return buf;
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (QueryException e) {
            throw new RasterDriverException("Error reading data", (Exception)((Object)e));
        }
    }

    public void loadBuffer(SpiRasterQuery query) throws ProcessInterruptedException, RasterDriverException {
        Extent ex = query.getAdjustedRequestBoundingBox();
        WCSStatus wcsStatus = this.loadWCSStatus(ex.toRectangle2D());
        this.lastRequest = this.downloadFile(wcsStatus, ex, query.getAdjustedBufWidth(), query.getAdjustedBufHeight());
        if (this.lastRequest == null) {
            return;
        }
        try {
            AbstractRasterProvider driver = DefaultProviderServices.loadProvider((File)this.lastRequest);
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)driver);
            query.createBuffer((RasterDataStore)store);
            store.query((RasterQuery)query);
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (QueryException e) {
            throw new RasterDriverException("Error reading data", (Exception)((Object)e));
        }
    }

    private void loadInitialInfo() throws RasterDriverException {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        Extent ext = this.getExtent();
        if (ext != null) {
            Rectangle2D bBox = ext.toRectangle2D();
            int w = 0;
            int h = 0;
            if (ext.width() > ext.height()) {
                w = 200;
                h = (int)(ext.height() * (double)w / ext.width());
            } else {
                h = 200;
                w = (int)(ext.width() * (double)h / ext.height());
            }
            p.setWidth(w);
            p.setHeight(h);
            p.setExtent(bBox);
            WCSStatus wcsStatus = this.loadWCSStatus(bBox);
            this.lastRequest = this.downloadFile(wcsStatus, ext.getULX(), ext.getULY(), ext.getLRX(), ext.getLRY(), w, h);
            try {
                AbstractRasterProvider driver = DefaultProviderServices.loadProvider((File)this.lastRequest);
                this.setDataType(driver.getDataType());
                this.bandCount = driver.getBandCount();
                driver.close();
            }
            catch (ProviderNotRegisteredException e) {
                throw new RasterDriverException("", (Exception)((Object)e));
            }
            catch (InitializeException e) {
                throw new RasterDriverException("", (Exception)((Object)e));
            }
        }
    }

    public int getBlockSize() {
        return 0;
    }

    public void setAffineTransform(AffineTransform t) {
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public boolean isReproyectable() {
        return false;
    }

    public String getProviderName() {
        return NAME;
    }

    public String getName() {
        return this.getParameters().getCoverageName();
    }

    public Point2D rasterToWorld(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        this.getAffineTransform().transform(pt, p);
        return p;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        try {
            this.getAffineTransform().inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof WCSProvider) {
            // empty if block
        }
    }

    public void setParam(DataStoreProviderServices storeServices, DataStoreParameters param) {
        if (param instanceof WCSDataParametersImpl) {
            this.uri = ((WCSDataParametersImpl)param).getURI();
        }
        this.param = param;
    }

    public String getFileSuffix() {
        WCSDataParametersImpl p = (WCSDataParametersImpl)this.parameters;
        String format = p.getFormat().toLowerCase();
        if (format == null) {
            return "xml";
        }
        if (format.indexOf("png") >= 0) {
            return "png";
        }
        if (format.indexOf("xml") >= 0) {
            return "xml";
        }
        if (format.indexOf("gif") >= 0) {
            return "gif";
        }
        if (format.indexOf("tif") >= 0) {
            return "tif";
        }
        if (format.indexOf("bmp") >= 0) {
            return "bmp";
        }
        if (format.indexOf("jpg") >= 0 || format.indexOf("jpeg") >= 0) {
            return "jpg";
        }
        return "xml";
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new WCSTileServer((RasterDataStore)store);
        }
        return this.tileServer;
    }

    public boolean isRasterEnclosed() {
        return true;
    }

    public File getRMFFile() {
        if (this.lastRequest != null) {
            return new File(FilenameUtils.removeExtension((String)this.lastRequest.getAbsolutePath()) + ".rmf");
        }
        return null;
    }

    public HistogramComputer getHistogramComputer() {
        if (this.histogram == null) {
            this.histogram = new RemoteStoreHistogram((RemoteRasterProvider)this);
        }
        return this.histogram;
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }
}

