/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.csv.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.csv.service.ExportCSVParameters;
import org.gvsig.export.spi.AbstractExportService;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.tools.util.HasAFile;

public class ExportCSVService
extends AbstractExportService
implements ExportService {
    protected ExportCSVService(ExportServiceFactory factory, ExportCSVParameters parameters) {
        super(factory, (ExportParameters)parameters);
    }

    public ExportCSVParameters getParameters() {
        return (ExportCSVParameters)super.getParameters();
    }

    protected FilesystemServerExplorer createServerExplorer() throws ExportException {
        FilesystemServerExplorerParameters explorerParams;
        DataManager dataManager = DALLocator.getDataManager();
        try {
            explorerParams = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
        explorerParams.setRoot(this.getParameters().getEvaluatedFile().getParent());
        try {
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)explorerParams);
            return explorer;
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
    }

    protected NewDataStoreParameters createTargetNewStoreParameters() throws ExportException {
        try {
            EditableFeatureType eft;
            FilesystemServerExplorer explorer = this.createServerExplorer();
            NewFeatureStoreParameters newStoreParameters = (NewFeatureStoreParameters)explorer.getAddParameters("CSV");
            ((HasAFile)newStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            newStoreParameters.setDynValue("profile", (Object)this.getParameters().getProfile());
            newStoreParameters.setDynValue("quotePolicy", (Object)this.getParameters().getQuotePolicy());
            newStoreParameters.setDynValue("locale", (Object)this.getParameters().getLocale());
            newStoreParameters.setDynValue("recordSeparator", (Object)this.getParameters().getRecordSeparator());
            newStoreParameters.setDynValue("delimiter", (Object)this.getParameters().getDelimiter());
            newStoreParameters.setDynValue("quoteCharacter", (Object)this.getParameters().getQuoteCharacter());
            newStoreParameters.setDynValue("commentStartMarker", (Object)this.getParameters().getCommentStartMarker());
            newStoreParameters.setDynValue("escapeCharacter", (Object)this.getParameters().getEscapeCharacter());
            newStoreParameters.setDynValue("charset", (Object)this.getParameters().getCharset());
            newStoreParameters.setDynValue("includeMetadataInHeader", (Object)this.getParameters().getIncludeMetadataInHeader());
            newStoreParameters.setDynValue("GeometryFormat", (Object)this.getParameters().getGeometryFormat());
            FeatureType ft = this.getParameters().getExportAttributes().getTargetFeatureType();
            if (ft == null) {
                ft = this.getParameters().getSourceFeatureType();
            }
            if (!(eft = ft.getEditable()).hasPrimaryKey()) {
                eft.setHasOID(true);
            }
            newStoreParameters.setDefaultFeatureType((FeatureType)eft);
            return newStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    private String checkEmptyStringParam(String param) {
        if (StringUtils.isEmpty((CharSequence)param)) {
            return null;
        }
        return param;
    }

    public OpenDataStoreParameters createTargetOpenStoreParameters() throws ExportException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            OpenFeatureStoreParameters openStoreParameters = (OpenFeatureStoreParameters)dataManager.createStoreParameters("CSV");
            ((HasAFile)openStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            openStoreParameters.setDynValue("profile", (Object)this.getParameters().getProfile());
            openStoreParameters.setDynValue("quotePolicy", (Object)this.getParameters().getQuotePolicy());
            openStoreParameters.setDynValue("locale", (Object)this.getParameters().getLocale());
            openStoreParameters.setDynValue("recordSeparator", (Object)this.checkEmptyStringParam(this.getParameters().getRecordSeparator()));
            openStoreParameters.setDynValue("delimiter", (Object)this.checkEmptyStringParam(this.getParameters().getDelimiter()));
            openStoreParameters.setDynValue("quoteCharacter", (Object)this.checkEmptyStringParam(this.getParameters().getQuoteCharacter()));
            openStoreParameters.setDynValue("commentStartMarker", (Object)this.checkEmptyStringParam(this.getParameters().getCommentStartMarker()));
            openStoreParameters.setDynValue("escapeCharacter", (Object)this.checkEmptyStringParam(this.getParameters().getEscapeCharacter()));
            openStoreParameters.setDynValue("firstLineHeader", (Object)true);
            openStoreParameters.setDynValue("charset", (Object)this.checkEmptyStringParam(this.getParameters().getCharset()));
            openStoreParameters.setDynValue("includeMetadataInHeader", (Object)this.getParameters().getIncludeMetadataInHeader());
            openStoreParameters.setDynValue("GeometryFormat", (Object)this.getParameters().getGeometryFormat());
            return openStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    public List<OpenDataStoreParameters> getTargetOpenStoreParameters() throws ExportException {
        ArrayList<OpenDataStoreParameters> r = new ArrayList<OpenDataStoreParameters>();
        r.add(this.createTargetOpenStoreParameters());
        return r;
    }
}

