/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.BufferOverflowException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.math.BigDecimalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldFormatter.class);
    public static final int TIME_SIZE = 6;
    public static final int TIMESTAMP_SIZE = 14;
    public static final int DATE_SIZE = 8;
    public static final int BOOLEAN_SIZE = 1;
    private static final SimpleDateFormat YYYYMMDD_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat HHMMSS_DATE_FORMAT = new SimpleDateFormat("HHmmss");
    private static final SimpleDateFormat YYYYMMDDHHMMSS_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final FieldPosition FIELDPOSITION = new FieldPosition(0);
    private static final int MAXCHARS = 255;
    private StringBuffer buffer;
    private NumberFormat numberFormatter;
    private FilteredLogger logger;
    private String name;
    private long rowIndex;

    public FieldFormatter() {
        this.name = "UNKNOWN";
        this.rowIndex = -1L;
    }

    public FieldFormatter(String name, long rowIndex) {
        this.name = name;
        this.rowIndex = rowIndex;
    }

    private StringBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(255);
        }
        return this.buffer;
    }

    private NumberFormat getNumberFormatter() {
        if (this.numberFormatter == null) {
            this.numberFormatter = NumberFormat.getNumberInstance(Locale.US);
            this.numberFormatter.setGroupingUsed(false);
        }
        return this.numberFormatter;
    }

    private FilteredLogger getLogger() {
        if (this.logger == null) {
            this.logger = new FilteredLogger(LOGGER, "DBFFiledFormatter", -1);
            this.logger.setInterval(2000L);
        }
        return this.logger;
    }

    public String format(String s, int size) {
        if (s.length() > size) {
            return s.substring(0, size);
        }
        return s;
    }

    public String format(boolean b) {
        return b ? "T" : "F";
    }

    public String formatDate(java.util.Date date) {
        if (date == null) {
            return "        ";
        }
        StringBuffer buf = this.getBuffer();
        buf.setLength(0);
        YYYYMMDD_DATE_FORMAT.format(date, buf, FIELDPOSITION);
        return buf.toString();
    }

    public String formatTime(java.util.Date date) {
        if (date == null) {
            return "      ";
        }
        StringBuffer buf = this.getBuffer();
        buf.setLength(0);
        HHMMSS_DATE_FORMAT.format(date, buf, FIELDPOSITION);
        return buf.toString();
    }

    public String formatTimestamp(java.util.Date date) {
        if (date == null) {
            return "              ";
        }
        StringBuffer buf = this.getBuffer();
        buf.setLength(0);
        YYYYMMDDHHMMSS_DATE_FORMAT.format(date, buf, FIELDPOSITION);
        return buf.toString();
    }

    public String formatTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return "              ";
        }
        StringBuffer buf = this.getBuffer();
        buf.setLength(0);
        YYYYMMDDHHMMSS_DATE_FORMAT.format((java.util.Date)timestamp, buf, FIELDPOSITION);
        return buf.toString();
    }

    public String format(byte n) {
        StringBuffer buf = this.getBuffer();
        NumberFormat nf = this.getNumberFormatter();
        buf.setLength(0);
        nf.setMaximumFractionDigits(0);
        nf.setMinimumFractionDigits(0);
        nf.format(n, buf, FIELDPOSITION);
        String s = buf.toString();
        if (s.length() > 2) {
            this.getLogger().warn("Can't format value '" + n + "' as Byte in field '" + this.name + "' row " + this.rowIndex + ".");
            throw new BufferOverflowException();
        }
        return s;
    }

    public String format(int n, int size) {
        StringBuffer buf = this.getBuffer();
        NumberFormat nf = this.getNumberFormatter();
        buf.setLength(0);
        nf.setMaximumFractionDigits(0);
        nf.setMinimumFractionDigits(0);
        nf.format(n, buf, FIELDPOSITION);
        String s = buf.toString();
        if (s.length() > size) {
            this.getLogger().warn("Can't format value '" + n + "' as Byte in field '" + this.name + "' row " + this.rowIndex + ".");
            throw new BufferOverflowException();
        }
        return s;
    }

    public String format(long n, int size) {
        StringBuffer buf = this.getBuffer();
        NumberFormat nf = this.getNumberFormatter();
        buf.setLength(0);
        nf.setMaximumFractionDigits(0);
        nf.setMinimumFractionDigits(0);
        nf.format(n, buf, FIELDPOSITION);
        String s = buf.toString();
        if (s.length() > size) {
            this.getLogger().warn("Can't format value '" + n + "' as long in field '" + this.name + "' row " + this.rowIndex + ".");
            throw new BufferOverflowException();
        }
        return s;
    }

    public String format(BigDecimal n, int size) {
        if (!BigDecimalUtils.canFitToSize((BigDecimal)n, (int)size)) {
            this.getLogger().warn("Can't format value '" + n + "' as BigDecimal in field '" + this.name + "' row " + this.rowIndex + ".");
            throw new BufferOverflowException();
        }
        String s = BigDecimalUtils.toString((BigDecimal)n, (int)size);
        return s;
    }

    public String format(double n, int size, int scale) {
        String s = String.format(Locale.ENGLISH, "%f", n);
        if (s.length() > size) {
            int index = s.indexOf(46);
            if (index < 0 || index >= size) {
                this.getLogger().warn("Can't format value '" + n + "' as double in field '" + this.name + "' row " + this.rowIndex + ".");
                throw new BufferOverflowException();
            }
            s = index == size - 1 ? s.substring(0, size - 1) : s.substring(0, size);
        }
        return s;
    }

    public String format(float n, int size, int scale) {
        String s = String.format(Locale.ENGLISH, "%f", Float.valueOf(n));
        if (s.length() > size) {
            int index = s.indexOf(46);
            if (index < 0 || index >= size) {
                this.getLogger().warn("Can't format value '" + n + "' as float in field '" + this.name + "' row " + this.rowIndex + ".");
                throw new BufferOverflowException();
            }
            s = index == size - 1 ? s.substring(0, size - 1) : s.substring(0, size);
        }
        return s;
    }

    public String parseString(String value, String defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public BigDecimal parseDecimal(String value, MathContext context, int scale, BigDecimal defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            BigDecimal x = BigDecimalUtils.parseDecimalEnsurePrecisionRoundScale((String)value, (int)context.getPrecision(), (int)scale, (BigDecimal)defaultValue);
            return x;
        }
        catch (Exception ex) {
            if (!StringUtils.containsOnly((CharSequence)value, (String)"*")) {
                this.getLogger().warn("Can't parse value '" + value + "' as BigDecimal in field '" + this.name + "' row " + this.rowIndex + ".", (Throwable)ex);
            }
            return defaultValue;
        }
    }

    public Double parseDouble(String value, Double defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            Double x = Double.parseDouble(value);
            return x;
        }
        catch (Exception ex) {
            this.getLogger().warn("Can't parse value '" + value + "' as double in field '" + this.name + "' row " + this.rowIndex + ".", (Throwable)ex);
            return defaultValue;
        }
    }

    public Float parseFloat(String value, Float defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            Float x = Float.valueOf(Float.parseFloat(value));
            return x;
        }
        catch (Exception ex) {
            this.getLogger().warn("Can't parse value '" + value + "' as float in field '" + this.name + "' row " + this.rowIndex + ".", (Throwable)ex);
            return defaultValue;
        }
    }

    public Integer parseInt(String value, Integer defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            int x = Integer.parseInt(value);
            return x;
        }
        catch (Exception ex) {
            this.getLogger().warn("Can't parse value '" + value + "' as int in field '" + this.name + "' row " + this.rowIndex + ".", (Throwable)ex);
            return defaultValue;
        }
    }

    public Long parseLong(String value, Long defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            Long x = Long.valueOf(value);
            return x;
        }
        catch (Exception ex) {
            this.getLogger().warn("Can't parse value '" + value + "' as long in field '" + this.name + "' row " + this.rowIndex + ".", (Throwable)ex);
            return defaultValue;
        }
    }

    public Byte parseByte(String value, Byte defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            byte x = Byte.parseByte(value);
            return x;
        }
        catch (Exception ex) {
            this.getLogger().warn("Can't parse value '" + value + "' as byte in field '" + this.name + "' row " + this.rowIndex + ".", (Throwable)ex);
            return defaultValue;
        }
    }

    public Boolean parseBoolean(String value, Boolean defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        switch (value.trim().charAt(0)) {
            case 'T': 
            case 't': {
                return true;
            }
            case 'F': 
            case 'f': {
                return false;
            }
            case ' ': {
                return null;
            }
        }
        return defaultValue;
    }

    public java.util.Date parseTimestamp(String value, java.util.Date defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            java.util.Date x = YYYYMMDDHHMMSS_DATE_FORMAT.parse(value);
            return new Timestamp(x.getTime());
        }
        catch (Throwable t) {
            this.getLogger().warn("Can't parse value '" + value + "' as timestamp in field '" + this.name + "' row " + this.rowIndex + ".", t);
            return defaultValue;
        }
    }

    public java.util.Date parseTime(String value, java.util.Date defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            java.util.Date x = HHMMSS_DATE_FORMAT.parse(value);
            return new Time(x.getTime());
        }
        catch (Throwable t) {
            this.getLogger().warn("Can't parse value '" + value + "' as time in field '" + this.name + "' row " + this.rowIndex + ".", t);
            return defaultValue;
        }
    }

    public java.util.Date parseDate(String value, java.util.Date defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            java.util.Date x = YYYYMMDD_DATE_FORMAT.parse(value);
            return new Date(x.getTime());
        }
        catch (Throwable t) {
            this.getLogger().warn("Can't parse value '" + value + "' as date in field '" + this.name + "' row " + this.rowIndex + ".", t);
            return defaultValue;
        }
    }

    void setName(String fieldName) {
        this.name = fieldName;
    }

    void setRowIndex(long i) {
        this.rowIndex = i;
    }
}

