/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.jdbc.exception.SQLRuntimeException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionBase
implements JDBCConnection {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JDBCConnectionBase.class);
    protected Connection conn;
    protected DataTransactionServices transaction;
    protected final String id;
    protected final ConnectionProvider connectionProvider;

    public JDBCConnectionBase(DataTransactionServices transaction, Connection conn, String id) {
        this(transaction, conn, id, null);
    }

    public JDBCConnectionBase(DataTransactionServices transaction, Connection conn, String id, ConnectionProvider connectionProvider) {
        this.id = id;
        this.transaction = transaction;
        this.conn = conn;
        if (this.transaction != null) {
            this.transaction.addConnection((DataTransactionServices.ConnectionService)this);
        }
        this.connectionProvider = connectionProvider;
        if (LOGGER.isDebugEnabled()) {
            if (this.connectionProvider != null) {
                LOGGER.debug("CONN INIT  " + JDBCUtils.getConnId(this.conn) + " trans: " + JDBCUtils.getHexId(this.transaction) + " status: " + this.connectionProvider.getStatus());
            } else {
                LOGGER.debug("CONN INIT  " + JDBCUtils.getConnId(this.conn) + " trans: " + JDBCUtils.getHexId(this.transaction) + " status: UNKNOWN");
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void close() throws SQLException {
        String connid = JDBCUtils.getConnId(this.conn);
        if (this.transaction != null) {
            if (LOGGER.isDebugEnabled()) {
                if (this.connectionProvider == null) {
                    LOGGER.debug("CONN SKIP CLOSE " + connid + " trans: " + JDBCUtils.getHexId(this.transaction) + " status: UNKNOWN");
                } else {
                    LOGGER.debug("CONN SKIP CLOSE " + connid + " trans: " + JDBCUtils.getHexId(this.transaction) + " status: " + this.connectionProvider.getStatus());
                }
            }
            return;
        }
        this.conn.close();
        if (LOGGER.isDebugEnabled()) {
            if (this.connectionProvider == null) {
                LOGGER.debug("CONN CLOSE " + connid + " trans: NULL status: UNKNOWN");
            } else {
                LOGGER.debug("CONN CLOSE " + connid + " trans: NULL status: " + this.connectionProvider.getStatus());
            }
        }
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (SQLException ex) {
            LOGGER.debug("", (Throwable)ex);
        }
    }

    public boolean isInTransaction() {
        try {
            return !this.conn.getAutoCommit();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public boolean isInDataTransaction() {
        return this.transaction != null && this.transaction.isInProgress();
    }

    public void begin() throws SQLException {
        if (this.conn.getAutoCommit()) {
            this.conn.setAutoCommit(false);
        }
    }

    public void rollback() throws SQLException {
        if (this.transaction != null && this.transaction.isInProgress()) {
            return;
        }
        this.conn.rollback();
        this.conn.setAutoCommit(true);
    }

    public void commit() throws SQLException {
        if (this.transaction != null && this.transaction.isInProgress()) {
            return;
        }
        this.conn.commit();
        this.conn.setAutoCommit(true);
    }

    public Connection get() {
        return this.conn;
    }

    public void execute(String sql) throws SQLException {
        JDBCUtils.execute(this.conn, sql);
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public Statement createStatement(String sql) throws SQLException {
        return this.conn.createStatement();
    }

    public Statement createStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void dispose() {
        try {
            try {
                this.conn.rollback();
            }
            catch (Exception ex) {
                LOGGER.debug("", (Throwable)ex);
            }
            String connid = JDBCUtils.getConnId(this.conn);
            this.conn.close();
            if (LOGGER.isDebugEnabled()) {
                if (this.connectionProvider == null) {
                    LOGGER.debug("CONN CLOSE " + connid + " trans: NULL status: UNKNOWN");
                } else {
                    LOGGER.debug("CONN CLOSE " + connid + " trans: NULL status: " + this.connectionProvider.getStatus());
                }
            }
            this.conn = null;
            this.transaction = null;
        }
        catch (Exception ex) {
            LOGGER.debug("", (Throwable)ex);
        }
    }

    public void finish() throws DataException {
        try {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new DataSQLException(ex);
        }
    }

    public void abort() throws DataException {
        try {
            this.conn.rollback();
            this.conn.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new DataSQLException(ex);
        }
    }

    protected static class DataSQLException
    extends DataException {
        public DataSQLException(SQLException cause) {
            super(cause.getMessage(), (Throwable)cause, "_SQLException_" + cause.getSQLState(), 111L);
        }
    }
}

