/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.fmap.dal.feature.FeatureRules;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceParameters;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.spi.AbstractResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.ResulSetControler;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCSetProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AppendOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CalculateEnvelopeOfColumnOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CanModifyTableOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CountOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.DeletePassThroughOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureProviderByReferenceOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.PerformChangesOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.UpdatePassThroughOperation;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCStoreProviderBase
extends AbstractFeatureStoreProvider
implements ResourceConsumer,
JDBCStoreProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JDBCStoreProviderBase.class);
    protected final JDBCHelper helper;
    protected JDBCStoreProvider.CalculatedValue<Long> count = null;
    protected JDBCStoreProvider.CalculatedValue<Envelope> envelope = null;
    protected JDBCStoreProvider.CalculatedValue<Boolean> allowWrite = null;
    protected AppendOperation appendOperation = null;
    protected Observer transactionObserver;

    protected JDBCStoreProviderBase(JDBCStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata, JDBCHelper helper) throws InitializeException {
        super((DataStoreParameters)params, storeServices, metadata);
        this.helper = helper;
        this.initializeFeatureType();
        try {
            FeatureType featureType;
            if (BooleanUtils.isTrue((Boolean)((Boolean)params.getDynValue("precalculateEnvelope"))) && !StringUtils.isEmpty((CharSequence)(featureType = this.getStoreServices().getDefaultFeatureType()).getDefaultGeometryAttributeName())) {
                Thread thread = new Thread(() -> {
                    LOGGER.trace("Precalculating envelope of '" + this.getSourceId() + "'.");
                    this.getEnvelopeValue().get();
                }, "PrecalculateEnvelopeOfDBTable");
                thread.start();
                Thread.sleep(1L);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Probems precalculating the envelope of table '" + this.getSourceId() + "'.", (Throwable)ex);
        }
        this.transactionObserver = new Observer(){

            public void update(Observable o, Object o1) {
                if (o1 instanceof BaseNotification && (((BaseNotification)o1).isOfType("ROLLBACK") || ((BaseNotification)o1).isOfType("COMMIT"))) {
                    JDBCStoreProviderBase.this.getCountValue().reset();
                    JDBCStoreProviderBase.this.getEnvelopeValue().reset();
                }
            }
        };
    }

    @Override
    public JDBCStoreParameters getParameters() {
        return (JDBCStoreParameters)super.getParameters();
    }

    @Override
    public JDBCHelper getHelper() {
        return this.helper;
    }

    public OperationsFactory getOperations() {
        return this.getHelper().getOperations();
    }

    public String getProviderName() {
        return this.getHelper().getProviderName();
    }

    public int getOIDType() {
        return 0;
    }

    public Object createNewOID() {
        return null;
    }

    public boolean allowAutomaticValues() {
        return this.getHelper().allowAutomaticValues();
    }

    public boolean allowWrite() {
        return this.getAllowWriteValue().get();
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        try {
            IProjection proj;
            if ("Envelope".equalsIgnoreCase(name)) {
                Envelope env = this.getEnvelope();
                if (env != null) {
                    return env;
                }
            } else if ("CRS".equalsIgnoreCase(name) && (proj = this.getFeatureStore().getDefaultFeatureType().getDefaultSRS()) != null) {
                return proj;
            }
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
        return super.getDynValue(name);
    }

    @Override
    public JDBCStoreProvider.CalculatedValue<Long> getCountValue() {
        if (this.count == null) {
            this.count = new CountValue();
        }
        return this.count;
    }

    @Override
    public JDBCStoreProvider.CalculatedValue<Envelope> getEnvelopeValue() {
        if (this.envelope == null) {
            this.envelope = new EnvelopeValue();
        }
        return this.envelope;
    }

    @Override
    public JDBCStoreProvider.CalculatedValue<Boolean> getAllowWriteValue() {
        if (this.allowWrite == null) {
            this.allowWrite = new AllowWriteValue();
        }
        return this.allowWrite;
    }

    public long getFeatureCount() throws DataException {
        return this.getCountValue().get();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        ResulSetControler resulSetControler = this.getHelper().getResulSetControler();
        resulSetControler.pack();
        return resulSetControler.getOpenCount() == 0;
    }

    public void close() throws CloseException {
        JDBCUtils.closeQuietly(this.getHelper());
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        JDBCStoreParameters params = this.getParameters();
        try {
            DynField[] fields;
            JDBCServerExplorerParameters exParams = this.getHelper().createServerExplorerParameters();
            for (DynField field : fields = exParams.getDynClass().getDynFields()) {
                try {
                    exParams.setDynValue(field.getName(), params.getDynValue(field.getName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            exParams.setHost(params.getHost());
            exParams.setPort(params.getPort());
            exParams.setDBName(params.getDBName());
            exParams.setUser(params.getUser());
            exParams.setPassword(params.getPassword());
            exParams.setUrl(params.getUrl());
            exParams.setCatalog(params.getCatalog());
            exParams.setSchema(params.getSchema());
            exParams.setJDBCDriverClassName(params.getJDBCDriverClassName());
            DataServerExplorer explorer = manager.openServerExplorer(exParams.getExplorerName(), (DataServerExplorerParameters)exParams);
            DataTransaction.add((DataTransaction)this.helper.getTransaction(), (DataServerExplorer)explorer, (boolean)false);
            return explorer;
        }
        catch (Exception e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
    }

    protected void doDispose() throws BaseException {
        if (this.helper.getTransaction() != null) {
            this.helper.getTransaction().deleteObserver(this.transactionObserver);
        }
        this.close();
        this.getHelper().dispose();
        super.doDispose();
    }

    @Override
    public String getSourceId() {
        try {
            return this.getHelper().getSourceId(this.getParameters());
        }
        catch (Exception ex) {
            return "unknow";
        }
    }

    public String getName() {
        return this.getParameters().getTable();
    }

    public String getFullName() {
        return this.getHelper().getSourceId(this.getParameters());
    }

    public ResourceProvider getResource() {
        Object r = this.getHelper().getResource();
        if (r == null) {
            try {
                r = new DummyResource(this.getName());
            }
            catch (InitializeException ex) {
                LOGGER.warn("Can't create DummyResource", (Throwable)ex);
            }
        }
        return r;
    }

    public void open() throws OpenException {
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType featureType) throws DataException {
        JDBCSetProvider set = new JDBCSetProvider(this, this.getHelper(), query, featureType);
        return set;
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        JDBCSetProvider set = new JDBCSetProvider(this, this.getHelper(), query, providerFeatureType, storeFeatureType);
        return set;
    }

    protected void initializeFeatureType() {
        EditableFeatureType type = this.getStoreServices().createFeatureType(this.getName());
        JDBCStoreParameters params = this.getParameters();
        List<String> primaryKeys = null;
        if (params.getPkFields() != null) {
            primaryKeys = Arrays.asList(params.getPkFields());
        }
        FetchFeatureTypeOperation fetchFeatureType = this.getOperations().createFetchFeatureType(type, this.getOperations().createTableReference(params), primaryKeys, params.getDefaultGeometryField(), params.getCRS(), params.getGeometryType(), params.getGeometrySubtype());
        fetchFeatureType.perform();
        if (!StringUtils.isBlank((CharSequence)params.getDefaultGeometryField())) {
            if (!params.getDefaultGeometryField().equalsIgnoreCase(type.getDefaultGeometryAttributeName())) {
                if (type.getAttributeDescriptor(params.getDefaultGeometryField()) != null) {
                    type.setDefaultGeometryAttributeName(params.getDefaultGeometryField());
                } else {
                    type.setDefaultGeometryAttributeName(null);
                }
                if (type.getDefaultGeometryAttribute() != null) {
                    EditableFeatureAttributeDescriptor attr = (EditableFeatureAttributeDescriptor)type.getDefaultGeometryAttribute();
                    attr.setGeometryType(0, 0);
                }
            } else {
                type.setDefaultGeometryAttributeName(null);
            }
        }
        FeatureType defaultType = type.getNotEditableCopy();
        this.getHelper().setProviderFeatureType(defaultType);
        List<FeatureType> types = Collections.singletonList(defaultType);
        this.getStoreServices().setFeatureTypes(types, defaultType);
    }

    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference, FeatureType featureType) throws DataException {
        JDBCStoreParameters params = this.getParameters();
        FetchFeatureProviderByReferenceOperation fetchFeatureProviderByReference = this.getOperations().createFetchFeatureProviderByReference(reference, featureType, this.getOperations().createTableReference(params));
        FeatureProvider feature = (FeatureProvider)fetchFeatureProviderByReference.perform();
        return feature;
    }

    public Envelope getEnvelope() throws DataException {
        return this.getEnvelopeValue().get();
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator featureTypesChanged) throws DataException {
        FeatureType type = this.getFeatureStore().getDefaultFeatureType();
        JDBCStoreParameters params = this.getParameters();
        PerformChangesOperation performChanges = this.getOperations().createPerformChanges(this.getOperations().createTableReference(params), type, deleteds, inserteds, updateds, featureTypesChanged, this.getStoreServices());
        performChanges.perform();
        if (performChanges.isTypeChanged()) {
            FeatureRules saved_rules = this.getFeatureStore().getDefaultFeatureType().getRules();
            this.initializeFeatureType();
            FeatureType featureType = this.getFeatureStore().getDefaultFeatureType();
            FeatureRules rules = featureType.getRules();
            rules.clear();
            for (FeatureRule rule : saved_rules) {
                rules.add(rule);
            }
        }
        this.getCountValue().reset();
        this.getEnvelopeValue().reset();
    }

    public boolean supportsAppendMode() {
        return true;
    }

    protected AppendOperation createAppendOperation() throws DataException {
        FeatureType type = this.getFeatureStore().getDefaultFeatureType();
        JDBCStoreParameters params = this.getParameters();
        AppendOperation theAppendOperation = this.getOperations().createAppend(this.getOperations().createTableReference(params), type);
        return theAppendOperation;
    }

    public void endAppend() throws DataException {
        this.appendOperation.end();
        this.getCountValue().reset();
        this.getEnvelopeValue().reset();
    }

    public void abortAppend() throws DataException {
        this.appendOperation.abort();
    }

    public void beginAppend() throws DataException {
        this.beginAppend(0);
    }

    public void beginAppend(int submode) throws DataException {
        if (this.appendOperation == null) {
            this.appendOperation = this.createAppendOperation();
        }
        this.appendOperation.begin(submode);
    }

    public void append(FeatureProvider featureProvider) throws DataException {
        this.appendOperation.append(featureProvider);
    }

    public boolean canWriteGeometry(int geometryType, int geometrySubtype) throws DataException {
        return this.getHelper().canWriteGeometry(geometryType, geometrySubtype);
    }

    public boolean supportsPassThroughMode() {
        return true;
    }

    public void passThroughInsert(FeatureProvider featureProvider) throws DataException {
        FeatureType type = this.getFeatureStore().getDefaultFeatureType();
        JDBCStoreParameters params = this.getParameters();
        PerformChangesOperation performChanges = this.getOperations().createPerformChanges(this.getOperations().createTableReference(params), type, Collections.emptyIterator(), Collections.singletonList(featureProvider).iterator(), Collections.emptyIterator(), Collections.emptyIterator(), this.getStoreServices());
        performChanges.perform();
        this.getCountValue().reset();
        this.getEnvelopeValue().reset();
    }

    public void passThroughUpdate(FeatureProvider featureProvider) throws DataException {
        FeatureType type = this.getFeatureStore().getDefaultFeatureType();
        JDBCStoreParameters params = this.getParameters();
        PerformChangesOperation performChanges = this.getOperations().createPerformChanges(this.getOperations().createTableReference(params), type, Collections.emptyIterator(), Collections.emptyIterator(), Collections.singletonList(featureProvider).iterator(), Collections.emptyIterator(), this.getStoreServices());
        performChanges.perform();
        this.getEnvelopeValue().reset();
    }

    public void passThroughUpdate(Object[] parameters, Expression filter) {
        JDBCStoreParameters params = this.getParameters();
        UpdatePassThroughOperation operation = this.getOperations().createUpdatePassThroughOperation(this.getOperations().createTableReference(params), parameters, filter);
        operation.perform();
        this.getEnvelopeValue().reset();
    }

    public void passThroughDelete(FeatureReferenceProviderServices featureReference) throws DataException {
        FeatureType type = this.getFeatureStore().getDefaultFeatureType();
        JDBCStoreParameters params = this.getParameters();
        PerformChangesOperation performChanges = this.getOperations().createPerformChanges(this.getOperations().createTableReference(params), type, Collections.singletonList(featureReference).iterator(), Collections.emptyIterator(), Collections.emptyIterator(), Collections.emptyIterator(), this.getStoreServices());
        performChanges.perform();
        this.getCountValue().reset();
        this.getEnvelopeValue().reset();
    }

    public void passThroughDelete(Expression expression) throws DataException {
        JDBCStoreParameters params = this.getParameters();
        DeletePassThroughOperation operation = this.getOperations().createDeletePassThroughOperation(this.getOperations().createTableReference(params), expression);
        operation.perform();
        this.getCountValue().reset();
        this.getEnvelopeValue().reset();
    }

    public void setTransaction(DataTransactionServices transaction) {
        if (this.helper.getTransaction() != null) {
            this.helper.getTransaction().deleteObserver(this.transactionObserver);
        }
        this.helper.setTransaction(transaction);
        if (transaction != null) {
            transaction.addObserver(this.transactionObserver);
        }
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("hash", (Object)String.format("%x", this.hashCode()));
            builder.append("helper", (Object)this.helper, true);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public void refresh() throws OpenException {
        this.count = null;
        this.envelope = null;
        this.allowWrite = null;
        super.refresh();
    }

    private static class DummyResource
    extends AbstractResource {
        private final String name;

        DummyResource(String name) throws InitializeException {
            super((ResourceParameters)null);
            this.name = name;
        }

        public String getName() throws AccessResourceException {
            return MessageFormat.format("DummyResource({0})", this.name);
        }

        public Object get() throws AccessResourceException {
            return null;
        }

        public boolean isThis(ResourceParameters parameters) throws ResourceException {
            return true;
        }
    }

    public class AllowWriteValue
    implements JDBCStoreProvider.CalculatedValue<Boolean> {
        private Boolean value = null;

        @Override
        public void calculate() {
            try {
                JDBCStoreParameters params = JDBCStoreProviderBase.this.getParameters();
                CanModifyTableOperation canModifyTable = JDBCStoreProviderBase.this.getOperations().createCanModifyTableOperation(JDBCStoreProviderBase.this.getOperations().createTableReference(params));
                this.value = (boolean)((Boolean)canModifyTable.perform());
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't determine if allow write.", ex);
            }
        }

        @Override
        public void reset() {
            this.value = null;
        }

        @Override
        public Boolean get() {
            if (this.value == null) {
                this.calculate();
            }
            return this.value;
        }
    }

    public class EnvelopeValue
    implements JDBCStoreProvider.CalculatedValue<Envelope> {
        private Envelope value = null;
        private boolean needCalculate = true;

        @Override
        public void calculate() {
            FeatureType featureType;
            try {
                FeatureStore featureStore = JDBCStoreProviderBase.this.getFeatureStore();
                if (featureStore == null) {
                    return;
                }
                featureType = featureStore.getDefaultFeatureType();
                if (featureType == null) {
                    return;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't calculate envelope.", ex);
            }
            try {
                this.value = null;
                String columnName = featureType.getDefaultGeometryAttributeName();
                if (columnName == null) {
                    return;
                }
                FeatureAttributeDescriptor attr = featureType.getAttributeDescriptor(columnName);
                boolean toDataBase = true;
                if (attr.isComputed()) {
                    FeatureAttributeEmulator attrEmulator = attr.getFeatureAttributeEmulator();
                    if (!(attrEmulator instanceof FeatureAttributeEmulatorExpression)) {
                        toDataBase = false;
                    } else {
                        FeatureAttributeEmulatorExpression x = (FeatureAttributeEmulatorExpression)attrEmulator;
                        Expression exp = x.getExpression();
                        if (exp == null || exp.isEmpty()) {
                            toDataBase = false;
                        } else if (!JDBCStoreProviderBase.this.helper.supportExpression(null, exp.getPhrase())) {
                            toDataBase = false;
                        }
                    }
                }
                if (toDataBase) {
                    IProjection crs = JDBCStoreProviderBase.this.getFeatureStore().getDefaultFeatureType().getDefaultSRS();
                    JDBCStoreParameters params = JDBCStoreProviderBase.this.getParameters();
                    CalculateEnvelopeOfColumnOperation calculateEnvelopeOfColumn = JDBCStoreProviderBase.this.getOperations().createCalculateEnvelopeOfColumn(JDBCStoreProviderBase.this.getFeatureStore().getDefaultFeatureType(), JDBCStoreProviderBase.this.getOperations().createTableReference(params), columnName, params.getBaseFilter(), params.getWorkingArea(), crs);
                    this.value = (Envelope)calculateEnvelopeOfColumn.perform();
                } else {
                    FeatureSet fset = JDBCStoreProviderBase.this.getFeatureStore().getFeatureSet();
                    Envelope finalEnvelope = GeometryUtils.createEnvelope((int)0);
                    for (Feature feature : fset) {
                        Geometry geometry = feature.getGeometry(columnName);
                        finalEnvelope.add(geometry);
                    }
                    this.value = finalEnvelope;
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException("Can't calculate envelope.", ex);
            }
            finally {
                this.needCalculate = false;
            }
        }

        @Override
        public void reset() {
            this.value = null;
            this.needCalculate = true;
        }

        @Override
        public synchronized Envelope get() {
            if (this.needCalculate) {
                this.calculate();
            }
            return this.value;
        }
    }

    public class CountValue
    implements JDBCStoreProvider.CalculatedValue<Long> {
        private Long value = null;

        @Override
        public void calculate() {
            try {
                JDBCStoreParameters params = JDBCStoreProviderBase.this.getParameters();
                CountOperation count = JDBCStoreProviderBase.this.getOperations().createCount(JDBCStoreProviderBase.this.getFeatureStore().getDefaultFeatureType(), JDBCStoreProviderBase.this.getOperations().createTableReference(params), params.getBaseFilter(), null);
                this.value = (Long)count.perform();
            }
            catch (DataException ex) {
                throw new RuntimeException("Can't calculate count", ex);
            }
        }

        @Override
        public void reset() {
            this.value = null;
        }

        @Override
        public Long get() {
            if (this.value == null) {
                this.calculate();
            }
            return this.value;
        }
    }
}

