/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRSSolverBase
implements SRSSolver {
    protected static final Logger logger = LoggerFactory.getLogger(SRSSolverBase.class);
    protected Map<Integer, String> database2applicationAbbrev;
    protected Map<String, Integer> applicationAbbrev2database;
    protected JDBCHelper helper;

    public SRSSolverBase(JDBCHelper helper) {
        this.helper = helper;
        this.applicationAbbrev2database = new HashMap<String, Integer>();
        this.database2applicationAbbrev = new HashMap<Integer, String>();
    }

    @Override
    public void add(Object databaseCode, String applicationAbbrev) {
        this.applicationAbbrev2database.put(applicationAbbrev, (Integer)databaseCode);
        this.database2applicationAbbrev.put((Integer)databaseCode, applicationAbbrev);
    }

    @Override
    public Integer getDatabaseCode(JDBCConnection connection, String applicationAbbrev) {
        if (this.hasApplicationAbbrev(connection, applicationAbbrev)) {
            return this.applicationAbbrev2database.get(applicationAbbrev);
        }
        Integer databaseCode = (Integer)this.searchDatabaseCode(connection, applicationAbbrev);
        this.add(databaseCode, applicationAbbrev);
        return databaseCode;
    }

    @Override
    public String getApplicationAbbrev(JDBCConnection connection, Object databaseCode) {
        if (this.hasDatabaseCode(connection, databaseCode)) {
            return this.database2applicationAbbrev.get((Integer)databaseCode);
        }
        String applicationAbbrev = this.searchApplicationAbbrev(connection, (Integer)databaseCode);
        if (StringUtils.isEmpty((CharSequence)applicationAbbrev)) {
            return null;
        }
        this.add(databaseCode, applicationAbbrev);
        return applicationAbbrev;
    }

    @Override
    public boolean hasDatabaseCode(JDBCConnection connection, Object databaseCode) {
        return this.database2applicationAbbrev.containsKey((Integer)databaseCode);
    }

    @Override
    public boolean hasApplicationAbbrev(JDBCConnection connection, String applicationAbbrev) {
        return this.applicationAbbrev2database.containsKey(applicationAbbrev);
    }

    protected Object searchDatabaseCode(JDBCConnection connection, String applicationAbbrev) {
        String sql = "select srid, auth_name, auth_srid from spatial_ref_sys where auth_name/auth_srid is '" + applicationAbbrev + "'.";
        try {
            String[] s = applicationAbbrev.split(":");
            sql = "select srid, auth_name, auth_srid from spatial_ref_sys where upper(auth_name) = upper('" + s[0] + "') and auth_srid = " + s[1] + " ";
            Statement st = connection.createStatement(sql);
            ResultSet rs = JDBCUtils.executeQuery(st, sql);
            if (rs.next()) {
                Integer srid = rs.getInt("srid");
                return srid;
            }
            return null;
        }
        catch (Throwable ex) {
            logger.warn("Can't retrieve SRS code from spatial_ref_sys (" + sql + ").", ex);
            throw new RuntimeException("Can't retrieve SRS code from spatial_ref_sys (" + sql + ").", ex);
        }
    }

    protected String searchApplicationAbbrev(JDBCConnection connection, Integer databaseCode) {
        String sql = "select srid, auth_name, auth_srid from spatial_ref_sys where srid = " + databaseCode;
        try {
            Statement st = connection.createStatement(sql);
            ResultSet rs = JDBCUtils.executeQuery(st, sql);
            if (rs.next()) {
                int auth_code = rs.getInt("auth_srid");
                String auth_name = rs.getString("auth_name");
                return auth_name + ":" + auth_code;
            }
            return null;
        }
        catch (Throwable ex) {
            logger.warn("Can't retrieve SRS from spatial_ref_sys (" + sql + ").", ex);
            throw new RuntimeException("Can't retrieve SRS from spatial_ref_sys (" + sql + ").", ex);
        }
    }

    @Override
    public IProjection getProjection(JDBCConnection connection, Object databaseCode) {
        if (databaseCode == null) {
            return null;
        }
        String s = databaseCode.toString().trim();
        if (s.equals("0")) {
            return null;
        }
        String abbrev = this.getApplicationAbbrev(connection, databaseCode);
        if (StringUtils.isEmpty((CharSequence)abbrev)) {
            return null;
        }
        IProjection proj = CRSFactory.getCRS((String)abbrev);
        return proj;
    }

    @Override
    public Integer getDatabaseCode(JDBCConnection connection, IProjection projection) {
        if (projection == null) {
            return 0;
        }
        Integer srscode = this.getDatabaseCode(connection, projection.getAbrev());
        return srscode;
    }
}

