/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.converstocode;

import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.ConverterToCode;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;

public class ProjectionToCode
implements ConverterToCode {
    public String getName() {
        return "Projection";
    }

    public boolean isApplicable(Object ... os) {
        return os[0] instanceof IProjection;
    }

    public Code toCode(CodeBuilder builder, Object obj, Map props) {
        try {
            if (obj == null) {
                return null;
            }
            IProjection proj = (IProjection)obj;
            String abrev = proj.getAbrev();
            String srid = abrev.split(":")[1];
            return builder.constant((Object)Integer.valueOf(srid));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't convert projection to code", ex);
        }
    }

    public static void selfRegister() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        manager.registerCodeConverter((ConverterToCode)new ProjectionToCode());
    }
}

