/*
 * Decompiled with CFR 0.152.
 */
package com.notification;

import com.exception.NotificationException;
import com.notification.Notification;
import com.notification.NotificationBuilder;
import com.notification.types.AcceptNotification;
import com.notification.types.IconNotification;
import com.notification.types.ProgressBarNotification;
import com.notification.types.TextNotification;
import com.theme.TextTheme;
import com.theme.ThemePackage;
import com.theme.ThemePackagePresets;
import com.theme.WindowTheme;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class NotificationFactory {
    private ThemePackage m_pack;
    private HashMap<Class<? extends Notification>, NotificationBuilder<? extends Notification>> m_builders = new HashMap();

    public NotificationFactory() {
        this.m_builders.put(TextNotification.class, new TextNotificationBuilder());
        this.m_builders.put(AcceptNotification.class, new AcceptNotificationBuilder());
        this.m_builders.put(IconNotification.class, new IconNotificationBuilder());
        this.m_builders.put(ProgressBarNotification.class, new ProgressBarNotificationBuilder());
        this.setThemePackage(ThemePackagePresets.cleanLight());
    }

    public NotificationFactory(ThemePackage pack) {
        this.m_builders.put(TextNotification.class, new TextNotificationBuilder());
        this.m_builders.put(AcceptNotification.class, new AcceptNotificationBuilder());
        this.m_builders.put(IconNotification.class, new IconNotificationBuilder());
        this.m_builders.put(ProgressBarNotification.class, new ProgressBarNotificationBuilder());
        this.setThemePackage(pack);
    }

    public void setThemePackage(ThemePackage pack) {
        this.m_pack = pack;
    }

    public <T extends Notification> void addBuilder(Class<T> notificationClass, NotificationBuilder<T> builder) {
        this.m_builders.put(notificationClass, builder);
    }

    public <T extends Notification> void removeBuilder(Class<T> notificationClass) {
        this.m_builders.remove(notificationClass);
    }

    public <T extends Notification> T build(Class<T> notificationClass) {
        if (!this.m_builders.containsKey(notificationClass)) {
            throw new RuntimeException("No NotificationBuilder for: " + notificationClass);
        }
        Notification note = this.m_builders.get(notificationClass).buildNotification(this.m_pack, new Object[0]);
        return (T)note;
    }

    public <T extends Notification> T build(Class<T> notificationClass, Object ... args) {
        if (!this.m_builders.containsKey(notificationClass)) {
            throw new RuntimeException("No NotificationBuilder for: " + notificationClass);
        }
        Notification note = this.m_builders.get(notificationClass).buildNotification(this.m_pack, args);
        return (T)note;
    }

    public TextNotification buildTextNotification(String title, String subtitle) {
        return this.build(TextNotification.class, title, subtitle);
    }

    public AcceptNotification buildAcceptNotification(String title, String subtitle) {
        return this.build(AcceptNotification.class, title, subtitle);
    }

    public AcceptNotification buildAcceptNotification(String title, String subtitle, String accept, String decline) {
        return this.build(AcceptNotification.class, title, subtitle, accept, decline);
    }

    public IconNotification buildIconNotification(String title, String subtitle, ImageIcon icon) {
        return this.build(IconNotification.class, title, subtitle, icon);
    }

    public ProgressBarNotification buildProgressBarNotification(String title) {
        return this.build(ProgressBarNotification.class, title);
    }

    private class ProgressBarNotificationBuilder
    implements NotificationBuilder<ProgressBarNotification> {
        private ProgressBarNotificationBuilder() {
        }

        @Override
        public ProgressBarNotification buildNotification(ThemePackage pack, Object ... args) {
            if (args.length != 1) {
                throw new NotificationException("ProgressBarNotifications need one argument: title!");
            }
            ProgressBarNotification note = new ProgressBarNotification();
            note.setWindowTheme(pack.getTheme(WindowTheme.class));
            note.setTextTheme(pack.getTheme(TextTheme.class));
            note.setTitle((String)args[0]);
            return note;
        }
    }

    private class IconNotificationBuilder
    implements NotificationBuilder<IconNotification> {
        private IconNotificationBuilder() {
        }

        @Override
        public IconNotification buildNotification(ThemePackage pack, Object ... args) {
            if (args.length != 3) {
                throw new NotificationException("IconNotifications need three arguments: title, subtitle, icon!");
            }
            IconNotification note = new IconNotification();
            note.setWindowTheme(pack.getTheme(WindowTheme.class));
            note.setTextTheme(pack.getTheme(TextTheme.class));
            note.setTitle((String)args[0]);
            note.setSubtitle((String)args[1]);
            note.setIcon((Icon)args[2]);
            return note;
        }
    }

    private class AcceptNotificationBuilder
    implements NotificationBuilder<AcceptNotification> {
        private AcceptNotificationBuilder() {
        }

        @Override
        public AcceptNotification buildNotification(ThemePackage pack, Object ... args) {
            if (args.length != 2 && args.length != 4) {
                throw new NotificationException("AcceptNotifications need two or four arguments: title, subtitle, accept text, decline text!");
            }
            AcceptNotification note = new AcceptNotification();
            note.setWindowTheme(pack.getTheme(WindowTheme.class));
            note.setTextTheme(pack.getTheme(TextTheme.class));
            note.setTitle((String)args[0]);
            note.setSubtitle((String)args[1]);
            if (args.length == 4) {
                note.setAcceptText((String)args[2]);
                note.setDeclineText((String)args[3]);
            }
            return note;
        }
    }

    private class TextNotificationBuilder
    implements NotificationBuilder<TextNotification> {
        private TextNotificationBuilder() {
        }

        @Override
        public TextNotification buildNotification(ThemePackage pack, Object ... args) {
            if (args.length != 2) {
                throw new NotificationException("TextNotifications need two arguments: title, subtitle!");
            }
            TextNotification note = new TextNotification();
            note.setWindowTheme(pack.getTheme(WindowTheme.class));
            note.setTextTheme(pack.getTheme(TextTheme.class));
            note.setTitle((String)args[0]);
            note.setSubtitle((String)args[1]);
            return note;
        }
    }

    public static enum Location {
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;

    }
}

