/*
 * Decompiled with CFR 0.152.
 */
package com.platform;

import com.platform.DefaultOperatingSystem;
import com.platform.Mac;
import com.platform.OperatingSystem;
import com.platform.Unix;
import com.platform.Windows;

public class Platform {
    private OperatingSystem m_operatingSystem;
    private boolean m_used = false;
    private static Platform INSTANCE;

    public Platform() {
        String os = System.getProperty("os.name").toLowerCase();
        this.m_operatingSystem = new DefaultOperatingSystem();
        if (os.indexOf("win") >= 0) {
            this.m_operatingSystem = new Windows();
        }
        if (os.indexOf("mac") >= 0) {
            this.m_operatingSystem = new Mac();
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0) {
            this.m_operatingSystem = new Unix();
        }
    }

    public OperatingSystem getOperatingSystem() {
        return this.m_operatingSystem;
    }

    public boolean isSupported(String feature) {
        return this.m_operatingSystem.isSupported(feature);
    }

    public boolean isUsed() {
        return this.m_used;
    }

    public void setAdjustForPlatform(boolean used) {
        this.m_used = used;
    }

    public static Platform instance() {
        if (INSTANCE == null) {
            INSTANCE = new Platform();
        }
        return INSTANCE;
    }
}

