/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.trimline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.ProcessingValueRuntimeException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class TrimPolygonEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final int TOLERANCE_PIXELS = 3;
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter geometryToTrimWithParameter;
    private final EditingServiceParameter shearingPointParameter;
    protected Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private List<Feature> selectedFeatures;

    public TrimPolygonEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.geometryToTrimWithParameter = new DefaultEditingServiceParameter("geometry_to_trim_with", "geometry_to_trim_with", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.MULTILAYER_SELECTION});
        this.shearingPointParameter = new DefaultEditingServiceParameter("shearing_point", "shearing_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.geometryToTrimWithParameter) == null) {
            return this.geometryToTrimWithParameter;
        }
        if (this.values.get(this.shearingPointParameter) == null) {
            return this.shearingPointParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        Geometry shears = (Geometry)this.values.get(this.geometryToTrimWithParameter);
        if (this.selectedFeatures != null && shears != null) {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
            try {
                for (Feature feature : this.selectedFeatures) {
                    if (feature == null) continue;
                    ISymbol previewSymbol = this.getPreviewSymbol(feature);
                    Geometry geometry = feature.getDefaultGeometry();
                    if (geometry == null || !geometry.intersects(shears)) continue;
                    MultiPolygon trimmedSurface = this.trimSurface(mousePosition, geometry, shears);
                    drawingStatus.addStatus((Geometry)trimmedSurface, polygonSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)trimmedSurface, previewSymbol, "");
                }
            }
            catch (BaseException ex) {
                throw new DrawServiceException((Throwable)ex);
            }
            return drawingStatus;
        }
        return null;
    }

    private MultiPolygon trimSurface(Point shearingPoint, Geometry geometry, Geometry shearsGeometry) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException, GeometryException {
        int subType = geometry.getGeometryType().getSubType();
        MultiPolygon res = GeometryUtils.createMultiPolygon((int)subType);
        MultiPolygon polygons = geometry.toPolygons();
        for (Geometry polygon : polygons) {
            if (shearsGeometry.contains((Geometry)shearingPoint)) {
                res.addPrimitives(polygon.intersection(shearsGeometry));
                continue;
            }
            res.addPrimitives(polygon.difference(shearsGeometry));
        }
        return res;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        parameters.add(this.geometryToTrimWithParameter);
        parameters.add(this.shearingPointParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.selectionParameter) {
            this.selectedFeatures = this.getSelectedFeaturesCopy((FeatureSelection)value);
            for (Feature feature : this.selectedFeatures) {
                Geometry geometry = feature.getDefaultGeometry();
                if (this.isValidGeometryToSelect(geometry)) continue;
                this.selectedFeatures = Collections.EMPTY_LIST;
                throw new InvalidEntryException(null);
            }
            this.values.put(parameter, value);
            return;
        }
        if (parameter == this.geometryToTrimWithParameter) {
            if (value instanceof Point) {
                Point point = (Point)value;
                Geometry geometry = this.getGeometry(point);
                if (geometry != null) {
                    try {
                        if (this.isValidGeometryToSelect(geometry) && this.selectionIntersectsWithGeometry(geometry)) {
                            this.values.put(parameter, geometry.toPolygons());
                        }
                    }
                    catch (Exception ex) {
                        throw new ProcessingValueRuntimeException((Throwable)ex);
                    }
                    return;
                }
            } else if (value instanceof List) {
                List features = (List)value;
                MultiPolygon geom = null;
                try {
                    Geometry g;
                    Comparator featComparator = (f1, f2) -> {
                        if (f1.getStore() != f2.getStore()) {
                            return -1;
                        }
                        return f1.getReference().getCode().compareTo(f2.getReference().getCode());
                    };
                    for (Feature feature : features) {
                        Geometry geometry;
                        if (ContainerUtils.contains(this.selectedFeatures, (Object)feature, (Comparator)featComparator) || !this.isValidGeometryToSelect(geometry = feature.getDefaultGeometry())) continue;
                        if (geom == null) {
                            geom = geometry.toPolygons();
                            continue;
                        }
                        geom.addPrimitives(geometry);
                    }
                    if (geom != null && geom.getPrimitivesNumber() > 0 && this.selectionIntersectsWithGeometry(g = geom.union())) {
                        this.values.put(parameter, g);
                        return;
                    }
                }
                catch (Exception ex) {
                    if (StringUtils.containsIgnoreCase((CharSequence)ex.getClass().getName(), (CharSequence)"topology")) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        throw new ProcessingValueRuntimeException((Throwable)ex, i18n.getTranslation("_An_topological_error_has_ocurred"));
                    }
                    throw new ProcessingValueRuntimeException((Throwable)ex);
                }
            }
        } else if (parameter == this.shearingPointParameter && value instanceof Point && value instanceof Point) {
            Point point = (Point)value;
            this.values.put(parameter, point);
            return;
        }
        throw new InvalidEntryException(null);
    }

    private boolean isValidGeometryToSelect(Geometry geometry) {
        GeometryType geoType = geometry.getGeometryType();
        return geoType.isTypeOf(3) || geoType.isTypeOf(9);
    }

    private Geometry getGeometry(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = editingProviderServices.getGeometryOfVisibleLayers(point, this.featureStore, this.mapContext, this.selectedFeatures);
        return geometry;
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry shearsGeometry = (Geometry)this.values.get(this.geometryToTrimWithParameter);
        Point point = (Point)this.values.get(this.shearingPointParameter);
        if (this.selectedFeatures != null && shearsGeometry != null && point != null) {
            try {
                for (Feature feature : this.selectedFeatures) {
                    Geometry geometry = feature.getDefaultGeometry();
                    EditableFeature eFeature = feature.getEditable();
                    if (!geometry.intersects(shearsGeometry)) continue;
                    eFeature.setDefaultGeometry((Geometry)this.trimSurface(point, geometry, shearsGeometry));
                    this.featureStore.update(eFeature);
                }
                this.featureStore.getFeatureSelection().deselectAll();
            }
            catch (BaseException ex) {
                throw new FinishServiceException((Throwable)ex);
            }
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selectionParameter, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "modify-trim-polygon";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private boolean selectionIntersectsWithGeometry(Geometry geometry) throws GeometryOperationNotSupportedException, DataException, GeometryOperationException {
        boolean intersects = false;
        if (geometry != null) {
            for (Feature feature : this.selectedFeatures) {
                Geometry featGeometry;
                if (feature == null || (featGeometry = feature.getDefaultGeometry()) == null || !geometry.intersects(featGeometry)) continue;
                return true;
            }
        }
        return intersects;
    }
}

