/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.trimline.operation;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.vectorediting.lib.prov.trimline.operation.TrimLineOperation;
import org.gvsig.vectorediting.lib.prov.trimline.operation.TrimLineOperationUtils;

public class ArcTrimLineOperation
implements TrimLineOperation {
    @Override
    public MultiCurve trimLine(Curve curveToTrim, Point shearsPoint, FeatureSelection shearingObjects) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException, LocatorException {
        Arc arcToTrim = (Arc)curveToTrim;
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = arcToTrim.getGeometryType().getSubType();
        MultiCurve segmentedArc = geoManager.createMultiCurve(subtype);
        segmentedArc.addCurve(curveToTrim);
        DisposableIterator it = shearingObjects.fastIterator();
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            Geometry geometry = feature.getDefaultGeometry();
            Geometry tmpDifference = segmentedArc.difference(geometry);
            if (!(tmpDifference instanceof MultiCurve)) continue;
            segmentedArc = (MultiCurve)tmpDifference;
        }
        int index = 0;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < segmentedArc.getPrimitivesNumber(); ++i) {
            Curve arc = segmentedArc.getCurveAt(i);
            double distance = arc.distance((Geometry)shearsPoint);
            if (!(distance < minDistance)) continue;
            index = i;
            minDistance = distance;
        }
        MultiCurve trimmedArc = geoManager.createMultiCurve(subtype);
        Point center = arcToTrim.getCenterPoint();
        if (center == null) {
            center = geoManager.createPoint(arcToTrim.getEnvelope().getCenter(0), arcToTrim.getEnvelope().getCenter(1), subtype);
        }
        double radius = center.distance((Geometry)arcToTrim.getInitPoint());
        Object tmpCurve = null;
        for (int i = 0; i < segmentedArc.getPrimitivesNumber(); ++i) {
            if (i == index) {
                if (tmpCurve == null) continue;
                trimmedArc.addCurve(tmpCurve);
                tmpCurve = null;
                continue;
            }
            tmpCurve = tmpCurve != null ? this.union(center, radius, (Curve)tmpCurve, segmentedArc.getCurveAt(i)) : segmentedArc.getCurveAt(i);
        }
        if (tmpCurve != null) {
            trimmedArc.addCurve(tmpCurve);
        }
        return trimmedArc;
    }

    private Arc union(Point center, double radius, Curve curveA, Curve curveB) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException, LocatorException {
        int subtype1 = curveA.getGeometryType().getSubType();
        int subtype2 = curveB.getGeometryType().getSubType();
        Arc arc1 = curveA instanceof Arc ? (Arc)curveA : TrimLineOperationUtils.createArc(center, radius, curveA.getVertex(0), curveA.getVertex(curveA.getNumVertices() - 1), subtype1);
        Arc arc2 = curveB instanceof Arc ? (Arc)curveB : TrimLineOperationUtils.createArc(center, radius, curveB.getVertex(0), curveB.getVertex(curveB.getNumVertices() - 1), subtype1);
        if (subtype1 == subtype2) {
            double Xcenter1 = arc1.getCenterPoint().getX();
            double Ycenter1 = arc1.getCenterPoint().getY();
            double Xcenter2 = arc2.getCenterPoint().getX();
            double Ycenter2 = arc2.getCenterPoint().getY();
            double differenceX = Xcenter1 - Xcenter2;
            double differenceY = Ycenter1 - Ycenter2;
            if (Math.abs(differenceX) <= 0.001 && Math.abs(differenceY) <= 0.001) {
                Point tmpCenter = arc1.getCenterPoint();
                double tmpRadius = center.distance((Geometry)arc1.getInitPoint());
                return TrimLineOperationUtils.createArc(tmpCenter, tmpRadius, arc1.getInitPoint(), arc2.getEndPoint(), subtype1);
            }
        }
        return null;
    }

    @Override
    public MultiCurve trimLine(Curve curveToTrim, Point shearingPoint, Geometry boundaryObject) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException, LocatorException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Arc arcToTrim = (Arc)curveToTrim;
        if (!arcToTrim.isCCW()) {
            Arc tmpArcToTrim = (Arc)geomManager.create(arcToTrim.getGeometryType());
            tmpArcToTrim.setPoints(arcToTrim.getEndPoint(), arcToTrim.getMiddlePoint(), arcToTrim.getInitPoint());
            arcToTrim = tmpArcToTrim;
        }
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = arcToTrim.getGeometryType().getSubType();
        MultiCurve segmentedArc = geoManager.createMultiCurve(subtype);
        segmentedArc.addCurve((Curve)arcToTrim);
        Geometry geometry = boundaryObject;
        Geometry tmpDifference = segmentedArc.difference(geometry);
        if (tmpDifference instanceof MultiCurve) {
            segmentedArc = (MultiCurve)tmpDifference;
        }
        double side = TrimLineOperationUtils.getSide(boundaryObject, shearingPoint);
        int index = -1;
        if (!Double.isNaN(side)) {
            double minDistance = Double.POSITIVE_INFINITY;
            for (int i = 0; i < segmentedArc.getPrimitivesNumber(); ++i) {
                Double segmentSide;
                Curve curve = segmentedArc.getCurveAt(i);
                double distance = curve.distance((Geometry)shearingPoint);
                if (!(distance < minDistance) || (segmentSide = TrimLineOperationUtils.getSide(boundaryObject, curve)) != side) continue;
                index = i;
                minDistance = distance;
            }
        }
        MultiCurve trimmedArc = geoManager.createMultiCurve(subtype);
        Point center = arcToTrim.getCenterPoint();
        if (center == null) {
            center = geoManager.createPoint(arcToTrim.getEnvelope().getCenter(0), arcToTrim.getEnvelope().getCenter(1), subtype);
        }
        double radius = center.distance((Geometry)arcToTrim.getInitPoint());
        Object tmpCurve = null;
        for (int i = 0; i < segmentedArc.getPrimitivesNumber(); ++i) {
            if (i == index) {
                if (tmpCurve == null) continue;
                trimmedArc.addCurve(tmpCurve);
                tmpCurve = null;
                continue;
            }
            tmpCurve = tmpCurve != null ? this.union(center, radius, (Curve)tmpCurve, segmentedArc.getCurveAt(i)) : segmentedArc.getCurveAt(i);
        }
        if (tmpCurve != null) {
            trimmedArc.addCurve(tmpCurve);
        }
        return trimmedArc;
    }
}

