/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dxf;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.fmap.dal.store.dxf.DXFStoreProvider;
import org.gvsig.tools.dynobject.DelegatedDynObject;

public class DXFNewStoreParameters
extends AbstractDataStoreParameters
implements FilesystemStoreParameters,
NewFeatureStoreParameters {
    private DelegatedDynObject parameters;

    public DXFNewStoreParameters() {
        this("DXFStoreParameters");
    }

    protected DXFNewStoreParameters(String parametersDefinitionName) {
        this(parametersDefinitionName, "DXF");
    }

    public DXFNewStoreParameters(String parametersDefinitionName, String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters((String)parametersDefinitionName);
        this.setDynValue("ProviderName", name);
    }

    public String getDataStoreName() {
        return (String)this.getDynValue("ProviderName");
    }

    public String getDescription() {
        return this.getDynClass().getDescription();
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public void setCRS(String srs) {
        this.setDynValue("CRS", srs);
    }

    public void setCRS(IProjection srs) {
        this.setDynValue("CRS", srs);
    }

    public IProjection getCRS() {
        return (IProjection)this.getDynValue("CRS");
    }

    public String getFileName() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getPath();
    }

    public boolean isValid() {
        if (this.getCRS() == null) {
            return false;
        }
        return this.getFileName() != null;
    }

    public File getFile() {
        return (File)this.getDynValue("File");
    }

    public void setFile(File file) {
        String wktEsri;
        this.setDynValue("File", file);
        if (this.getCRS() == null && (wktEsri = this.loadPrj(file)) != null) {
            IProjection proj = CRSFactory.getCRSFactory().get("wkt_esri", wktEsri);
            this.setCRS(proj);
        }
    }

    public void setFile(String file) {
        String wktEsri;
        this.setDynValue("File", file);
        File dxfFile = (File)this.getDynValue("File");
        if (this.getCRS() == null && (wktEsri = this.loadPrj(dxfFile)) != null) {
            IProjection proj = CRSFactory.getCRSFactory().get("wkt_esri", wktEsri);
            this.setCRS(proj);
        }
    }

    public EditableFeatureType getDefaultFeatureType() {
        DataManager manager = DALLocator.getDataManager();
        EditableFeatureType featureType = manager.createFeatureType();
        DXFStoreProvider.initializeFeatureType(featureType, null, 1);
        return featureType;
    }

    public void setDefaultFeatureType(FeatureType defaultFeatureType) {
        throw new UnsupportedOperationException();
    }

    private String loadPrj(File dxfFile) {
        File prjFile = new File(FilenameUtils.removeExtension((String)dxfFile.getAbsolutePath()) + ".prj");
        if (prjFile.exists()) {
            try {
                return FileUtils.readFileToString((File)prjFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

