/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.memory;

import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.IteratorIndexTooBigException;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureProviderIterator;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.memory.MemoryFeatureProviderAttributeMapper;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.exception.BaseException;

public class MemoryFeatureSet
extends AbstractFeatureSetProvider {
    protected List data;

    public MemoryFeatureSet(AbstractFeatureStoreProvider store, FeatureQuery query, FeatureType featureType, List data) {
        super(store, query, featureType.equals(store.getStoreServices().getProviderFeatureType(featureType.getId())) ? null : featureType);
        this.data = data;
    }

    @Override
    public boolean canFilter() {
        return false;
    }

    @Override
    public boolean canOrder() {
        return false;
    }

    @Override
    public boolean canIterateFromIndex() {
        return true;
    }

    @Override
    public long getSize() throws DataException {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() throws DataException {
        return this.data.isEmpty();
    }

    protected void doDispose() throws BaseException {
    }

    @Override
    protected AbstractFeatureProviderIterator createFastIterator(long index) throws DataException {
        return this.createIterator(index);
    }

    @Override
    protected AbstractFeatureProviderIterator createIterator(long index) throws DataException {
        Iterator iter;
        if (index > 0L && index >= (long)this.data.size()) {
            throw new IteratorIndexTooBigException(index, (long)this.data.size());
        }
        Iterator iterator = iter = index <= 0L ? this.data.iterator() : this.data.listIterator((int)index);
        if (this.getProviderFeatureType() == null) {
            return new DelegatedDisposableIterator(this.getStore(), iter);
        }
        return new DelegatedDisposableWrappedIterator(this.getStore(), iter, this.getProviderFeatureType());
    }

    protected class DelegatedDisposableWrappedIterator
    extends DelegatedDisposableIterator {
        private FeatureType fType;

        public DelegatedDisposableWrappedIterator(FeatureStoreProvider store, Iterator it, FeatureType featureType) {
            super(store, it);
            this.fType = featureType;
        }

        @Override
        protected Object internalNext() {
            FeatureProvider feature = (FeatureProvider)super.internalNext();
            if (this.fType == null) {
                return feature;
            }
            return new MemoryFeatureProviderAttributeMapper(feature, this.fType);
        }
    }

    protected class DelegatedDisposableIterator
    extends AbstractFeatureProviderIterator {
        private Iterator delegated;

        public DelegatedDisposableIterator(FeatureStoreProvider store, Iterator it) {
            super(store);
            this.delegated = it;
        }

        protected void internalDispose() {
            this.delegated = null;
        }

        @Override
        protected boolean internalHasNext() {
            return this.delegated.hasNext();
        }

        @Override
        protected Object internalNext() {
            Object x = this.delegated.next();
            return x;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void doDispose() throws BaseException {
            if (this.delegated instanceof Disposable) {
                ((Disposable)this.delegated).dispose();
            }
        }
    }
}

