/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.resource.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.ResourceParameters;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.PrepareResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyChangesException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyCloseException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyDisposeException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyOpenException;
import org.gvsig.fmap.dal.resource.spi.AbstractResource;
import org.gvsig.fmap.dal.resource.spi.MultiResourceParameters;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceManagerProviderServices;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiResource
extends AbstractResource {
    public static final String TYPE_NAME = "multi";
    public static final String DESCRIPTION = "Group of multiple resources";
    private static final Logger LOG = LoggerFactory.getLogger(MultiResource.class);
    private Map resources = new HashMap();
    private int defaultResourcePos = 0;
    private boolean isFrozen = false;

    public MultiResource(MultiResourceParameters parameters) throws InitializeException {
        super(parameters);
    }

    private List getResources() {
        return new ArrayList(this.resources.values());
    }

    public void addResource(ResourceParameters parameters, boolean defaultResource) throws InitializeException {
        String name = (String)parameters.getDynValue("name");
        this.commonAddResource(name, parameters, defaultResource);
    }

    public void addResource(String name, Object[] params, boolean defaultResource) throws InitializeException {
        this.commonAddResource(name, params, defaultResource);
    }

    private void commonAddResource(String name, Object params, boolean defaultResource) throws InitializeException {
        String multiresourceName = null;
        try {
            multiresourceName = this.getName();
        }
        catch (AccessResourceException e1) {
            LOG.warn("Imposible to get MultiResource name");
        }
        Resource res = (Resource)this.resources.get(name);
        if (res != null) {
            return;
        }
        if (this.isFrozen) {
            LOG.warn("Added resource " + name + " to a frozen multiresource " + multiresourceName);
        }
        ResourceProvider resourceProvider = null;
        if (params instanceof ResourceParameters) {
            resourceProvider = ((ResourceManagerProviderServices)DALLocator.getResourceManager()).createAddResource((ResourceParameters)params);
        } else if (params instanceof Object[]) {
            resourceProvider = ((ResourceManagerProviderServices)DALLocator.getResourceManager()).createAddResource(name, (Object[])params);
        } else {
            LOG.warn("Resource could not be created " + name);
        }
        try {
            this.resources.put(resourceProvider.getName(), resourceProvider);
        }
        catch (AccessResourceException e) {
            LOG.warn("Resource not added " + name + " to " + multiresourceName);
        }
        if (defaultResource) {
            this.defaultResourcePos = this.resources.size() - 1;
        }
    }

    public boolean isThis(ResourceParameters parameters) throws ResourceException {
        if (parameters instanceof MultiResourceParameters) {
            MultiResourceParameters multiParams = (MultiResourceParameters)parameters;
            return multiParams.getName() != null && multiParams.getName().equals(this.getMultiResourceParameters().getName());
        }
        return false;
    }

    @Override
    public void notifyChanges() throws ResourceNotifyChangesException {
        List resources = this.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            ((ResourceProvider)this.getResources().get(i)).notifyChanges();
        }
        super.notifyChanges();
    }

    @Override
    public void notifyClose() throws ResourceNotifyCloseException {
        List resources = this.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            ((ResourceProvider)this.getResources().get(i)).notifyClose();
        }
        super.notifyClose();
    }

    @Override
    public void notifyDispose() throws ResourceNotifyDisposeException {
        List resources = this.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            ((ResourceProvider)this.getResources().get(i)).notifyDispose();
        }
        super.notifyDispose();
    }

    @Override
    public void notifyOpen() throws ResourceNotifyOpenException {
        List resources = this.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            ((ResourceProvider)this.getResources().get(i)).notifyOpen();
        }
        super.notifyOpen();
    }

    @Override
    public void prepare() throws PrepareResourceException {
        List resources = this.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            ((ResourceProvider)this.getResources().get(i)).prepare();
        }
        super.prepare();
    }

    @Override
    public void closeRequest() throws ResourceException {
        List resources = this.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            ((ResourceProvider)this.getResources().get(i)).closeRequest();
        }
        super.closeRequest();
    }

    @Override
    public Object get() throws AccessResourceException {
        ResourceProvider defaultResource = this.getDefaultResource();
        if (defaultResource == null) {
            return null;
        }
        return defaultResource.get();
    }

    @Override
    public Object getData() {
        ResourceProvider defaultResource = this.getDefaultResource();
        if (defaultResource == null) {
            return null;
        }
        return defaultResource.getData();
    }

    private MultiResourceParameters getMultiResourceParameters() {
        return (MultiResourceParameters)this.getParameters();
    }

    @Override
    public String getName() throws AccessResourceException {
        String name = "MultiResource " + this.getMultiResourceParameters().getName();
        return name;
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (AccessResourceException e) {
            LOG.error("Error getting the resource name", (Throwable)e);
            return super.toString();
        }
    }

    private ResourceProvider getDefaultResource() {
        if (this.getResources().size() > 0) {
            return (ResourceProvider)this.getResources().get(this.defaultResourcePos);
        }
        return null;
    }

    @Override
    public void setData(Object data) {
        ResourceProvider defaultResource = this.getDefaultResource();
        if (defaultResource != null) {
            defaultResource.setData(data);
        }
    }

    public void frozen() {
        this.isFrozen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ResourceAction action) throws ResourceExecuteException {
        Object value = null;
        Object object = this.lock;
        synchronized (object) {
            for (AbstractResource resource : this.resources.values()) {
                resource.multiResourcelock = this.lock;
            }
            this.executeBegins();
            try {
                value = this.performExecution(action);
            }
            catch (Exception e) {
                throw new ResourceExecuteException((Resource)this, (Throwable)e);
            }
            finally {
                this.executeEnds();
            }
        }
        return value;
    }

    public void addMultiResourceConsumer(ResourceConsumer consumer) {
        super.addConsumer(consumer);
        for (AbstractResource resource : this.resources.values()) {
            resource.addConsumer(consumer);
        }
    }
}

