/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.api.TopologyServices;
import org.gvsig.topology.lib.impl.DefaultTopologyDataSet;
import org.gvsig.topology.lib.impl.DefaultTopologyReport;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopologyPlan
implements TopologyPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTopologyPlan.class);
    private final TopologyManager manager;
    private final Map<String, TopologyDataSet> dataSets;
    private final List<TopologyRule> rules;
    private String name;
    private DefaultTopologyReport report;
    private TopologyServices services;
    private double tolerance;
    private SimpleTaskStatus taskStatus;
    private boolean useUI;
    private boolean acceptExceptions;

    public DefaultTopologyPlan(TopologyManager manager, TopologyServices services) {
        this.manager = manager;
        this.services = services;
        this.dataSets = new HashMap<String, TopologyDataSet>();
        this.rules = new ArrayList<TopologyRule>();
        this.report = null;
        this.name = "TopologyPlan-" + String.format("%08X", new Date().getTime());
        this.tolerance = 0.0;
        this.useUI = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.name = "";
        this.tolerance = 0.0;
        this.services = null;
        this.report = null;
        this.dataSets.clear();
        this.rules.clear();
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public void setTopologyServices(TopologyServices services) {
        this.services = services;
        for (TopologyDataSet dataSet : this.dataSets.values()) {
            if (!(dataSet instanceof DefaultTopologyDataSet)) continue;
            ((DefaultTopologyDataSet)dataSet).setTopologyServices(services);
        }
    }

    public TopologyServices getTopologyServices() {
        return this.services;
    }

    public SimpleTaskStatus getTaskStatus() {
        if (this.taskStatus == null) {
            this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(this.getName());
        }
        return this.taskStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        SimpleTaskStatus theTaskStatus = this.getTaskStatus();
        try {
            theTaskStatus.restart();
            theTaskStatus.message("Preparing the execution of the plan");
            theTaskStatus.setAutoremove(true);
            theTaskStatus.setIndeterminate();
            for (TopologyDataSet dataSet : this.dataSets.values()) {
                dataSet.restart();
            }
            this.getReport().removeAllLines();
            long steps = 0L;
            for (TopologyRule rule : this.rules) {
                steps += rule.getSteps();
                ++steps;
            }
            theTaskStatus.setRangeOfValues(0L, steps);
            theTaskStatus.setCurValue(0L);
            for (TopologyRule rule : this.rules) {
                if (theTaskStatus.isCancellationRequested()) {
                    theTaskStatus.cancel();
                    break;
                }
                theTaskStatus.message(rule.getName());
                rule.execute(theTaskStatus, (TopologyReport)this.getReport());
                theTaskStatus.incrementCurrentValue();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Problems executing topology plan '" + this.getName() + "'.", (Throwable)ex);
            theTaskStatus.abort();
        }
        finally {
            if (theTaskStatus.isRunning()) {
                theTaskStatus.terminate();
            }
            this.getReport().setCompleted(true);
        }
    }

    public TopologyDataSet addDataSet(String name, DataStore store) {
        TopologyDataSet dataSet = this.manager.createDataSet(name, store);
        return this.addDataSet(dataSet);
    }

    public TopologyDataSet addDataSet(TopologyDataSet dataSet) {
        if (this.dataSets.containsKey(dataSet.getName())) {
            throw new IllegalArgumentException("Already exists a dataSet with this name (" + dataSet.getName() + ").");
        }
        this.dataSets.put(dataSet.getName(), dataSet);
        return dataSet;
    }

    public TopologyDataSet getDataSet(String name) {
        return this.dataSets.get(name);
    }

    public boolean containsDataSet(String name) {
        return this.dataSets.containsKey(name);
    }

    public Collection<TopologyDataSet> getDataSets() {
        Collection<TopologyDataSet> x = this.dataSets.values();
        return Collections.unmodifiableCollection(x);
    }

    public Collection<TopologyDataSet> getSecondaryDataSets(TopologyRuleFactory ruleFactory) {
        ArrayList<TopologyDataSet> secondaryDataSets = new ArrayList<TopologyDataSet>();
        for (TopologyDataSet dataSet : this.dataSets.values()) {
            if (!ruleFactory.canApplyToSecondaryDataSet(dataSet)) continue;
            secondaryDataSets.add(dataSet);
        }
        return secondaryDataSets;
    }

    public TopologyRule addRule(String id, String dataSet1, String dataSet2, double tolerance) {
        TopologyRuleFactory factory = this.manager.getRulefactory(id);
        if (factory == null) {
            throw new IllegalArgumentException("Can't locate factory for rule '" + id + "'.");
        }
        if (!this.canApplyRule(factory, dataSet1, dataSet2)) {
            throw new IllegalArgumentException("Can't apply rule '" + factory.getName() + "' to the datasets '" + dataSet1 + "/" + dataSet2 + "'.");
        }
        TopologyRule rule = factory.createRule(dataSet1, dataSet2, tolerance);
        return this.addRule(rule);
    }

    public TopologyRule addRule(TopologyRule rule) {
        if (rule.getPlan() != null && rule.getPlan() != this) {
            rule = (AbstractTopologyRule)Cloneable.cloneQuietly((Cloneable)rule);
        }
        ((AbstractTopologyRule)rule).setPlan((TopologyPlan)this);
        this.rules.add(rule);
        return rule;
    }

    private boolean canApplyRule(TopologyRuleFactory factory, String dataSet1, String dataSet2) {
        try {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            TopologyDataSet dataset = this.getDataSet(dataSet1);
            FeatureStore store = (FeatureStore)dataset.getStore();
            GeometryType gt = store.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType();
            for (Integer geometryType1 : factory.getGeometryTypeDataSet1()) {
                if (!gt.isTypeOf(geometryType1.intValue())) continue;
                if (factory.getGeometryTypeDataSet2() == null) {
                    return true;
                }
                dataset = this.getDataSet(dataSet2);
                store = (FeatureStore)dataset.getStore();
                gt = store.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType();
                for (Integer geometryType2 : factory.getGeometryTypeDataSet2()) {
                    if (!gt.isTypeOf(geometryType2.intValue())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Collection<TopologyRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public boolean hasRules() {
        return !this.rules.isEmpty();
    }

    public DefaultTopologyReport getReport() {
        if (this.report == null) {
            this.report = new DefaultTopologyReport(this);
        }
        return this.report;
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder me = Json.createObjectBuilder();
        me.add_class((Object)this);
        me.add("name", this.name);
        me.add("tolerance", this.tolerance);
        me.add("acceptExceptions", this.acceptExceptions);
        org.gvsig.json.JsonArrayBuilder jsonDataSets = Json.createArrayBuilder();
        for (TopologyDataSet dataSet : this.dataSets.values()) {
            jsonDataSets.add((SupportToJson)((DefaultTopologyDataSet)dataSet));
        }
        me.add("dataSets", (JsonArrayBuilder)jsonDataSets);
        org.gvsig.json.JsonArrayBuilder jsonRules = Json.createArrayBuilder();
        for (TopologyRule rule : this.rules) {
            jsonRules.add((SupportToJson)rule);
        }
        me.add("rules", (JsonArrayBuilder)jsonRules);
        return me;
    }

    public void fromJson(JsonObject jsonPlan) {
        this.name = jsonPlan.getString("name");
        this.tolerance = jsonPlan.getJsonNumber("tolerance").doubleValue();
        this.acceptExceptions = jsonPlan.getBoolean("acceptExceptions");
        JsonArray jsonDataSets = jsonPlan.getJsonArray("dataSets");
        for (JsonValue o : jsonDataSets) {
            DefaultTopologyDataSet dataSet = new DefaultTopologyDataSet();
            dataSet.fromJson((JsonObject)o);
            this.dataSets.put(dataSet.getName(), dataSet);
        }
        JsonArray jsonRules = jsonPlan.getJsonArray("rules");
        for (JsonValue o : jsonRules) {
            TopologyRule rule = (TopologyRule)Json.toObject((JsonValue)o);
            this.addRule(rule);
        }
    }

    public void removeDataSet(TopologyDataSet dataSet) {
        this.dataSets.remove(dataSet.getName());
    }

    public void removeRule(TopologyRule rule) {
        this.rules.remove(rule);
    }

    public boolean canUseUI() {
        return this.useUI;
    }

    public void setUseUI(boolean useUI) {
        this.useUI = useUI;
    }

    public int getLastStatus() {
        if (this.report != null) {
            return this.report.getStatus();
        }
        return -1;
    }

    public boolean getAcceptExceptions() {
        return this.acceptExceptions;
    }

    public void setAcceptExceptions(boolean acceptExceptions) {
        this.acceptExceptions = acceptExceptions;
    }
}

