/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;

public class PolygonContainsOnePointRule
extends AbstractTopologyRule {
    private String geomName;
    private Expression expression = null;
    private GeometryExpressionBuilder expressionBuilder = null;

    public PolygonContainsOnePointRule() {
    }

    public PolygonContainsOnePointRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        super(factory, tolerance, dataSet1, dataSet2);
    }

    public long getSteps() {
        return this.getDataSet1().getSize() + this.getDataSet2().getSize();
    }

    public void execute(SimpleTaskStatus taskStatus, TopologyReport report) {
        try {
            this.getDataSet1().accept(o1 -> {
                if (taskStatus.isCancellationRequested()) {
                    throw new VisitCanceledException();
                }
                taskStatus.incrementCurrentValue();
                try {
                    this.check(taskStatus, report, (Feature)o1);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            this.getDataSet2().accept(o1 -> {
                if (taskStatus.isCancellationRequested()) {
                    throw new VisitCanceledException();
                }
                taskStatus.incrementCurrentValue();
                try {
                    this.check2(taskStatus, report, (Feature)o1);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (VisitCanceledException visitCanceledException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature1) throws Exception {
        Object set = null;
        try {
            I18nManager i18n;
            FeatureStore store2 = this.getDataSet2().getFeatureStore();
            if (this.expression == null) {
                this.expression = ExpressionUtils.createExpression();
                this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                this.geomName = store2.getDefaultFeatureType().getDefaultGeometryAttributeName();
            }
            Geometry polygon = feature1.getDefaultGeometry();
            double theTolerance = this.getTolerance();
            if (theTolerance > 0.0) {
                polygon = polygon.buffer(theTolerance);
            }
            TopologyDataSet theDataSet = this.getDataSet2();
            int contained = 0;
            if (theDataSet.getSpatialIndex() != null) {
                for (FeatureReference featureReference : theDataSet.query(polygon)) {
                    Feature feature2 = featureReference.getFeature();
                    Geometry otherPoint = feature2.getDefaultGeometry();
                    if (otherPoint == null || !polygon.contains(otherPoint)) continue;
                    ++contained;
                    break;
                }
            } else {
                this.expression.setPhrase(this.expressionBuilder.ifnull((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)this.expressionBuilder.ST_Contains((ExpressionBuilder.Value)this.expressionBuilder.geometry(polygon), (ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName))).toString());
                FeatureSet featSet = theDataSet.getFeatureStore().getFeatureSet(this.expression);
                contained = featSet.size();
            }
            if (contained <= 0) {
                i18n = ToolsLocator.getI18nManager();
                report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_The_polygon_does_not_contain_any_points"));
            } else if (contained > 1) {
                i18n = ToolsLocator.getI18nManager();
                report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_The_polygon_contains_more_than_a_point"));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check feature.", (Throwable)ex);
            this.addCodeException(report, feature1, ex);
        }
        finally {
            if (set != null) {
                set.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check2(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature2) throws Exception {
        Object set = null;
        try {
            TopologyDataSet theDataSet2 = this.getDataSet2();
            TopologyDataSet theDataSet1 = this.getDataSet1();
            FeatureStore otherStore = theDataSet1.getFeatureStore();
            if (this.expression == null) {
                this.expression = ExpressionUtils.createExpression();
                this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                this.geomName = otherStore.getDefaultFeatureType().getDefaultGeometryAttributeName();
            }
            Geometry point = feature2.getDefaultGeometry();
            if (theDataSet1.getSpatialIndex() != null) {
                boolean contained = false;
                for (FeatureReference otherFeatureReference : theDataSet1.query(point)) {
                    Feature otherFeature = otherFeatureReference.getFeature();
                    Geometry otherPolygon = otherFeature.getDefaultGeometry();
                    if (otherPolygon == null || !otherPolygon.contains(point)) continue;
                    contained = true;
                    break;
                }
                if (!contained) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, theDataSet1, theDataSet2, point, point, null, feature2.getReference(), false, i18n.getTranslation("_Point_is_not_contained_in_a_polygon"));
                }
            } else {
                this.expression.setPhrase(this.expressionBuilder.ifnull((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)this.expressionBuilder.ST_Contains((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.geometry(point))).toString());
                if (theDataSet1.findFirst(this.expression) == null) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, theDataSet1, theDataSet2, point, point, null, feature2.getReference(), false, i18n.getTranslation("_Point_is_not_contained_in_a_polygon"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check feature.", (Throwable)ex);
            this.addCodeException(report, feature2, ex);
        }
        finally {
            if (set != null) {
                set.dispose();
            }
        }
    }
}

