/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormObject;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFAFormStream
extends FormStream {
    public static final boolean useNewXFACode = false;
    public static final boolean debugNewXFA = false;
    public static final boolean showOnlyNewXFACode = false;
    private static boolean showBug = false;
    private static final boolean debugXFAstream = false;
    private static final boolean showXFAdata = false;
    private boolean calledOnce = false;
    private Node config;
    private Node dataset;
    private Node template;
    private XFAFormObject formObject;
    private LinkedList xfaFormList;
    private String pagenum;
    private int contentX;
    private int contentH;
    private Map valueMap = new HashMap();

    public XFAFormStream(PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.readXFA(pdfObject);
    }

    private Node toDocument(int n, byte[] byArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            document = null;
        }
        return document;
    }

    private void readXFA(PdfObject pdfObject) {
        PdfObject pdfObject2 = null;
        PdfArrayIterator pdfArrayIterator = null;
        pdfObject2 = pdfObject.getDictionary(2627089);
        if (pdfObject2 == null && (pdfArrayIterator = pdfObject.getMixedArray(2627089)) != null && pdfArrayIterator.getTokenCount() == 0) {
            pdfArrayIterator = null;
        }
        if (pdfObject2 != null) {
            byte[] byArray = pdfObject2.getDecodedStream();
            this.template = XFAFormStream.xmlToNode(1013350773, byArray);
        } else {
            StreamObject streamObject = null;
            int n = 0;
            while (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                n = pdfArrayIterator.getNextValueAsConstant(true);
                streamObject = new StreamObject(pdfArrayIterator.getNextValueAsString(true));
                this.currentPdfFile.readObject(streamObject);
                byte[] byArray = streamObject.getDecodedStream();
                switch (n) {
                    case 1043741046: {
                        this.config = this.toDocument(1043741046, byArray);
                        break;
                    }
                    case 1130793076: {
                        this.dataset = this.toDocument(1130793076, byArray);
                        break;
                    }
                    case 1013350773: {
                        this.template = this.toDocument(1013350773, byArray);
                        break;
                    }
                    case 1031041382: {
                        break;
                    }
                    case 1951819392: {
                        break;
                    }
                    case 1701743524: {
                        break;
                    }
                    case 1026916721: {
                        break;
                    }
                    case 0x363436: {
                        break;
                    }
                    case 2088075366: {
                        break;
                    }
                }
            }
        }
    }

    private static Node xmlToNode(int n, byte[] byArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            document = null;
        }
        switch (n) {
            case 1043741046: {
                NodeList nodeList = document.getElementsByTagName("config");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = element.getAttribute("xmlns");
                    if (string.length() <= 0) continue;
                    return element;
                }
                break;
            }
            case 1130793076: {
                NodeList nodeList = document.getElementsByTagName("xfa:datasets");
                Element element = (Element)nodeList.item(0);
                return element;
            }
            case 1013350773: {
                NodeList nodeList = document.getElementsByTagName("template");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = element.getAttribute("xmlns:xfa");
                    if (string.length() <= 0) continue;
                    return element;
                }
                break;
            }
        }
        return null;
    }

    public boolean hasXFADataSet() {
        return this.dataset != null;
    }

    public FormObject[] createAppearanceString(FormObject[] formObjectArray) {
        if (this.calledOnce) {
            return null;
        }
        this.calledOnce = true;
        return this.oldXFA(formObjectArray);
    }

    private FormObject[] oldXFA(FormObject[] formObjectArray) {
        int n;
        this.xfaFormList = new LinkedList();
        this.parseStream();
        int n2 = this.xfaFormList.size();
        int n3 = formObjectArray.length < n2 ? formObjectArray.length : n2;
        FormObject[][] formObjectArray2 = new FormObject[n3][2];
        for (n = 0; n < n3; ++n) {
            String string;
            int n4;
            String string2;
            formObjectArray2[n][0] = formObjectArray[n];
            if (formObjectArray[n] != null) {
                string2 = formObjectArray[n].getTextStreamValue(36);
                if (string2 != null) {
                    n4 = string2.lastIndexOf("[0]");
                    int n5 = string2.lastIndexOf(46, n4 - 1);
                    if (n5 != -1) {
                        string2 = n4 != -1 ? string2.substring(n5 + 1, n4) : string2.substring(n5 + 1);
                    } else if (n4 != -1) {
                        string2 = string2.substring(0, n4);
                    }
                }
            } else {
                string2 = null;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                String string3;
                XFAFormObject xFAFormObject = (XFAFormObject)this.xfaFormList.get(n4);
                if (xFAFormObject == null || !(string3 = xFAFormObject.getTextStreamValue(36)).equals(string2)) continue;
                formObjectArray2[n][1] = xFAFormObject;
                break;
            }
            if (string2 == null || (string = (String)this.valueMap.get(string2.toLowerCase())) == null) continue;
            formObjectArray2[n][0].setTextValue(string);
        }
        formObjectArray = new FormObject[n3];
        for (n = 0; n < n3; ++n) {
            if (formObjectArray2[n][1] != null) {
                formObjectArray2[n][1].overwriteWith(formObjectArray2[n][0]);
                formObjectArray[n] = formObjectArray2[n][1];
                if (showBug) {
                    System.out.println("wrong " + n);
                }
            } else {
                formObjectArray[n] = formObjectArray2[n][0];
                if (showBug) {
                    System.out.println("correct " + n);
                }
            }
            if (!showBug) continue;
            System.out.println(n + " " + formObjectArray[n].getTextString());
        }
        return formObjectArray;
    }

    protected void parseStream() {
        ArrayList arrayList = new ArrayList();
        this.parseNode(this.template, arrayList);
        this.setupTemplate(arrayList.iterator());
        ArrayList arrayList2 = new ArrayList();
        this.parseNode(this.dataset, arrayList2);
        this.setupDataSet(arrayList2.iterator());
    }

    private void setupDataSet(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string = node.getNodeName();
            if (!string.equals("xfa:data")) continue;
            this.data(node, iterator);
        }
    }

    private void data(Node node, Iterator iterator) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            NodeList nodeList2 = node2.getChildNodes();
            if (nodeList2.getLength() <= 0) continue;
            Node node3 = nodeList2.item(0);
            nodeList2 = node3.getChildNodes();
            String string = node3.getNodeName();
            if (nodeList2.getLength() <= 0) continue;
            Node node4 = nodeList2.item(0);
            this.valueMap.put(string.toLowerCase(), node4.getNodeValue());
        }
    }

    private void nextFormObject() {
        if (this.formObject != null) {
            this.xfaFormList.add(this.formObject);
        }
        this.formObject = new XFAFormObject();
    }

    private void parseNode(Node node, ArrayList arrayList) {
        arrayList.add(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.parseNode(nodeList.item(i), arrayList);
        }
    }

    private void setupTemplate(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node;
            NamedNodeMap namedNodeMap;
            Node node2 = (Node)iterator.next();
            String string = node2.getNodeName();
            if (string.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string.equals("pageArea")) {
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                this.pagenum = node.getNodeValue();
                this.pagenum = this.pagenum.substring(this.pagenum.indexOf("Page") + 4);
                continue;
            }
            if (string.equals("contentArea")) {
                namedNodeMap = node2.getAttributes();
                if (namedNodeMap == null) continue;
                node = namedNodeMap.getNamedItem("x");
                if (node != null) {
                    this.contentX = this.resolveMeasurementToPoints(node.getNodeValue());
                }
                if ((node = namedNodeMap.getNamedItem("h")) == null) continue;
                this.contentH = this.resolveMeasurementToPoints(node.getNodeValue());
                continue;
            }
            if (!string.equals("#document") && !string.equals("templateDesigner")) continue;
        }
        this.nextFormObject();
    }

    private int resolveMeasurementToPoints(String string) {
        int n = 0;
        if (string.endsWith("pt")) {
            n = new Double(string.substring(0, string.indexOf("pt"))).intValue();
        } else if (string.endsWith("in")) {
            n = (int)(72.0 * Double.parseDouble(string.substring(0, string.indexOf("in"))));
        } else if (string.endsWith("cm")) {
            n = (int)(28.35 * Double.parseDouble(string.substring(0, string.indexOf("cm"))));
        } else if (string.endsWith("mm")) {
            n = (int)(2.835 * Double.parseDouble(string.substring(0, string.indexOf("mm"))));
        } else {
            LogWriter.writeFormLog("UNIMPLEMENTED type of y size=" + string, false);
        }
        return n;
    }

    private void field(Node node, Iterator iterator) {
        Node node2;
        this.nextFormObject();
        this.formObject.setPageNumber(this.pagenum);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            node2 = namedNodeMap.getNamedItem("x");
            if (node2 != null) {
                this.formObject.setX(this.contentX + this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
                this.formObject.setY(this.contentH - this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("w")) != null) {
                this.formObject.setWidth(this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("h")) != null) {
                this.formObject.setHeight(this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("name")) != null) {
                this.formObject.setTextStreamValue(36, node2.getNodeValue());
            } else {
                this.formObject.setTextStreamValue(36, "");
            }
        }
        node2 = null;
        while (iterator.hasNext() && !(node2 = (Node)iterator.next()).getNodeName().equals("ui")) {
            node2 = null;
        }
        if (node2 == null) {
            System.out.println("ERROR ERROR  ERROR no ui in field=" + ConvertToString.convertDocumentToString(node));
        } else {
            Node node3 = null;
            String string = null;
            while (iterator.hasNext()) {
                node3 = (Node)iterator.next();
                string = node3.getNodeName();
                if (string.equals("checkButton")) {
                    this.checkButton(node3, iterator);
                    continue;
                }
                if (string.equals("button")) {
                    this.button(node3, iterator);
                    continue;
                }
                if (string.equals("choiceList")) {
                    this.choiceList(node3, iterator);
                    continue;
                }
                if (string.equals("textEdit")) {
                    this.textEdit(node3, iterator);
                    continue;
                }
                LogWriter.writeFormLog("node not implemented nodename=" + string, false);
            }
        }
    }

    private void textEdit(Node node, Iterator iterator) {
        this.formObject.setType(9288, true);
        this.formObject.setFlag(12, true);
        this.formObject.setFlag(13, false);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("margin") || string3.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in textEdit name=" + string3, false);
        }
    }

    private void choiceList(Node node, Iterator iterator) {
        Node node2;
        this.formObject.setType(4920, true);
        this.formObject.setFlag(17, false);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("open")) != null) {
            this.formObject.setChoiceOpening(node2.getNodeValue());
        }
        while (iterator.hasNext()) {
            Object object;
            node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption") || string3.equals("items")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setTextValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("margin") || string3.equals("draw") || string3.equals("rectangle")) continue;
            LogWriter.writeFormLog("node name not implemented in choiceList name=" + string3, false);
        }
    }

    private void button(Node node, Iterator iterator) {
        this.formObject.setType(1197118, true);
        this.formObject.setFlag(16, true);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Node node2;
            Object object;
            Node node3 = (Node)iterator.next();
            String string3 = node3.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node3, iterator);
                continue;
            }
            if (string3.equals("edge")) {
                object = node3.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("caption") || string3.equals("value")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setNormalCaption(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node3.getAttributes();
                node2 = object.getNamedItem("hAlign");
                if (node2 != null) {
                    this.formObject.setHorizontalAlign(node2.getNodeValue());
                }
                if ((node2 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node2.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node3.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("border") || string3.equals("fill")) continue;
            if (string3.equals("color")) {
                object = node3.getAttributes().getNamedItem("value");
                if (object == null) continue;
                this.formObject.setBackgroundColor(object.getNodeValue());
                continue;
            }
            if (string3.equals("bind")) continue;
            if (string3.equals("event")) {
                object = node3.getAttributes().getNamedItem("activity");
                this.formObject.setEventAction(object.getNodeValue());
                continue;
            }
            if (string3.equals("script")) {
                object = node3.getAttributes();
                if (object != null && (node2 = object.getNamedItem("contentType")) != null) {
                    this.formObject.setScriptType(node2.getNodeValue());
                }
                if (!iterator.hasNext() || (node2 = (Node)iterator.next()) == null) continue;
                this.formObject.setScript(node2.getNodeValue());
                continue;
            }
            if (string3.equals("submit")) {
                Node node4;
                Node node5;
                object = node3.getAttributes();
                node2 = object.getNamedItem("format");
                if (node2 != null) {
                    this.formObject.setSubmitFormat(node2.getNodeValue());
                }
                if ((node5 = object.getNamedItem("target")) != null) {
                    this.formObject.setSubmitURL(node5.getNodeValue());
                }
                if ((node4 = object.getNamedItem("textEncoding")) == null) continue;
                this.formObject.setSubmitTextEncoding(node4.getNodeValue());
                continue;
            }
            LogWriter.writeFormLog("node name not implemented in button name=" + string3, false);
        }
    }

    private void checkButton(Node node, Iterator iterator) {
        this.formObject.setType(4920, true);
        this.formObject.setFlag(17, true);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setTextValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("integer")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setIntegerValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("fill") || string3.equals("margin") || string3.equals("event") || string3.equals("items") || string3.equals("exclGroup") || string3.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in checkbutton name=" + string3, false);
        }
    }

    public Map getRefToFormArray() {
        return null;
    }
}

