/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.Serializable;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfPageData
implements Serializable {
    private boolean valuesSet = false;
    private boolean useCustomRounding = true;
    private int lastPage = -1;
    private int raw_rotation = 0;
    private int pagesRead = -1;
    private int pageCount = 1;
    private float[] defaultMediaBox = null;
    private int rotation = 0;
    private Vector_Object mediaBoxes = new Vector_Object(500);
    private Vector_Object cropBoxes = new Vector_Object(500);
    private Vector_Int rotations = null;
    private float cropBoxX = -99999.0f;
    private float cropBoxY = -1.0f;
    private float cropBoxW = -1.0f;
    private float cropBoxH = -1.0f;
    private float mediaBoxX = -1.0f;
    private float mediaBoxY;
    private float mediaBoxW;
    private float mediaBoxH;
    private boolean hasMultipleSizes = false;
    private boolean hasMultipleSizesSet = false;
    private float scalingValue = 1.0f;
    private float[] mediaBox;
    private float[] cropBox;
    private int defaultrotation;
    private float defaultcropBoxX;
    private float defaultcropBoxY;
    private float defaultcropBoxW;
    private float defaultcropBoxH;
    private float defaultmediaBoxX;
    private float defaultmediaBoxY;
    private float defaultmediaBoxW;
    private float defaultmediaBoxH;

    public void checkSizeSet(int n) {
        if (this.mediaBox == null) {
            this.mediaBox = this.defaultMediaBox;
        }
        if (this.cropBox != null && (this.cropBox[0] != this.mediaBox[0] || this.cropBox[1] != this.mediaBox[1] || this.cropBox[2] != this.mediaBox[2] || this.cropBox[3] != this.mediaBox[3])) {
            this.mediaBoxes.setElementAt(this.mediaBox, n);
            this.cropBoxes.setElementAt(this.cropBox, n);
        } else if (this.mediaBox != null && (this.defaultMediaBox[0] != this.mediaBox[0] || this.defaultMediaBox[1] != this.mediaBox[1] || this.defaultMediaBox[2] != this.mediaBox[2] || this.defaultMediaBox[3] != this.mediaBox[3])) {
            this.mediaBoxes.setElementAt(this.mediaBox, n);
        }
        if (this.pagesRead < n) {
            this.pagesRead = n;
        }
        this.lastPage = -1;
        this.mediaBox = null;
        this.cropBox = null;
    }

    public final int getMediaBoxHeight(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxH;
    }

    public final int getMediaBoxY(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxY;
    }

    public final int getMediaBoxX(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxX;
    }

    public void setMediaBox(float[] fArray) {
        this.mediaBox = fArray;
        this.cropBox = null;
        if (this.defaultMediaBox == null) {
            this.defaultMediaBox = fArray;
        }
    }

    public void setCropBox(float[] fArray) {
        this.cropBox = fArray;
    }

    public int setPageRotation(int n, int n2) {
        this.raw_rotation = n;
        if (this.raw_rotation < 0) {
            this.raw_rotation = 360 + this.raw_rotation;
        }
        if (this.raw_rotation != 0 || this.rotations != null) {
            if (this.rotations == null) {
                this.rotations = n2 < 2000 ? new Vector_Int(2000) : new Vector_Int(n2 * 2);
            }
            this.rotations.setElementAt(this.raw_rotation, n2);
        }
        return this.raw_rotation;
    }

    public final int getMediaBoxWidth(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxW;
    }

    public String getMediaValue(int n) {
        float[] fArray = null;
        fArray = this.mediaBoxes == null ? (float[])this.mediaBoxes.elementAt(n) : this.defaultMediaBox;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(fArray[i]);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getCropValue(int n) {
        float[] fArray = null;
        if (this.cropBoxes != null) {
            fArray = (float[])this.cropBoxes.elementAt(n);
        } else if (fArray != null) {
            fArray = (float[])this.mediaBoxes.elementAt(n);
        }
        if (fArray == null) {
            fArray = this.defaultMediaBox;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(fArray[i]);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public int getScaledCropBoxX(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxX * this.scalingValue);
    }

    public int getScaledCropBoxWidth(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxW * this.scalingValue);
    }

    public int getScaledCropBoxY(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxY * this.scalingValue);
    }

    public int getScaledCropBoxHeight(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxH * this.scalingValue);
    }

    public int getCropBoxX(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxX;
    }

    public int getCropBoxWidth(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxW;
    }

    public int getCropBoxY(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxY;
    }

    public int getCropBoxHeight(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxH;
    }

    private void setSizeForPage(int n) {
        if (n > this.pageCount) {
            this.pageCount = n;
        }
        if (n > this.pagesRead) {
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 0.0f;
            this.mediaBoxH = 0.0f;
            this.cropBoxX = 0.0f;
            this.cropBoxY = 0.0f;
            this.cropBoxW = 0.0f;
            this.cropBoxH = 0.0f;
            this.lastPage = n;
        } else if (n > 0 && this.lastPage != n) {
            this.lastPage = n;
            boolean bl = false;
            float[] fArray = (float[])this.cropBoxes.elementAt(n);
            float[] fArray2 = (float[])this.mediaBoxes.elementAt(n);
            if (fArray2 == null && this.defaultMediaBox != null) {
                fArray2 = this.defaultMediaBox;
                bl = true;
            }
            this.rotation = this.rotations != null ? this.rotations.elementAt(n) : this.defaultrotation;
            if (this.valuesSet && bl) {
                this.cropBoxX = this.defaultcropBoxX;
                this.mediaBoxX = this.defaultmediaBoxX;
                this.cropBoxY = this.defaultcropBoxY;
                this.mediaBoxY = this.defaultmediaBoxY;
                this.cropBoxW = this.defaultcropBoxW;
                this.mediaBoxW = this.defaultmediaBoxW;
                this.cropBoxH = this.defaultcropBoxH;
                this.mediaBoxH = this.defaultmediaBoxH;
            } else {
                this.mediaBoxX = 0.0f;
                this.mediaBoxY = 0.0f;
                this.mediaBoxW = 800.0f;
                this.mediaBoxH = 800.0f;
                if (fArray2 != null) {
                    this.mediaBoxX = fArray2[0];
                    this.mediaBoxY = fArray2[1];
                    this.mediaBoxW = fArray2[2] - this.mediaBoxX;
                    this.mediaBoxH = fArray2[3] - this.mediaBoxY;
                    if (this.mediaBoxY > 0.0f && this.mediaBoxH == -this.mediaBoxY) {
                        this.mediaBoxH = -this.mediaBoxH;
                        this.mediaBoxY = 0.0f;
                    }
                }
                if (fArray != null) {
                    float f;
                    this.cropBoxX = fArray[0];
                    this.cropBoxY = fArray[1];
                    this.cropBoxW = fArray[2];
                    this.cropBoxH = fArray[3];
                    if (this.cropBoxX > this.cropBoxW) {
                        f = this.cropBoxX;
                        this.cropBoxX = this.cropBoxW;
                        this.cropBoxW = f;
                    }
                    if (this.cropBoxY > this.cropBoxH) {
                        f = this.cropBoxY;
                        this.cropBoxY = this.cropBoxH;
                        this.cropBoxH = f;
                    }
                    this.cropBoxW -= this.cropBoxX;
                    this.cropBoxH -= this.cropBoxY;
                    if (this.cropBoxY > 0.0f && this.cropBoxH == -this.cropBoxY) {
                        this.cropBoxH = -this.cropBoxH;
                        this.cropBoxY = 0.0f;
                    }
                } else {
                    this.cropBoxX = this.mediaBoxX;
                    this.cropBoxY = this.mediaBoxY;
                    this.cropBoxW = this.mediaBoxW;
                    this.cropBoxH = this.mediaBoxH;
                }
            }
            if (this.cropBoxH < 0.0f) {
                this.cropBoxY += this.cropBoxH;
                this.cropBoxH = -this.cropBoxH;
            }
            if (this.cropBoxW < 0.0f) {
                this.cropBoxX += this.cropBoxW;
                this.cropBoxW = -this.cropBoxW;
            }
            if (bl && !this.valuesSet) {
                this.defaultrotation = this.rotation;
                this.defaultcropBoxX = this.cropBoxX;
                this.defaultmediaBoxX = this.mediaBoxX;
                this.defaultcropBoxY = this.cropBoxY;
                this.defaultmediaBoxY = this.mediaBoxY;
                this.defaultcropBoxW = this.cropBoxW;
                this.defaultmediaBoxW = this.mediaBoxW;
                this.defaultcropBoxH = this.cropBoxH;
                this.defaultmediaBoxH = this.mediaBoxH;
                this.valuesSet = true;
            }
        }
    }

    public float getScalingValue() {
        return this.scalingValue;
    }

    public void setScalingValue(float f) {
        this.scalingValue = f;
    }

    private int roundFloat(float f) {
        float f2;
        int n = (int)f;
        if (this.useCustomRounding && (double)(f2 = f - (float)n) > 0.3) {
            ++n;
        }
        return n;
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final int getRotation(int n) {
        this.setSizeForPage(n);
        return this.rotation;
    }

    public final int getScaledMediaBoxHeight(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxH * this.scalingValue);
    }

    public final int getScaledMediaBoxWidth(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxW * this.scalingValue);
    }

    public final int getScaledMediaBoxX(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxX * this.scalingValue);
    }

    public final int getScaledMediaBoxY(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxY * this.scalingValue);
    }

    public boolean hasMultipleSizes() {
        if (this.hasMultipleSizesSet) {
            return this.hasMultipleSizes;
        }
        int n = this.pageCount;
        int n2 = this.getCropBoxWidth(1);
        int n3 = this.getCropBoxHeight(1);
        int n4 = this.getRotation(1);
        if (n > 1) {
            for (int i = 2; i < n + 1; ++i) {
                if (n2 == this.getCropBoxWidth(i) && n3 == this.getCropBoxHeight(i) && n4 == this.getRotation(i)) continue;
                i = n;
                this.hasMultipleSizes = true;
            }
        }
        this.hasMultipleSizesSet = true;
        return this.hasMultipleSizes;
    }
}

