/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportService
implements ExportService {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractExportService.class);
    private final ExportParameters parameters;
    private final Set<ExportService.ExportFinishListener> finishListeners;
    private SimpleTaskStatus taskStatus;
    private final ExportServiceFactory factory;

    protected AbstractExportService(ExportServiceFactory factory, ExportParameters parameters) {
        this.factory = factory;
        this.parameters = parameters;
        this.finishListeners = new HashSet<ExportService.ExportFinishListener>();
    }

    @Override
    public ExportParameters getParameters() {
        return this.parameters;
    }

    @Override
    public ExportServiceFactory getFactory() {
        return this.factory;
    }

    @Override
    public void addFinishListener(ExportService.ExportFinishListener listener) {
        this.finishListeners.add(listener);
    }

    protected void fireFinishedListener() {
        for (ExportService.ExportFinishListener listener : this.finishListeners) {
            try {
                listener.finished(this);
            }
            catch (Exception exception) {}
        }
    }

    protected void fireCancelledListeners() {
        for (ExportService.ExportFinishListener listener : this.finishListeners) {
            try {
                listener.cancelled(this);
            }
            catch (Exception exception) {}
        }
    }

    public SimpleTaskStatus getTaskStatus() {
        if (this.taskStatus == null) {
            this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Export");
        }
        return this.taskStatus;
    }

    @Override
    public void setTaskStatus(SimpleTaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public boolean isCancellationRequested() {
        return this.getTaskStatus().isCancellationRequested();
    }

    public void cancelRequest() {
        this.getTaskStatus().cancelRequest();
    }

    @Override
    public List<OpenDataStoreParameters> getTargetOpenStoreParameters() throws ExportException {
        ArrayList<OpenDataStoreParameters> r = new ArrayList<OpenDataStoreParameters>();
        r.add(this.createTargetOpenStoreParameters());
        return r;
    }

    protected abstract DataServerExplorer createServerExplorer() throws ExportException;

    protected abstract NewDataStoreParameters createTargetNewStoreParameters() throws ExportException;

    protected abstract OpenDataStoreParameters createTargetOpenStoreParameters() throws ExportException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void export(FeatureSet featureSet) throws ExportException {
        block15: {
            explorer = this.createServerExplorer();
            newStoreParameters = this.createTargetNewStoreParameters();
            openStoreParameters = this.createTargetOpenStoreParameters();
            providerName = newStoreParameters.getDataStoreName();
            explorerName = explorer.getProviderName();
            it = null;
            target = null;
            targetFeature = null;
            try {
                try {
                    AbstractExportService.LOG.info("Start export " + Objects.toString(openStoreParameters));
                }
                catch (Throwable t) {
                    AbstractExportService.LOG.info("Start export");
                }
                this.getTaskStatus().setRangeOfValues(0L, featureSet.getSize());
                dataManager = DALLocator.getDataManager();
                dataManager.newStore(explorerName, providerName, newStoreParameters, true);
                target = (FeatureStore)dataManager.openStore(providerName, (DataStoreParameters)openStoreParameters);
                theTargetFeatureType = this.getParameters().getExportAttributes().isActive() != false ? this.getParameters().getExportAttributes().getTargetFeatureType() : target.getDefaultFeatureType();
                theSourceFeatureType = featureSet.getDefaultFeatureType();
                geomHelper = null;
                if (this.getParameters() instanceof ExportParametersGeometry && !(geomHelper = ExportLocator.getServiceManager().createGeometryHelper((ExportParametersGeometry)this.getParameters(), theTargetFeatureType, theSourceFeatureType)).canProcessGeometry()) {
                    geomHelper = null;
                }
                target.edit(2);
                it = featureSet.fastIterator();
                AbstractExportService.LOG.info("Created target");
                featureCount = 1L;
                block12: while (it.hasNext()) {
                    this.getTaskStatus().setCurValue(featureCount);
                    sourceFeature = (Feature)it.next();
                    targetFeature = target.createNewFeature(true);
                    this.copyValues(sourceFeature, targetFeature);
                    if (geomHelper != null) {
                        switch (geomHelper.copyGeometry(sourceFeature, targetFeature)) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                continue block12;
                            }
                            case 2: {
                                throw new InvalidGeometryException((Feature)targetFeature, geomHelper.getLastErrorMessage());
                            }
                        }
                    }
                    target.insert(targetFeature);
                    ++featureCount;
                    if (!this.getTaskStatus().isCancellationRequested()) continue;
                    AbstractExportService.LOG.info("Export cancelled by user.");
                    this.getTaskStatus().abort();
                    FeatureStore.cancelEditingQuietly((FeatureStore)target);
                    this.fireCancelledListeners();
                    break block15;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable e) {
                try {
                    AbstractExportService.LOG.warn("Can't export", e);
                    FeatureStore.cancelEditingQuietly(target);
                    this.fireCancelledListeners();
                    throw new ExportException(e, (Feature)targetFeature);
                }
                catch (Throwable var17_18) {
                    DisposeUtils.dispose(it);
                    DisposeUtils.dispose((Disposable)featureSet);
                    DisposeUtils.dispose(target);
                    throw var17_18;
                }
            }
        }
        DisposeUtils.dispose((Disposable)it);
        DisposeUtils.dispose((Disposable)featureSet);
        DisposeUtils.dispose((Disposable)target);
        return;
lbl-1000:
        // 1 sources

        {
            target.finishEditing();
            this.getTaskStatus().terminate();
            this.getTaskStatus().remove();
            this.fireFinishedListener();
            AbstractExportService.LOG.info("End export");
        }
        DisposeUtils.dispose((Disposable)it);
        DisposeUtils.dispose((Disposable)featureSet);
        DisposeUtils.dispose((Disposable)target);
    }

    protected void copyValues(Feature source, EditableFeature target) {
        FeatureType sourceType = source.getType();
        FeatureType targetType = target.getType();
        ExportAttributes exp = this.getParameters().getExportAttributes();
        boolean isActive = exp.isActive();
        for (FeatureAttributeDescriptor targetAttr : targetType) {
            Object value;
            FeatureAttributeDescriptor sourceAttr;
            String sourceAttrName;
            if (!target.canSetValue(targetAttr, null)) continue;
            String targetAttrName = targetAttr.getName();
            if (isActive) {
                sourceAttrName = exp.getSourceName(targetAttrName);
                Iterator iterator = exp.iterator();
                while (iterator.hasNext()) {
                    ExportAttributes.ExportAttribute exportAttribute = (ExportAttributes.ExportAttribute)iterator.next();
                    if (!StringUtils.equals((CharSequence)exportAttribute.getNewName(), (CharSequence)targetAttrName)) continue;
                    sourceAttrName = exportAttribute.getName();
                    break;
                }
                sourceAttr = sourceType.getAttributeDescriptorFromAll(sourceAttrName);
            } else {
                sourceAttrName = targetAttrName;
                sourceAttr = sourceType.getAttributeDescriptorFromAll(targetAttrName);
            }
            if (sourceAttr != null) {
                value = source.get(sourceAttrName);
                if (value == null) {
                    if (!targetAttr.allowNull()) continue;
                    target.set(targetAttrName, null);
                    continue;
                }
                target.set(targetAttrName, value);
                continue;
            }
            if (sourceAttr != null || !source.hasValue(sourceAttrName)) continue;
            value = source.get(sourceAttrName);
            target.set(targetAttrName, value);
        }
    }

    protected static class InvalidGeometryException
    extends ExportException {
        public InvalidGeometryException(Feature feature, String checkMessage) {
            super(checkMessage, feature);
        }
    }
}

