/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import javax.swing.JComponent;
import org.japura.controller.Controller;
import org.japura.controller.ModalAction;
import org.japura.controller.ModalPanelFactory;
import org.japura.controller.modals.ErrorPanel;
import org.japura.controller.modals.InformationPanel;
import org.japura.controller.modals.QuestionPanel;
import org.japura.controller.modals.WarningPanel;
import org.japura.i18n.I18nManager;
import org.japura.i18n.I18nStringKeys;

public class DefaultModalPanelFactory
implements ModalPanelFactory {
    @Override
    public JComponent buildConfirmationPanel(Controller<?> controller, String title, String text, ModalAction confirmAction, ModalAction cancelAction) {
        QuestionPanel modal = new QuestionPanel(title, text, confirmAction, cancelAction);
        String confirm = I18nManager.getString(I18nStringKeys.CONFIRM.getKey());
        modal.setConfirmButtonText(confirm);
        String cancel = I18nManager.getString(I18nStringKeys.CANCEL.getKey());
        modal.setCancelButtonText(cancel);
        return modal;
    }

    @Override
    public JComponent buildErrorPanel(Controller<?> controller, String title, String text) {
        return new ErrorPanel(title, text);
    }

    @Override
    public JComponent buildInformationPanel(Controller<?> controller, String title, String text) {
        return new InformationPanel(title, text);
    }

    @Override
    public JComponent buildQuestionPanel(Controller<?> controller, String title, String text, ModalAction yesAction, ModalAction noAction) {
        QuestionPanel modal = new QuestionPanel(title, text, yesAction, noAction);
        String yes = I18nManager.getString(I18nStringKeys.YES.getKey());
        modal.setConfirmButtonText(yes);
        String no = I18nManager.getString(I18nStringKeys.NO.getKey());
        modal.setCancelButtonText(no);
        return modal;
    }

    @Override
    public JComponent buildWarningPanel(Controller<?> controller, String title, String text) {
        return new WarningPanel(title, text);
    }
}

