/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.japura.debug.DebugParameter;
import org.japura.debug.DebugResult;
import org.japura.debug.DebugWindow;
import org.japura.util.WeakList;

public abstract class DebugComponent
extends JPanel {
    private static WeakList<DebugComponent> components = new WeakList();

    public static synchronized boolean exists(Class<?> clss) {
        for (DebugComponent db : components) {
            if (!db.getClass().equals(clss)) continue;
            return true;
        }
        return false;
    }

    public static synchronized List<DebugResult> publish(Class<?> clss, DebugParameter parameter) {
        ArrayList<DebugResult> results = new ArrayList<DebugResult>();
        for (DebugComponent db : components) {
            DebugResult result;
            if (!db.getClass().equals(clss) || (result = db.update(parameter)) == null) continue;
            results.add(result);
        }
        DebugWindow.updateTabTitles();
        return results;
    }

    public static synchronized void add(DebugComponent component) {
        components.add(component);
    }

    protected abstract DebugResult update(DebugParameter var1);

    protected abstract String getTitle();
}

