/*
 * Decompiled with CFR 0.152.
 */
package org.japura.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import org.japura.dialogs.ContentPanel;
import org.japura.gui.LabelSeparator;

public class MessagePanel
extends ContentPanel {
    private static final long serialVersionUID = 1L;

    public MessagePanel(String msg) {
        this(msg, null, null);
    }

    public MessagePanel(String msg, String detailedTitle, String detailedMsg) {
        InnerPanel panel = new InnerPanel();
        InnerScrollPane sp = new InnerScrollPane(panel);
        sp.getViewport().setOpaque(false);
        sp.setOpaque(false);
        sp.setBorder(BorderFactory.createEmptyBorder());
        this.addContent(sp);
        panel.textArea.setText(msg);
        if (detailedTitle != null && detailedMsg != null) {
            panel.separator.setText(detailedTitle);
            panel.detailedTextArea.setText(detailedMsg);
        } else {
            panel.separator.setVisible(false);
            panel.detailedTextArea.setVisible(false);
        }
    }

    private static class InnerPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;
        private LabelSeparator separator = new LabelSeparator();
        private JTextArea textArea;
        private JTextArea detailedTextArea;

        public InnerPanel() {
            this.setOpaque(false);
            this.textArea = this.buildTextArea();
            this.detailedTextArea = this.buildTextArea();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            this.add((Component)this.textArea, gbc);
            gbc.weighty = 0.0;
            ++gbc.gridy;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add((Component)this.separator, gbc);
            ++gbc.gridy;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.detailedTextArea, gbc);
        }

        private JTextArea buildTextArea() {
            JTextArea textArea = new JTextArea(0, 30);
            textArea.setWrapStyleWord(true);
            textArea.setActionMap(new ActionMap());
            textArea.setEditable(false);
            textArea.setOpaque(false);
            textArea.setLineWrap(true);
            textArea.setMargin(new Insets(5, 5, 5, 5));
            return textArea;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class InnerScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 1L;

        private InnerScrollPane(Component view) {
            super(view);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (!this.isPreferredSizeSet()) {
                dim.height = Math.min(dim.height, 100);
            }
            return dim;
        }
    }
}

