/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.japura.gui.WrapLabel;
import org.japura.i18n.I18nManager;
import org.japura.i18n.I18nStringKeys;

public class ExecutionPanel
extends JPanel {
    private static final long serialVersionUID = 3L;
    private WrapLabel label;
    private JLabel timerLabel;
    private long elapsedStartTime = 0L;
    private DecimalFormat integerTimeFormatter;
    private int width = 300;
    private String text;
    private StringBuilder textTimer;
    private Timer timer;

    public ExecutionPanel(String text) {
        this(text, null);
    }

    public ExecutionPanel(String text, Icon progressBarIcon) {
        if (progressBarIcon == null) {
            URL url = this.getClass().getResource("/images/jpr_progressbar.gif");
            progressBarIcon = new ImageIcon(url);
        }
        this.textTimer = new StringBuilder();
        this.integerTimeFormatter = new DecimalFormat("00");
        if (text == null) {
            text = "";
        }
        this.text = text;
        Border out = BorderFactory.createLineBorder(Color.BLACK, 2);
        Border in = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.setBorder(BorderFactory.createCompoundBorder(out, in));
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)this.getLabel(), gbc);
        gbc.insets = new Insets(20, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)this.getTimeLabel(), gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        JLabel progressBar = new JLabel(progressBarIcon);
        progressBar.setName("progressComponent");
        this.add((Component)progressBar, gbc);
    }

    public void setText(String text) {
        this.getLabel().setText(text);
    }

    private JLabel getTimeLabel() {
        if (this.timerLabel == null) {
            this.timerLabel = new JLabel();
            this.timerLabel.setName("timerLabel");
            this.timerLabel.setText(this.getTimerString(0L));
        }
        return this.timerLabel;
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long seconds = System.currentTimeMillis() - ExecutionPanel.this.elapsedStartTime;
                    ExecutionPanel.this.getTimeLabel().setText(ExecutionPanel.this.getTimerString(seconds));
                }
            });
        }
        return this.timer;
    }

    public void start() {
        this.elapsedStartTime = System.currentTimeMillis();
        this.getTimer().start();
    }

    public void stop() {
        this.getTimer().stop();
    }

    private WrapLabel getLabel() {
        if (this.label == null) {
            this.label = new WrapLabel(this.text);
            this.label.setWrapWidth(this.width);
            this.label.setName("messageLabel");
        }
        return this.label;
    }

    private String getTimerString(long seconds) {
        if (seconds < 0L) {
            return "-";
        }
        seconds /= 1000L;
        this.textTimer.setLength(0);
        this.textTimer.append(I18nManager.getString(I18nStringKeys.TIME_ELAPSED.getKey()));
        this.textTimer.append(" ");
        long sec = seconds;
        long min = 0L;
        long hou = 0L;
        if (sec >= 60L) {
            min = (int)sec / 60;
            sec -= min * 60L;
        }
        if (min >= 60L) {
            hou = (int)min / 60;
            min -= hou * 60L;
        }
        this.textTimer.append(this.integerTimeFormatter.format(hou));
        this.textTimer.append(I18nManager.getString(I18nStringKeys.HOUR_ACRONYM.getKey()));
        this.textTimer.append(" ");
        this.textTimer.append(this.integerTimeFormatter.format(min));
        this.textTimer.append(I18nManager.getString(I18nStringKeys.MINUTE_ACRONYM.getKey()));
        this.textTimer.append(" ");
        this.textTimer.append(this.integerTimeFormatter.format(sec));
        this.textTimer.append(I18nManager.getString(I18nStringKeys.SECOND_ACRONYM.getKey()));
        return this.textTimer.toString();
    }
}

