/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.japura.Application;
import org.japura.task.DefaultTaskSessionFactory;
import org.japura.task.SessionRequired;
import org.japura.task.Task;
import org.japura.task.TaskExeception;
import org.japura.task.TaskManager;
import org.japura.task.TaskManagerEvent;
import org.japura.task.TaskManagerExeception;
import org.japura.task.TaskManagerListener;
import org.japura.task.TaskSequence;
import org.japura.task.TaskSession;
import org.japura.task.TaskSessionFactory;
import org.japura.task.ui.TaskExecutionUI;

public abstract class AbstractTaskManager
implements TaskManager {
    private Map<String, TaskExecutionUI> taskExecutionUIs = new HashMap<String, TaskExecutionUI>();
    private TaskExecutionUI taskExecutionUI;
    private TaskSessionFactory taskSessionFactory = new DefaultTaskSessionFactory();
    private List<TaskManagerListener> listeners = new ArrayList<TaskManagerListener>();

    protected TaskExecutionUI getTaskExecutionUI(Task<?> task, TaskManagerEvent event) {
        TaskExecutionUI taskExecutionUI = null;
        try {
            if (TaskManagerEvent.SUBMITTED.equals((Object)event)) {
                taskExecutionUI = task.getTaskExecutionUI();
                if (taskExecutionUI != null) {
                    this.taskExecutionUIs.put(task.getId(), taskExecutionUI);
                }
            } else if (TaskManagerEvent.BEFORE_EXECUTE.equals((Object)event)) {
                taskExecutionUI = this.taskExecutionUIs.get(task.getId());
            } else if (TaskManagerEvent.AFTER_EXECUTE.equals((Object)event)) {
                taskExecutionUI = this.taskExecutionUIs.remove(task.getId());
            }
        }
        catch (Exception e) {
            Application.getHandlerExceptionManager().handle(new TaskManagerExeception(e));
        }
        if (taskExecutionUI == null) {
            taskExecutionUI = this.getTaskExecutionUI();
        }
        return taskExecutionUI;
    }

    @Override
    public TaskExecutionUI getTaskExecutionUI() {
        return this.taskExecutionUI;
    }

    @Override
    public void setTaskExecutionUI(TaskExecutionUI taskExecutionUI) {
        this.taskExecutionUI = taskExecutionUI;
    }

    @Override
    public synchronized void addListener(TaskManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(TaskManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized List<TaskManagerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void setTaskSessionFactory(TaskSessionFactory taskSessionFactory) {
        if (taskSessionFactory == null) {
            taskSessionFactory = new DefaultTaskSessionFactory();
        }
        this.taskSessionFactory = taskSessionFactory;
    }

    @Override
    public TaskSessionFactory getTaskSessionFactory() {
        return this.taskSessionFactory;
    }

    protected void checkSession(Task<?> task, TaskSession session) {
        if (session == null) {
            throw new TaskExeception("NULL TaskSession");
        }
        SessionRequired sr = task.getClass().getAnnotation(SessionRequired.class);
        if (sr != null && !session.getClass().equals(sr.sessionClass())) {
            throw new TaskExeception("Task '" + task.getClass().getName() + "' requires the session class '" + sr.sessionClass() + "' but is using '" + session.getClass() + "'");
        }
    }

    @Override
    public void submit(TaskSequence taskSequence) {
        this.submit(taskSequence.getFirstTask(), null, false);
    }

    @Override
    public void submit(TaskSequence taskSequence, TaskSession session) {
        this.submit(taskSequence.getFirstTask(), session, false);
    }

    @Override
    public void submit(Task<?> task) {
        this.submit(task, null, false);
    }

    @Override
    public void submit(Task<?> task, TaskSession session) {
        this.submit(task, session, false);
    }

    @Override
    public void submit(Task<?> task, boolean isParallel) {
        this.submit(task, null, isParallel);
    }

    @Override
    public void fireTaskManagerListeners(TaskManagerEvent event, Task<?> task) {
        if (event == null) {
            return;
        }
        try {
            for (TaskManagerListener listener : this.listeners) {
                if (TaskManagerEvent.BEFORE_EXECUTE.equals((Object)event)) {
                    listener.beforeExecute(task);
                    continue;
                }
                if (TaskManagerEvent.AFTER_EXECUTE.equals((Object)event)) {
                    listener.afterExecute(task);
                    continue;
                }
                if (!TaskManagerEvent.SUBMITTED.equals((Object)event)) continue;
                listener.submitted(task);
            }
        }
        catch (Exception e) {
            Application.getHandlerExceptionManager().handle(new TaskManagerExeception(e));
        }
    }

    @Override
    public void fireTaskExecutionUIs(TaskManagerEvent event, Task<?> task) {
        if (event == null) {
            return;
        }
        TaskExecutionUI taskExecutionUI = this.getTaskExecutionUI(task, event);
        if (taskExecutionUI != null) {
            try {
                if (TaskManagerEvent.BEFORE_EXECUTE.equals((Object)event)) {
                    taskExecutionUI.beforeExecute(task);
                } else if (TaskManagerEvent.AFTER_EXECUTE.equals((Object)event)) {
                    taskExecutionUI.afterExecute(task);
                } else if (TaskManagerEvent.SUBMITTED.equals((Object)event)) {
                    taskExecutionUI.submitted(task);
                }
            }
            catch (Exception e) {
                Application.getHandlerExceptionManager().handle(new TaskManagerExeception(e));
            }
        }
    }
}

