/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.px;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class Extent {
    Point2D min = null;
    Point2D max = null;

    public Extent() {
        this.min = new Point2D.Double(9.99999999E8, 9.99999999E8);
        this.max = new Point2D.Double(-9.99999999E8, -9.99999999E8);
    }

    public Extent(Point2D pt1, Point2D pt2) {
        this.newExtent(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public Extent(double x1, double y1, double x2, double y2) {
        this.newExtent(x1, y1, x2, y2);
    }

    public Extent(Rectangle2D r) {
        this.newExtent(r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight());
    }

    public Extent(Extent ext) {
        this.newExtent(ext.minX(), ext.minY(), ext.maxX(), ext.maxY());
    }

    public Object clone() {
        Extent e = (Extent)this.clone();
        e.min = (Point2D)this.min.clone();
        e.max = (Point2D)this.max.clone();
        return e;
    }

    private void newExtent(double x1, double y1, double x2, double y2) {
        this.min = new Point2D.Double(Math.min(x1, x2), Math.min(y1, y2));
        this.max = new Point2D.Double(Math.max(x1, x2), Math.max(y1, y2));
    }

    public double minX() {
        return this.min.getX();
    }

    public double minY() {
        return this.min.getY();
    }

    public double maxX() {
        return this.max.getX();
    }

    public double maxY() {
        return this.max.getY();
    }

    public Point2D getMin() {
        return this.min;
    }

    public Point2D getMax() {
        return this.max;
    }

    public boolean isAt(Point2D pt) {
        if (pt.getX() < this.minX()) {
            return false;
        }
        if (pt.getX() > this.maxX()) {
            return false;
        }
        if (pt.getY() < this.minY()) {
            return false;
        }
        return !(pt.getY() > this.maxY());
    }

    public double width() {
        return Math.abs(this.maxX() - this.minX());
    }

    public double height() {
        return Math.abs(this.maxY() - this.minY());
    }

    public void add(Point2D pt) {
        if (pt == null) {
            return;
        }
        this.min.setLocation(Math.min(pt.getX(), this.minX()), Math.min(pt.getY(), this.minY()));
        this.max.setLocation(Math.max(pt.getX(), this.maxX()), Math.max(pt.getY(), this.maxY()));
    }

    public void add(Extent ext) {
        if (ext == null) {
            return;
        }
        this.min.setLocation(Math.min(ext.minX(), this.minX()), Math.min(ext.minY(), this.minY()));
        this.max.setLocation(Math.max(ext.maxX(), this.maxX()), Math.max(ext.maxY(), this.maxY()));
    }

    public double[] getScale(int width, int height) {
        return this.getScale((double)width, (double)height);
    }

    public double[] getScale(double width, double height) {
        double[] scale = new double[]{(double)((float)width) / this.width(), (double)((float)height) / this.height()};
        return scale;
    }

    public Rectangle2D toRectangle2D() {
        return new Rectangle2D.Double(this.minX(), this.minY(), this.width(), this.height());
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("####.000");
        return "Extent: (" + format.format(this.minX()) + "," + format.format(this.minY()) + "), (" + format.format(this.maxX()) + "," + format.format(this.maxY()) + ")";
    }

    public static interface Has {
        public Extent getExtent();
    }
}

