/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dissolve;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.algorithm.dissolve.IDissolveRule;
import org.gvsig.geoprocess.algorithm.dissolve.Summary;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DissolveOperationFast
extends GeometryOperation {
    private static Logger logger = LoggerFactory.getLogger((String)DissolveOperationFast.class.getName());
    private EditableFeature lastEditFeature = null;
    private ArrayList<Element> featureList = null;
    private IDissolveRule rule = null;
    private Summary summary = null;

    public DissolveOperationFast(IDissolveRule rule, AbstractSextanteGeoProcess p) {
        super(p);
        this.rule = rule;
        this.featureList = new ArrayList();
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        return null;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        if (g == null) {
            return;
        }
    }

    public Object getResult() {
        return this.lastEditFeature;
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureStore outFeatStore, String[] attrNames, boolean selectedGeomInput, boolean selectedGeomOutput, boolean closeOutStore) throws DataException {
        this.inFeatureStore = inFeatStore;
        FeatureSet featuresSet = null;
        featuresSet = inFeatStore.getFeatureSet();
        this.setFeatureStore(outFeatStore, attrNames);
        DisposableIterator it = null;
        if (selectedGeomInput) {
            FeatureSelection ds = inFeatStore.getFeatureSelection();
            it = ds.iterator();
            this.numberOfFeatures = (int)ds.getSelectedCount();
        } else {
            it = featuresSet.iterator();
            this.numberOfFeatures = (int)featuresSet.getSize();
        }
        if (this.status != null && this.process != null) {
            this.status.setRangeOfValues(0L, (long)this.numberOfFeatures);
            this.process.setProgress(0, this.numberOfFeatures);
        }
        int iCount = 0;
        while (it.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
            Feature feat = (Feature)it.next();
            Element el = new Element();
            el.feat = feat.getCopy();
            el.id = iCount;
            this.featureList.add(el);
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
        }
        for (iCount = 0; iCount < this.featureList.size() && !this.process.getTaskMonitor().isCanceled(); ++iCount) {
            Element elem1 = this.featureList.get(iCount);
            org.gvsig.fmap.geom.Geometry geom1 = elem1.feat.getDefaultGeometry();
            elem1.jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)geom1);
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            for (int i = iCount + 1; i < this.featureList.size(); ++i) {
                Element elem2 = this.featureList.get(i);
                org.gvsig.fmap.geom.Geometry geom2 = elem2.feat.getDefaultGeometry();
                elem2.jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)geom2);
                if (!this.rule.verifyIfDissolve(elem1.jtsGeom, elem2.jtsGeom, elem1.feat, elem2.feat)) continue;
                elem1.overlapList.add(elem2);
                elem2.overlapList.add(elem1);
            }
        }
        ArrayList listResult = new ArrayList();
        int iFeat = 0;
        this.summary = new Summary(this.rule, outFeatStore.getDefaultFeatureType());
        for (iCount = 0; iCount < this.featureList.size() && !this.process.getTaskMonitor().isCanceled(); ++iCount) {
            Element elem1 = this.featureList.get(iCount);
            this.summary.loadDefaultSummarizes(elem1.feat);
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            if (elem1.insertedToJoin) continue;
            this.buildListToJoin(elem1, iFeat);
            ++iFeat;
        }
        if (closeOutStore && this.persister != null) {
            this.persister.end();
        }
    }

    private Geometry computesUnion(List<Geometry> listResult, Element elem1) {
        int splitValue = 500;
        Geometry newGeom = null;
        if (listResult.size() > splitValue) {
            int i;
            List<List<Geometry>> list = this.splitList(listResult, splitValue);
            ArrayList<Geometry> result = new ArrayList<Geometry>();
            for (i = 0; i < list.size(); ++i) {
                Geometry aux = GeometryUtil.geometryUnion(list.get(i), (int)elem1.feat.getDefaultGeometry().getGeometryType().getType());
                result.add(aux);
            }
            for (i = 0; i < result.size(); ++i) {
                newGeom = GeometryUtil.geometryUnion(result, (int)elem1.feat.getDefaultGeometry().getGeometryType().getType());
            }
        } else {
            newGeom = GeometryUtil.geometryUnion(listResult, (int)elem1.feat.getDefaultGeometry().getGeometryType().getType());
        }
        return newGeom;
    }

    private Geometry computesUnion3(List<Geometry> listResult) {
        Geometry newGeom = null;
        int iCount = 0;
        int max = listResult.size();
        if (this.process != null) {
            this.process.setName("Generating union");
        }
        while (listResult.size() > 1) {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, max);
            }
            for (int i = 0; i < listResult.size(); i += 2) {
                if (i == listResult.size() - 1) {
                    list.add(listResult.get(i));
                    continue;
                }
                newGeom = JTSFacade.union((Geometry)listResult.get(i), (Geometry)listResult.get(i + 1));
                list.add(newGeom);
            }
            listResult = list;
        }
        return newGeom;
    }

    private List<List<Geometry>> splitList(List<Geometry> list, int n) {
        int elements = list.size() / n;
        ArrayList<List<Geometry>> l = new ArrayList<List<Geometry>>();
        for (int i = 0; i < elements; ++i) {
            l.add(list.subList(i * n, i * n + n));
        }
        if (elements * n < list.size()) {
            l.add(list.subList(elements * n, list.size()));
        }
        return l;
    }

    private void addFeatureToOutput(Geometry newGeom, Feature feat, int newFeatID) throws DataException, CreateGeometryException {
        EditableFeature result = this.persister.getOutputFeatureStore().createNewFeature();
        result.setDouble(0, (double)newFeatID);
        result.set(1, feat.get(this.rule.getFieldName()));
        result.setGeometry("GEOMETRY", GeometryUtil.jtsToGeom((Geometry)newGeom));
        this.summary.loadEditableFeature(result);
        this.lastEditFeature = this.persister.addFeature((Feature)result, result.getDefaultGeometry());
    }

    private void buildListToJoin(List<Geometry> listResult, List<Element> listToJoin) {
        for (int i = 0; i < listToJoin.size(); ++i) {
            Element elem = listToJoin.get(i);
            if (elem.insertedToJoin) continue;
            elem.insertedToJoin = true;
            this.buildListToJoin(listResult, elem.overlapList);
            this.summary.updateValues(elem.feat);
            listResult.add(elem.jtsGeom);
        }
    }

    private void buildListToJoin(Element elem, int iFeat) {
        Geometry newGeom = null;
        if (elem.overlapList.size() == 0) {
            if (!elem.insertedToJoin) {
                elem.insertedToJoin = true;
            }
            try {
                this.summary.updateValues(elem.feat);
                this.addFeatureToOutput(elem.jtsGeom, elem.feat, iFeat);
            }
            catch (CreateGeometryException e) {
                logger.info("Error a\u00f1adiendo geometr\u00eda", (Throwable)e);
            }
            catch (DataException e) {
                logger.info("Error a\u00f1adiendo geometr\u00eda", (Throwable)e);
            }
        } else {
            ArrayList<Geometry> listResult = new ArrayList<Geometry>();
            NodeTree subtree = new NodeTree(elem, null);
            while (subtree != null) {
                if (!subtree.element.insertedToJoin) {
                    listResult.add(subtree.element.jtsGeom);
                    this.summary.updateValues(subtree.element.feat);
                    subtree.element.insertedToJoin = true;
                }
                boolean back = false;
                Element l = subtree.getNext();
                if (l == null) {
                    back = true;
                }
                while (!back && l.insertedToJoin) {
                    l = subtree.getNext();
                    if (l != null) continue;
                    back = true;
                }
                if (back) {
                    subtree = subtree.parent;
                    continue;
                }
                subtree = new NodeTree(l, subtree);
            }
            newGeom = this.computesUnion3(listResult);
            try {
                this.addFeatureToOutput(newGeom, elem.feat, iFeat);
            }
            catch (DataException e) {
                logger.info("Imposible insertar en la tabla", (Throwable)e);
            }
            catch (CreateGeometryException e) {
                logger.info("Error a\u00f1adiendo geometr\u00eda", (Throwable)e);
            }
        }
    }

    class NodeTree {
        public Element element = null;
        public int pos = 0;
        public NodeTree parent = null;

        public NodeTree(Element node, NodeTree parent) {
            this.element = node;
            this.parent = parent;
        }

        public Element getNext() {
            if (this.pos < this.element.overlapList.size()) {
                return this.element.overlapList.get(this.pos++);
            }
            return null;
        }
    }

    class Element {
        public int id = -1;
        public Feature feat = null;
        public List<Element> overlapList = new ArrayList<Element>();
        public boolean insertedToJoin = false;
        public Geometry jtsGeom = null;

        Element() {
        }
    }
}

