/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.csv.CSVFeatureTypeLoader;
import org.gvsig.fmap.dal.store.csv.CSVFeatureWriter;
import org.gvsig.fmap.dal.store.csv.CSVStoreParameters;
import org.gvsig.fmap.dal.store.csv.simplereaders.CSVReaderSuperCSV;
import org.gvsig.fmap.dal.store.csv.simplereaders.FixedLenReader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFeatureTypeLoader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreProvider;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.SimpleReader;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.prefs.CsvPreference;

public class CSVStoreProvider
extends SimpleReaderStoreProvider
implements ResourceConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVStoreProvider.class);
    public static final String NAME = "CSV";
    public static final String DESCRIPTION = "CSV file";
    public static final String METADATA_DEFINITION_NAME = "CSV";
    protected final CSVFeatureWriter writer = new CSVFeatureWriter();

    public CSVStoreProvider(CSVStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((SimpleReaderStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer((String)"CSV"));
    }

    private CSVStoreParameters getCSVParameters() {
        return (CSVStoreParameters)this.getParameters();
    }

    public String getProviderName() {
        return "CSV";
    }

    public boolean allowWrite() {
        return true;
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        try {
            final I18nManager i18n = ToolsLocator.getI18nManager();
            this.taskStatus.add();
            this.taskStatus.message(i18n.getTranslation("_Preparing_writing"));
            this.getResource().closeRequest();
            this.getResource().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    FeatureSet features = null;
                    DisposableIterator it = null;
                    try {
                        File file = (File)CSVStoreProvider.this.resource.get();
                        features = CSVStoreProvider.this.getStoreServices().getFeatureStore().getFeatureSet();
                        CSVStoreProvider.this.taskStatus.message(i18n.getTranslation("_Writing_records"));
                        if (CSVStoreProvider.this.virtualrows == null) {
                            ArrayList<FeatureProvider> newdata = new ArrayList<FeatureProvider>();
                            FeatureType ftype = CSVStoreProvider.this.getStoreServices().getDefaultFeatureType();
                            CSVStoreProvider.this.writer.initialize(CSVStoreProvider.this.getCSVParameters(), file, ftype, CSVStoreProvider.this.getCSVPreferences(), CSVStoreProvider.this.spatialIndexes);
                            CSVStoreProvider.this.writer.begin();
                            it = features.fastIterator();
                            CSVStoreProvider.this.taskStatus.setRangeOfValues(0L, features.getSize());
                            CSVStoreProvider.this.taskStatus.setCurValue(0L);
                            while (it.hasNext()) {
                                CSVStoreProvider.this.taskStatus.incrementCurrentValue();
                                FeatureProvider feature = CSVStoreProvider.this.getStoreServices().getFeatureProviderFromFeature((Feature)it.next());
                                CSVStoreProvider.this.writer.add(feature);
                                if (feature.getOID() == null) {
                                    LOGGER.warn("feature without OID");
                                    feature.setOID(CSVStoreProvider.this.createNewOID());
                                }
                                newdata.add(feature);
                            }
                            CSVStoreProvider.this.data = newdata;
                            if (CSVStoreProvider.this.writer.getEnvelopes() != null) {
                                CSVStoreProvider.this.envelopes = CSVStoreProvider.this.writer.getEnvelopes();
                            } else {
                                CSVStoreProvider.this.envelopes = null;
                            }
                            CSVStoreProvider.this.resource.notifyChanges();
                            CSVStoreProvider.this.writer.end();
                            CSVStoreProvider.this.bboxFileSave(CSVStoreProvider.this.envelopes);
                        } else {
                            CSVStoreParameters csvParams = CSVStoreProvider.this.getCSVParameters();
                            CSVStoreParameters tmpParams = (CSVStoreParameters)csvParams.getCopy();
                            String tmpBase = File.createTempFile("tmp_" + System.currentTimeMillis(), null).getAbsolutePath();
                            File tmpFile = new File(tmpBase + ".csv");
                            tmpParams.setFile(tmpFile);
                            FeatureType ftype = CSVStoreProvider.this.getStoreServices().getDefaultFeatureType();
                            CSVStoreProvider.this.writer.initialize(tmpParams, tmpFile, ftype, CSVStoreProvider.this.getCSVPreferences(), CSVStoreProvider.this.spatialIndexes);
                            CSVStoreProvider.this.writer.begin();
                            it = features.fastIterator();
                            CSVStoreProvider.this.taskStatus.setIndeterminate();
                            CSVStoreProvider.this.taskStatus.setCurValue(0L);
                            while (it.hasNext()) {
                                CSVStoreProvider.this.taskStatus.incrementCurrentValue();
                                if (CSVStoreProvider.this.taskStatus.isCancellationRequested()) {
                                    CSVStoreProvider.this.taskStatus.cancel();
                                    LOGGER.info("CSV writing canceled (" + CSVStoreProvider.this.getFullFileName() + ")");
                                    break;
                                }
                                FeatureProvider feature = CSVStoreProvider.this.getStoreServices().getFeatureProviderFromFeature((Feature)it.next());
                                CSVStoreProvider.this.writer.add(feature);
                                if (feature.getOID() != null) continue;
                                LOGGER.warn("feature without OID");
                                feature.setOID(CSVStoreProvider.this.createNewOID());
                            }
                            if (CSVStoreProvider.this.writer.getEnvelopes() != null) {
                                CSVStoreProvider.this.envelopes = CSVStoreProvider.this.writer.getEnvelopes();
                            } else {
                                CSVStoreProvider.this.envelopes = null;
                            }
                            CSVStoreProvider.this.resource.notifyChanges();
                            CSVStoreProvider.this.writer.end();
                            if (!CSVStoreProvider.this.taskStatus.isCancelled()) {
                                if (!csvParams.getFile().delete()) {
                                    LOGGER.debug("Can't delete csv file '" + csvParams.getFile() + "'.");
                                    throw new IOException("Can't delete csv '" + FilenameUtils.getBaseName((String)csvParams.getFile().getAbsolutePath()) + "' file to replace with the new csv.\nThe new csv is in temporary file '" + tmpFile.getAbsolutePath() + "'");
                                }
                                File csvFile = csvParams.getFile();
                                FileUtils.moveFile((File)tmpParams.getFile(), (File)csvFile);
                                FileUtils.delete((File)new File(FilenameUtils.removeExtension((String)csvFile.getAbsolutePath()) + ".idx"));
                                CSVStoreProvider.this.bboxFileSave(CSVStoreProvider.this.envelopes);
                                CSVStoreProvider.this.loadFeatures();
                            }
                        }
                    }
                    finally {
                        if (it != null) {
                            it.dispose();
                        }
                        if (features != null) {
                            features.dispose();
                        }
                    }
                    return null;
                }
            });
            this.taskStatus.terminate();
        }
        catch (Exception e) {
            this.taskStatus.abort();
            throw new PerformEditingException(this.getResource().toString(), (Throwable)e);
        }
    }

    private CsvPreference getCSVPreferences() {
        CSVReaderSuperCSV reader = new CSVReaderSuperCSV(this.getCSVParameters());
        return reader.getCSVPreferences();
    }

    public boolean supportsAppendMode() {
        return true;
    }

    public void append(final FeatureProvider featureProvider) {
        this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                CSVStoreProvider.this.writer.add(featureProvider);
                return null;
            }
        });
    }

    public void beginAppend() throws DataException {
        this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                CSVStoreProvider.this.writer.initialize(CSVStoreProvider.this.getCSVParameters(), CSVStoreProvider.this.getCSVParameters().getFile(), CSVStoreProvider.this.getFeatureStore().getDefaultFeatureType(), CSVStoreProvider.this.getCSVPreferences(), CSVStoreProvider.this.spatialIndexes);
                CSVStoreProvider.this.writer.beginAppend();
                return null;
            }
        });
    }

    public void endAppend() {
        try {
            this.getResource().execute(new ResourceAction(){

                public Object run() throws Exception {
                    CSVStoreProvider.this.writer.end();
                    CSVStoreProvider.this.resource.notifyChanges();
                    CSVStoreProvider.this.counterNewsOIDs = -1L;
                    return null;
                }
            });
            this.envelopes = this.writer.getEnvelopes() != null ? this.writer.getEnvelopes() : null;
            this.writer.end();
            this.close();
            this.bboxFileSave(this.envelopes);
        }
        catch (Exception ex) {
            LOGGER.warn("Not been able to end append '" + this.getFullName() + "'.", (Throwable)ex);
        }
    }

    protected boolean mustFixFeatureType() {
        try {
            FeatureAttributeDescriptor attr;
            if (super.mustFixFeatureType()) {
                return true;
            }
            String param_types_def = CSVStoreParameters.getRawFieldTypes((DynObject)this.getParameters());
            String[] pointDimensionNames = CSVStoreParameters.getPointDimensionNames((DynObject)this.getParameters());
            String geometry_column = CSVStoreParameters.getGeometryColumn((DynObject)this.getParameters());
            FeatureType dalFeatureType = this.getStoreServices().getDefaultFeatureType();
            if (StringUtils.isNotBlank((CharSequence)geometry_column) && ((attr = dalFeatureType.getAttributeDescriptor(geometry_column)) == null || attr.getType() != 66)) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)param_types_def) || pointDimensionNames != null) {
                for (FeatureAttributeDescriptor dalAttr : dalFeatureType) {
                    if (dalAttr.isComputed()) continue;
                    FeatureAttributeDescriptor csvAttr = this.featureType.getAttributeDescriptor(dalAttr.getName());
                    if (csvAttr == null) {
                        return true;
                    }
                    if (dalAttr.get("all").equals(csvAttr.get("all"))) continue;
                    return true;
                }
            }
        }
        catch (DataException ex) {
            LOGGER.warn("Can't check if should fix the feature type", (Throwable)ex);
        }
        return false;
    }

    protected SimpleReader getSimpleReader(SimpleReaderStoreParameters parameters, Reader in) throws IOException {
        Object reader = CSVStoreParameters.getRawFieldsDefinition((DynObject)parameters) != null ? new FixedLenReader(in, (CSVStoreParameters)parameters) : new CSVReaderSuperCSV(in, (CSVStoreParameters)parameters);
        return reader;
    }

    protected SimpleReaderFeatureTypeLoader getFeatureTypeLoader() {
        return new CSVFeatureTypeLoader(this.getCSVParameters());
    }

    public List<String> getRowByIndex(long index) {
        List line = super.getRowByIndex(index);
        if (line != null) {
            for (int i = 0; i < line.size(); ++i) {
                String s = (String)line.get(i);
                line.set(i, CSVReaderSuperCSV.unescapeCRLF(s));
            }
        }
        return line;
    }
}

