/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv.simplereaders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.fmap.dal.store.csv.CSVStoreParameters;
import org.gvsig.fmap.dal.store.csv.virtualrows.SuperCSVList;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.AbstractSimpleReader;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileIndex;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileReader;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.GetItemWithSize64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentStartsWith;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.quote.QuoteMode;

public class CSVReaderSuperCSV
extends AbstractSimpleReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVReaderSuperCSV.class);
    private CsvListReader reader = null;
    private final CSVStoreParameters parameters;
    private List<String> nextLine;
    private int columns;

    public CSVReaderSuperCSV(Reader in, CSVStoreParameters parameters) {
        this(parameters);
        this.reader = new CsvListReader(in, this.getCSVPreferences());
    }

    public CSVReaderSuperCSV(CSVStoreParameters parameters) {
        this.parameters = parameters;
        this.reader = null;
        this.nextLine = null;
        this.columns = 0;
    }

    public CSVStoreParameters getParameters() {
        return this.parameters;
    }

    public String[] getHeader() throws IOException {
        return this.reader.getHeader(true);
    }

    public int getColumnsCount() throws IOException {
        if (this.columns <= 0) {
            this.columns = this.reader.length();
            if (this.columns <= 0) {
                this.nextLine = this.reader.read();
                this.columns = this.reader.length();
            }
        }
        return this.columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMultilineRecords(SimpleTaskStatus status) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        boolean bl;
        FileInputStream fis = null;
        InputStreamReader theReader = null;
        BufferedReader breader = null;
        try {
            CSVStoreParameters params = this.getParameters();
            File data_file = CSVStoreParameters.getFile((DynObject)params);
            String charset = CSVStoreParameters.getCharset((DynObject)params);
            fis = new FileInputStream(data_file);
            theReader = new InputStreamReader((InputStream)fis, charset);
            breader = new BufferedReader(theReader);
            CsvListReader parser = new CsvListReader((Reader)breader, this.getCSVPreferences());
            while (parser.read() != null) {
                if (parser.getLineNumber() == parser.getRowNumber()) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(breader);
            IOUtils.closeQuietly(theReader);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        {
            IOUtils.closeQuietly((Reader)breader);
            IOUtils.closeQuietly((Reader)theReader);
            IOUtils.closeQuietly((InputStream)fis);
            return bl;
        }
        boolean bl2 = false;
        IOUtils.closeQuietly((Reader)breader);
        IOUtils.closeQuietly((Reader)theReader);
        IOUtils.closeQuietly((InputStream)fis);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetItemWithSize64<List<String>> getVirtualRows(SimpleTaskStatus status) {
        File data_file;
        CSVStoreParameters params;
        RandomAccessFileIndex theIndex;
        RandomAccessFileReader theReader;
        block8: {
            theReader = null;
            theIndex = null;
            params = this.getParameters();
            data_file = CSVStoreParameters.getFile((DynObject)params);
            if (data_file.length() >= 0xA00000L) break block8;
            GetItemWithSize64<List<String>> getItemWithSize64 = null;
            return getItemWithSize64;
        }
        try {
            String charset = CSVStoreParameters.getCharset((DynObject)params);
            File index_file = CSVReaderSuperCSV.getIndexFile(data_file);
            theReader = new RandomAccessFileReader(data_file, charset);
            Function<BufferedReader, Integer> numberOfLinesInRecord = null;
            if (theReader.isRecomendedTheRecreationOfTheLinesIndex(index_file)) {
                if (this.hasMultilineRecords(status)) {
                    numberOfLinesInRecord = new Function<BufferedReader, Integer>(){

                        @Override
                        public Integer apply(BufferedReader breader) {
                            CloseShieldReader theReader = CloseShieldReader.wrap((Reader)breader);
                            CsvListReader parser = new CsvListReader((Reader)theReader, CSVReaderSuperCSV.this.getCSVPreferences());
                            try {
                                List list = parser.read();
                            }
                            catch (IOException ex) {
                                return 1;
                            }
                            return parser.getLineNumber();
                        }
                    };
                }
                theIndex = theReader.createOrOpenIndexOfLines(index_file, false, RandomAccessFileReader.FILTER_NONE, status, (Function)numberOfLinesInRecord);
            } else {
                theIndex = new RandomAccessFileIndex(index_file);
            }
            SuperCSVList list = new SuperCSVList(theReader, theIndex, CSVStoreParameters.isFirstLineHeader((DynObject)this.getParameters()) ? 1 : 0);
            list.setPreferences(this.getCSVPreferences());
            SuperCSVList superCSVList = list;
            return superCSVList;
        }
        catch (IOException ex) {
            GetItemWithSize64<List<String>> getItemWithSize64 = null;
            return getItemWithSize64;
        }
    }

    public List<String> read() throws IOException {
        List line;
        if (this.nextLine != null) {
            line = this.nextLine;
            this.nextLine = null;
        } else {
            line = this.reader.read();
        }
        if (line != null) {
            for (int i = 0; i < line.size(); ++i) {
                String s = (String)line.get(i);
                if (s == null) continue;
                line.set(i, CSVReaderSuperCSV.unescapeCRLF(s));
            }
        }
        return line;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public List<String> skip(int lines) throws IOException {
        if (lines <= 0) {
            return null;
        }
        if (this.nextLine != null) {
            this.nextLine = null;
            --lines;
        }
        List row = null;
        for (int i = 0; i < lines; ++i) {
            row = this.reader.read();
        }
        return row;
    }

    public final CsvPreference getCSVPreferences() {
        try {
            String s;
            String endOfLineSymbols;
            CSVStoreParameters params = this.getParameters();
            CsvPreference defaultPreference = CSVStoreParameters.getPredefinedCSVPreferences((DynObject)params);
            if (defaultPreference == null) {
                defaultPreference = CsvPreference.STANDARD_PREFERENCE;
            }
            if (StringUtils.isBlank((CharSequence)(endOfLineSymbols = CSVStoreParameters.getRecordSeparator((DynObject)params)))) {
                endOfLineSymbols = defaultPreference.getEndOfLineSymbols();
            }
            char quoteChar = StringUtils.isBlank((CharSequence)(s = CSVStoreParameters.getQuoteCharacter((DynObject)params))) ? (char)defaultPreference.getQuoteChar() : s.charAt(0);
            s = CSVStoreParameters.getDelimiter((DynObject)params);
            int delimiterChar = StringUtils.isBlank((CharSequence)s) ? defaultPreference.getDelimiterChar() : (int)s.charAt(0);
            CsvPreference.Builder builder = new CsvPreference.Builder(quoteChar, delimiterChar, endOfLineSymbols);
            s = CSVStoreParameters.getCommentStartMarker((DynObject)params);
            if (!StringUtils.isBlank((CharSequence)s)) {
                CommentStartsWith cs = new CommentStartsWith(s);
                builder.skipComments((CommentMatcher)cs);
            }
            builder.surroundingSpacesNeedQuotes(CSVStoreParameters.getSurroundingSpacesNeedQuotes((DynObject)params));
            QuoteMode quoteMode = CSVStoreParameters.getQuoteMode((DynObject)params);
            if (quoteMode != null) {
                builder.useQuoteMode(quoteMode);
            }
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.warn("Can't make preferences for CSV '" + this.getFullFileName() + "'.", (Throwable)e);
            return null;
        }
    }

    private String getFullFileName() {
        String s;
        try {
            s = this.getParameters().getFile().getAbsolutePath();
        }
        catch (Exception e2) {
            s = "(unknow)";
        }
        return s;
    }

    public int getLine() {
        if (this.reader == null) {
            return 0;
        }
        return this.reader.getLineNumber();
    }

    public List<String> nextRowValues() {
        try {
            return this.read();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String escapeCRLF(String s) {
        if (s == null) {
            return s;
        }
        String s1 = s;
        s1 = StringUtils.replace((String)s1, (String)"\\", (String)"\\\\");
        s1 = StringUtils.replace((String)s1, (String)"\n", (String)"\\n");
        s1 = StringUtils.replace((String)s1, (String)"\r", (String)"\\r");
        return s1;
    }

    public static String unescapeCRLF(String s) {
        if (s == null || s.indexOf(92) == -1) {
            return s;
        }
        String s1 = s;
        s1 = s.replaceAll("(?:^\\\\n)|(?:([^\\\\])\\\\n)", "$1\n");
        s1 = s1.replaceAll("(?:^\\\\r)|(?:([^\\\\])\\\\n)", "$1\r");
        s1 = StringUtils.replace((String)s1, (String)"\\\\", (String)"\\");
        return s1;
    }

    public static void main(String[] args) {
        String s0 = "\\n{\\n   \"ANGULO\":\"0.000\",\\n    \"\tEXTO\":\"RAVAL ROIG\\\\r\\\\n - \\\\r\\\\nVIRGEN DEL SOCORRO\",\\n    \"LINK_POLIGONO\":\"HVCSGISCODE_ENT_11230100000000001\",\\n    \"GEOMETRY\":\"00000000014125fe9b57b4a23441503411cb1c432d\"\\n}";
        System.out.println("#" + s0 + "#");
        String s1 = s0.replaceAll("(?:^\\\\n)|(?:([^\\\\])\\\\n)", "$1\n");
        System.out.println("#" + s1 + "#");
        String s2 = s1.replaceAll("([^\\\\])\\\\r", "$1{r}");
        System.out.println("#" + s2 + "#");
        String s3 = StringEscapeUtils.unescapeCsv((String)s0);
        System.out.println("#" + s3 + "#");
    }

    public static File getIndexFile(File data_file) {
        if (data_file == null) {
            return null;
        }
        File index_file = new File(FilenameUtils.removeExtension((String)data_file.getAbsolutePath()) + ".idx");
        return index_file;
    }
}

